/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.packagelist.model.PackageListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class PackageTable
extends JTable {
    private static final int ALTERNATING = 10;
    private static final Color NORMALROWCOLOR = UIManager.getColor("Table.background");
    private static final Color ALTERNATINGROWCOLOR = PackageTable.createAlternatingColor(NORMALROWCOLOR, 10);
    private static final int CELLPADDING = 2;
    private final EmptyBorder border = new EmptyBorder(0, 2, 0, 2);

    public PackageTable(PackageListModel maplist) {
        super(maplist);
        TableRowSorter<PackageListModel> sorter = new TableRowSorter<PackageListModel>(maplist);
        this.setRowSorter(sorter);
        this.setPreferredScrollableViewportSize(new Dimension(500, 500));
        this.setFillsViewportHeight(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setDefaultRenderer(Package.Rating.class, new PackageListModel.RatingRenderer());
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (!this.isCellSelected(row, column)) {
            c.setBackground(this.colorForRow(row));
            c.setForeground(UIManager.getColor("Table.foreground"));
        } else {
            c.setBackground(UIManager.getColor("Table.selectionBackground"));
            c.setForeground(UIManager.getColor("Table.selectionForeground"));
        }
        if (c instanceof JComponent) {
            if (!(c instanceof PackageListModel.RatingRenderer)) {
                ((JComponent)c).setBorder(this.border);
            } else {
                ((JComponent)c).setBorder(new EmptyBorder(0, 0, 0, 0));
            }
        }
        return c;
    }

    protected Color colorForRow(int row) {
        return row % 2 == 0 ? NORMALROWCOLOR : ALTERNATINGROWCOLOR;
    }

    public TableRowSorter<PackageListModel> getRowSorter() {
        return (TableRowSorter)super.getRowSorter();
    }

    public static Color createAlternatingColor(Color c, int amount) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return new Color(r > 127 ? r - amount : r + amount, g > 127 ? g - amount : g + amount, b > 127 ? b - amount : b + amount);
    }
}

