/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.ChangeListenerList;
import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.UnavailableRequirement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeListener;

public class RequirementList
implements Iterable<Requirement> {
    private HashMap<String, Integer> names = new HashMap();
    private List<Requirement> requirements;
    private ChangeListenerList listeners = new ChangeListenerList();

    public RequirementList() {
        this.requirements = Collections.emptyList();
    }

    public RequirementList(List<Requirement> requirements) {
        this.setRequirements(requirements);
    }

    public void setRequirements(List<Requirement> requirements) {
        this.names.clear();
        for (int i = 0; i < requirements.size(); ++i) {
            this.names.put(requirements.get(i).getId(), i);
        }
        this.requirements = requirements;
    }

    public void setInstalled(PackageFileList l) {
        Requirement r = this.get(l.getId());
        if (r instanceof UnavailableRequirement) {
            System.err.println("Can't set installed on UnavailableRequirement " + l.getId());
            return;
        }
        r.setInstalled(true);
        if (r instanceof Package) {
            ((Package)r).setFileList(l);
        }
    }

    public Requirement get(int i) {
        return this.requirements.get(i);
    }

    public Requirement get(String id) {
        Integer i = this.names.get(id);
        if (i == null) {
            return new UnavailableRequirement(id);
        }
        return this.requirements.get(i);
    }

    @Override
    public Iterator<Requirement> iterator() {
        return this.requirements.iterator();
    }

    public int size() {
        return this.requirements.size();
    }

    public int indexOf(Requirement r) {
        return this.requirements.indexOf(r);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.removeChangeListener(l);
    }

    public void notifyChangeListeners() {
        this.listeners.notifyChangeListeners(this);
    }
}

