/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.RequirementList;
import de.haukerehfeld.quakeinjector.ThreadedGetter;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public class UpdateRequirementListWorker
extends SwingWorker<Void, Void> {
    private final RequirementList requirementList;
    private final ThreadedGetter<List<Requirement>> requirementGetter;
    private final ThreadedGetter<List<PackageFileList>> installedGetter;
    private List<Requirement> requirement;
    private List<PackageFileList> installed;

    public UpdateRequirementListWorker(RequirementList requirementList, ThreadedGetter<List<Requirement>> requirements, ThreadedGetter<List<PackageFileList>> installed) {
        this.requirementList = requirementList;
        this.requirementGetter = requirements;
        this.installedGetter = installed;
    }

    @Override
    public Void doInBackground() {
        try {
            this.requirement = this.requirementGetter.get();
            this.installed = this.installedGetter.get();
        }
        catch (ExecutionException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            System.err.println("Couldn't wait for results!" + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        RequirementList requirementList = this.requirementList;
        synchronized (requirementList) {
            this.requirementList.setRequirements(this.requirement);
            for (PackageFileList l : this.installed) {
                this.requirementList.setInstalled(l);
            }
            this.requirementList.notifyChangeListeners();
        }
    }
}

