/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.ProgressListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.swing.ImageIcon;

public class Utils {
    public static final int BUFFERSIZE = 4096;

    public static <T> String join(Iterable<T> objs, String delimiter) {
        Iterator<T> iter = objs.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(String.valueOf(iter.next()));
        while (iter.hasNext()) {
            buffer.append(delimiter).append(String.valueOf(iter.next()));
        }
        return buffer.toString();
    }

    public static List<File> mkdirs(File f) {
        ArrayList<File> files = new ArrayList<File>();
        if (f.isDirectory()) {
            files.add(f);
        }
        for (File parentDir = f.getParentFile(); parentDir != null && !parentDir.exists(); parentDir = parentDir.getParentFile()) {
            files.add(parentDir);
        }
        Collections.reverse(files);
        for (File dir : files) {
            System.out.println("Creating dir " + dir);
            dir.mkdir();
        }
        return files;
    }

    public static long writeFile(InputStream in, File file, ProgressListener progress) throws IOException {
        return Utils.writeFile(in, file, 2048, progress);
    }

    public static long writeFile(InputStream in, File file, int BUFFERSIZE, ProgressListener progress) throws IOException {
        BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(file), BUFFERSIZE);
        long crc = Utils.copy(in, dest, BUFFERSIZE, progress);
        dest.close();
        return crc;
    }

    public static long copy(InputStream in, OutputStream out, int BUFFERSIZE, ProgressListener progress) throws IOException {
        int readcount;
        byte[] data = new byte[BUFFERSIZE];
        CRC32 crc = new CRC32();
        while ((readcount = in.read(data, 0, BUFFERSIZE)) != -1) {
            if (progress != null) {
                progress.publish(readcount);
            }
            out.write(data, 0, readcount);
            crc.update(data, 0, readcount);
        }
        out.flush();
        return crc.getValue();
    }

    public static long getCrc32(InputStream in, ProgressListener progress) throws IOException {
        return Utils.copy(in, new NoOutputStream(), 4096, progress);
    }

    public static ImageIcon createImageIcon(String path, String description) throws IOException {
        URL imgURL = Utils.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        throw new IOException("Couldn't find file: " + path);
    }

    public static class NoOutputStream
    extends OutputStream {
        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }
    }
}

