/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static Element getFirstElement(Element parent, String name) {
        NodeList list = parent.getElementsByTagName(name);
        Node node = list.item(0);
        if (node == null) {
            return null;
        }
        if (!XmlUtils.isElement(node)) {
            throw new RuntimeException("XML Parsing error: " + name + " is not an Element");
        }
        return (Element)node;
    }

    public static Document getDocument(InputStream xml) throws IOException, SAXException {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Parser misconfiguration");
        }
        Document doc = db.parse(xml);
        return doc;
    }

    public static Iterable<Node> iterate(NodeList list) {
        return new NodeListIterator(list);
    }

    public static boolean isElement(Node n) {
        return n.getNodeType() == 1;
    }

    public static String getTextForNode(Node node) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return "";
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() != 3 && childNode.getNodeType() != 4) continue;
            return childNode.getNodeValue();
        }
        return "";
    }

    public static class NodeListIterator
    implements Iterator<Node>,
    Iterable<Node> {
        private NodeList list;
        private int i = 0;

        public NodeListIterator(NodeList list) {
            this.list = list;
        }

        @Override
        public Node next() {
            ++this.i;
            return this.list.item(this.i);
        }

        @Override
        public boolean hasNext() {
            return this.i + 1 < this.list.getLength();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Node> iterator() {
            return this;
        }
    }
}

