/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Configuration;
import de.haukerehfeld.quakeinjector.FileInfo;
import de.haukerehfeld.quakeinjector.InspectZipWorker;
import de.haukerehfeld.quakeinjector.InstalledPackageList;
import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.PackageDatabaseParserWorker;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.Utils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;

public class ZipInspect {
    private static final String file = "zipFiles.xml";
    private static final String oldSelectionsFile = "essentialfiles.cfg";

    public static void main(String[] args) {
        String parentDir;
        Console con = System.console();
        if (con == null) {
            System.err.println("Don't start from ant, it doesn't support an interactive console!");
            System.exit(1);
        }
        if (args.length < 1) {
            System.err.println("First parameter need's to be a valid directory!");
            System.exit(1);
        }
        if (!new File(parentDir = args[0]).exists()) {
            System.err.println("First parameter need's to be a valid directory!");
            System.exit(1);
        }
        Configuration config = new Configuration();
        List requirements = null;
        PackageDatabaseParserWorker requirementsParser = new PackageDatabaseParserWorker((String)config.RepositoryDatabasePath.get());
        requirementsParser.execute();
        try {
            requirements = (List)requirementsParser.get();
        }
        catch (Exception e) {
            System.err.println("Couldn't get packages " + e);
            e.printStackTrace();
            System.exit(1);
        }
        Collections.sort(requirements);
        TreeMap<Package, PackageFileList> packageFiles = new TreeMap<Package, PackageFileList>();
        TreeMap<String, ArrayList<AbstractMap.SimpleEntry<Package, FileInfo>>> duplicateFiles = new TreeMap<String, ArrayList<AbstractMap.SimpleEntry<Package, FileInfo>>>();
        for (Requirement r : requirements) {
            if (!(r instanceof Package)) continue;
            Package p = (Package)r;
            p.setInstalled(true);
            File f = new File(parentDir + File.separator + r.getId() + ".zip");
            if (!f.exists()) {
                System.out.println("WARNING: " + f + " doesn't exist!");
                continue;
            }
            System.out.println(f);
            try {
                FileInputStream in = new FileInputStream(f);
                InspectZipWorker inspector = new InspectZipWorker(in);
                inspector.execute();
                List entries = (List)inspector.get();
                PackageFileList zipFiles = new PackageFileList(p.getId());
                String dir = p.getRelativeBaseDir();
                for (ZipEntry e : entries) {
                    String file = "";
                    if (dir != null) {
                        file = dir;
                    }
                    file = file + e.getName();
                    FileInfo info = new FileInfo(file, e.getCrc());
                    zipFiles.add(info);
                    ArrayList<AbstractMap.SimpleEntry<Package, FileInfo>> dupMaps = (ArrayList<AbstractMap.SimpleEntry<Package, FileInfo>>)duplicateFiles.get(file.toLowerCase());
                    if (dupMaps == null) {
                        dupMaps = new ArrayList<AbstractMap.SimpleEntry<Package, FileInfo>>();
                        duplicateFiles.put(file.toLowerCase(), dupMaps);
                    }
                    dupMaps.add(new AbstractMap.SimpleEntry<Package, FileInfo>(p, info));
                }
                p.setFileList(zipFiles);
                packageFiles.put(p, zipFiles);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        HashMap<String, Boolean> oldSelections = new HashMap<String, Boolean>();
        if (new File(oldSelectionsFile).exists()) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(oldSelectionsFile));
                while ((line = in.readLine()) != null) {
                    String[] l = line.split(",");
                    oldSelections.put(l[0], Boolean.parseBoolean(l[1]));
                }
                in.close();
            }
            catch (IOException e) {
                System.err.println("Couldn't read old selections file");
            }
        }
        StringBuilder selectionsFile = new StringBuilder();
        for (String file : duplicateFiles.keySet()) {
            List dups = (List)duplicateFiles.get(file);
            int count = dups.size();
            if (count <= 1) continue;
            ArrayList<String> packages = new ArrayList<String>();
            boolean crcDiffers = false;
            long crc = -1L;
            for (Map.Entry e : dups) {
                if (crc != -1L && crc != ((FileInfo)e.getValue()).getChecksum()) {
                    crcDiffers = true;
                }
                crc = ((FileInfo)e.getValue()).getChecksum();
                packages.add(((Package)e.getKey()).getId() + " (crc: " + crc + ")");
            }
            boolean essential = true;
            if (!crcDiffers && crc == 0L) {
                System.out.println(file + " has duplicates, but all with crc == 0," + " setting to inessential");
                essential = false;
            } else if (oldSelections.get(file) != null) {
                essential = (Boolean)oldSelections.get(file);
                System.out.println(file + " has duplicates, but was previously declared:" + " essential = " + essential);
            } else {
                System.out.println(file + " has " + (crcDiffers ? " differing CRC " : " equal ") + "duplicates in " + Utils.join(packages, ", "));
                System.out.println("Is this an essential file? (No: n + RETURN, Yes: RETURN)");
                String yes = con.readLine();
                if (yes != null && yes.equals("n")) {
                    essential = false;
                }
            }
            for (Map.Entry e : dups) {
                ((FileInfo)e.getValue()).setEssential(essential);
            }
            selectionsFile.append(file + "," + essential + "\n");
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(oldSelectionsFile));
            out.write(selectionsFile.toString());
            out.close();
        }
        catch (IOException e) {
            System.err.println("Couldn't write selections to outfile! " + e);
        }
        try {
            new InstalledPackageList().write((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), packageFiles.keySet());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

