/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector.gui;

import de.haukerehfeld.quakeinjector.ChangeListenerList;
import de.haukerehfeld.quakeinjector.RelativePath;
import de.haukerehfeld.quakeinjector.gui.ErrorListener;
import de.haukerehfeld.quakeinjector.gui.SimpleErrorEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JPathPanel
extends JPanel {
    private final ArrayList<ErrorListener> errorListeners = new ArrayList();
    private final ChangeListenerList changeListeners = new ChangeListenerList();
    private static final int inputLength = 32;
    private File basePath;
    private final JTextField path;
    private final JLabel errorLabel;
    private final JButton fileChooserButton;
    private final JFileChooser chooser;
    private final Verifier check;
    private boolean absolute = false;

    public JPathPanel(Verifier check, File defaultPath, int filesAndOrDirectories) {
        this(check, defaultPath, null, filesAndOrDirectories);
    }

    public JPathPanel(Verifier check, File defaultPath, File basePath, int filesAndOrDirectories) {
        this.check = check;
        this.basePath = basePath;
        if (defaultPath == null) {
            defaultPath = new File("");
        }
        this.setLayout(new BoxLayout(this, 2));
        this.absolute = defaultPath.isAbsolute();
        this.path = new JTextField(defaultPath.toString(), 32);
        PathVerifier verifier = new PathVerifier();
        this.path.setInputVerifier(verifier);
        this.path.getDocument().addDocumentListener(verifier);
        this.add(this.path);
        this.errorLabel = new JLabel();
        this.add(this.errorLabel);
        this.chooser = new JFileChooser(this.getPath());
        this.chooser.setFileSelectionMode(filesAndOrDirectories);
        this.fileChooserButton = new JButton("Select");
        this.fileChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = JPathPanel.this.chooser.showOpenDialog(JPathPanel.this);
                if (returnVal == 0) {
                    File file = JPathPanel.this.chooser.getSelectedFile();
                    JPathPanel.this.setPath(file);
                }
            }
        });
        this.add(this.fileChooserButton);
    }

    public boolean verifies() {
        return this.check();
    }

    public boolean verify() {
        if (!this.check()) {
            this.notifyErrorListeners();
            return false;
        }
        this.chooser.setCurrentDirectory(this.getPath());
        this.notifyChangeListeners();
        return true;
    }

    private boolean check() {
        File f = this.getPath();
        this.errorLabel.setText(this.check.errorMessage(f));
        return this.check.verify(f);
    }

    public void setBasePath(File basePath) {
        File oldFile = this.getPath();
        boolean verifies = this.verifies();
        this.basePath = basePath;
        if (verifies) {
            this.setPath(oldFile);
        }
        this.chooser.setCurrentDirectory(this.getPath());
        this.verify();
    }

    public void setPath(String path) {
        this.setPath(new File(path));
    }

    public void setPath(File path) {
        String pathString;
        if (this.basePath != null) {
            File relative = RelativePath.getRelativePath(this.basePath, path);
            this.absolute = relative.isAbsolute();
            pathString = relative.toString();
        } else {
            pathString = path.getAbsolutePath();
        }
        this.path.setText(pathString);
    }

    public File getPath() {
        String path = this.path.getText();
        if (path == null) {
            path = "";
        }
        File file = this.basePath != null && !this.absolute ? new File(this.basePath.getAbsolutePath() + File.separator + path) : new File(path);
        return file;
    }

    public void addErrorListener(ErrorListener e) {
        this.errorListeners.add(e);
    }

    private void notifyErrorListeners() {
        SimpleErrorEvent e = new SimpleErrorEvent(this);
        for (ErrorListener l : this.errorListeners) {
            l.errorOccured(e);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.addChangeListener(l);
    }

    private void notifyChangeListeners() {
        this.changeListeners.notifyChangeListeners(this);
    }

    private boolean verify_() {
        return this.verify();
    }

    private class PathVerifier
    extends InputVerifier
    implements DocumentListener {
        private PathVerifier() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JPathPanel.this.verify_();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JPathPanel.this.verify_();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JPathPanel.this.verify_();
        }

        @Override
        public boolean verify(JComponent input) {
            return JPathPanel.this.verify_();
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            JPathPanel.this.verify_();
            return true;
        }
    }

    public static class WritableDirectoryVerifier
    implements Verifier {
        @Override
        public boolean verify(File f) {
            return f.exists() && f.isDirectory() && f.canRead() && f.canWrite();
        }

        @Override
        public String errorMessage(File f) {
            if (!f.exists()) {
                return "Doesn't exist!";
            }
            if (!f.isDirectory()) {
                return "Is not a directory!";
            }
            if (!f.canWrite()) {
                return "Cannot be written to!";
            }
            return null;
        }
    }

    public static interface Verifier {
        public boolean verify(File var1);

        public String errorMessage(File var1);
    }
}

