/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector.packagelist.model;

import de.haukerehfeld.quakeinjector.ChangeListenerList;
import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.PackageList;
import de.haukerehfeld.quakeinjector.Utils;
import de.haukerehfeld.quakeinjector.packagelist.model.Column;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class PackageListModel
extends AbstractTableModel
implements ChangeListener {
    private ChangeListenerList listeners = new ChangeListenerList();
    private PackageList data;

    public PackageListModel(PackageList data) {
        this.setMapList(data);
    }

    public void size(JTable table) {
        TableColumnModel m = table.getColumnModel();
        m.getColumn(Column.getColumnNumber(Column.NAME)).setPreferredWidth(80);
        m.getColumn(Column.getColumnNumber(Column.TITLE)).setPreferredWidth(150);
        m.getColumn(Column.getColumnNumber(Column.AUTHOR)).setPreferredWidth(100);
        m.getColumn(Column.getColumnNumber(Column.INSTALLED)).setResizable(false);
        m.getColumn(Column.getColumnNumber(Column.INSTALLED)).setMaxWidth(16);
        m.getColumn(Column.getColumnNumber(Column.INSTALLED)).setMinWidth(16);
        int ratingSize = 52;
        m.getColumn(Column.getColumnNumber(Column.RATING)).setMinWidth(ratingSize);
        m.getColumn(Column.getColumnNumber(Column.RATING)).setMaxWidth(ratingSize);
        m.getColumn(Column.getColumnNumber(Column.RATING)).setResizable(false);
        m.getColumn(Column.getColumnNumber(Column.RELEASEDATE)).setMinWidth(75);
        m.getColumn(Column.getColumnNumber(Column.RELEASEDATE)).setPreferredWidth(80);
    }

    public void setMapList(PackageList data) {
        if (this.data != null) {
            this.data.removeChangeListener(this);
            for (Package map : this.data) {
                map.removeChangeListener(this);
            }
        }
        data.sort();
        this.data = data;
        data.addChangeListener(this);
        for (Package map : data) {
            map.addChangeListener(this);
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public int getColumnCount() {
        return Column.count();
    }

    @Override
    public String getColumnName(int col) {
        return Column.getColumn((int)col).header;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    public Object getColumnData(int col, Package info) {
        return Column.getColumn(col).getData(info);
    }

    public Class<? extends Object> getColumnClass(int c) {
        return Column.getColumn(c).getColumnClass();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.getColumnData(col, this.data.get(row));
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Package getPackage(int row) {
        return this.data.get(row);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.addChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof PackageList) {
            this.setMapList((PackageList)e.getSource());
            this.listeners.notifyChangeListeners(e.getSource());
            return;
        }
        if (e.getSource() instanceof Package) {
            Package r = (Package)e.getSource();
            this.listeners.notifyChangeListeners(r);
            int i = this.data.indexOf(r);
            super.fireTableRowsUpdated(i, i);
            return;
        }
        throw new RuntimeException("didn't recognise what changed!");
    }

    public RowFilter<PackageListModel, Integer> filter(String filterText) {
        final int[] columnsToCheck = new int[]{Column.getColumnNumber(Column.NAME), Column.getColumnNumber(Column.AUTHOR), Column.getColumnNumber(Column.TITLE), Column.getColumnNumber(Column.RELEASEDATE)};
        String[] filterTexts = filterText.split(" ");
        final ArrayList<Pattern> patterns = new ArrayList<Pattern>(filterTexts.length);
        for (String filter : filterTexts) {
            try {
                patterns.add(Pattern.compile(".*" + filter + ".*", 66));
            }
            catch (PatternSyntaxException e) {
                // empty catch block
            }
        }
        RowFilter<PackageListModel, Integer> rf = new RowFilter<PackageListModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends PackageListModel, ? extends Integer> entry) {
                for (Pattern pattern : patterns) {
                    boolean matches = false;
                    for (int i : columnsToCheck) {
                        if (!pattern.matcher(entry.getStringValue(i)).matches()) continue;
                        matches = true;
                    }
                    if (matches) continue;
                    return false;
                }
                return true;
            }
        };
        return rf;
    }

    public static class RatingRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final int HORIZONTALGAP = 2;
        private static final int ICONSIZE = 8;
        private ImageIcon activeIcon;
        private ImageIcon inactiveIcon;
        private List<JLabel> ratingLabels = new ArrayList<JLabel>(5);

        public RatingRenderer() {
            try {
                this.activeIcon = Utils.createImageIcon("/star_spirit_8.png", "activeStar");
                this.inactiveIcon = Utils.createImageIcon("/star_spirit_8_inactive.png", "inactiveStar");
            }
            catch (IOException e) {
                System.err.println("WARNING: Couldn't load rating image!");
            }
            EmptyBorder border = new EmptyBorder(0, 0, 0, 0);
            this.setBorder(border);
            ((FlowLayout)this.getLayout()).setHgap(2);
            ((FlowLayout)this.getLayout()).setVgap(4);
            for (int i = 0; i < 5; ++i) {
                JLabel label = new JLabel(this.activeIcon);
                label.setDisabledIcon(this.inactiveIcon);
                label.setBorder(border);
                label.setOpaque(false);
                this.add(label);
                this.ratingLabels.add(label);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Package.Rating) {
                Package.Rating rating = (Package.Rating)((Object)value);
                int i = 0;
                for (JLabel label : this.ratingLabels) {
                    boolean enabled = true;
                    if (i >= rating.getRating()) {
                        enabled = false;
                    }
                    label.setEnabled(enabled);
                    ++i;
                }
            }
            return this;
        }
    }
}

