#include <string.h>
#include "quake_ipc.h"

extern "C" void *new_malloc(int size)
{
	while(quake_ipc_7to9->message == 0xffffffff);
	
	volatile unsigned int result;
	quake_ipc_7to9->message_type = kMalloc;
	*(volatile unsigned int *)quake_ipc_7to9_buf = size;
	quake_ipc_7to9->message = 0xffffffff;
	
	while (quake_ipc_7to9->message_type == kMalloc);
	
	if (quake_ipc_7to9->message_type != kMallocResponse)
	{
		ARM7_PRINT("\nshould have received a malloc response!\n");
		ARM7_HALT();
	}
	
	result = *(volatile unsigned int *)quake_ipc_7to9_buf;
	
	while(quake_ipc_7to9->message == 0xffffffff);
	
	ARM7_PRINT("ok\n");
//	ARM7_PRINT("addr is \n");
//	ARM7_PRINT_NUMBER(result);
//	ARM7_PRINT("\n");
	
	if (result < 0x2000000)
	{
		ARM7_PRINT("ARM7 malloc address too low\n");
		ARM7_HALT();
	}
	
	return (void *)result;
}

extern "C" void new_free(void *ptr)
{
	while(quake_ipc_7to9->message == 0xffffffff);
	
	unsigned int result;
	quake_ipc_7to9->message_type = kFree;
	*(unsigned int *)quake_ipc_7to9_buf = (unsigned int)ptr;
	quake_ipc_7to9->message = 0xffffffff;
	
	while(quake_ipc_7to9->message == 0xffffffff);
}
