/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// d_part.c: software driver module for drawing particles

#include "quakedef.h"
#include "d_local.h"

#include "ds.h"

extern unsigned int r_crosshair_texture;

/*
==============
D_EndParticles
==============
*/
void D_EndParticles (void)
{
// not used by software driver
}


/*
==============
D_StartParticles
==============
*/
void D_StartParticles (void)
{
// not used by software driver
}


#if	!id386

/*
==============
D_DrawParticle
==============
*/

extern float tri2_scale;
float part_scale = tri2_scale;


unsigned short convert_8_16(unsigned char pix);

int part_vright[3];
int part_vup[3];
int part_vpn[3];

void D_DrawParticle (particle_t *pparticle)
{
	vec3_t	local;
	int local_fp[3];
	particle_t *p = pparticle;

// transform point
	VectorSubtract (pparticle->org, r_origin, local);
	local_fp[0] = (int)(local[0] * FP_SCALE);
	local_fp[1] = (int)(local[1] * FP_SCALE);
	local_fp[2] = (int)(local[2] * FP_SCALE);

	bind_texture(-1);
	GFX_COLOR = convert_8_16((unsigned char)p->color);
	
	DS_BEGIN_QUAD();
	
//	ds_vertex3f(local[0] * part_scale,
//			local[1] * part_scale,
//			local[2] * part_scale);
//	ds_vertex3f((local[0] + vup[0] * 4) * part_scale,
//			(local[1] + vup[1] * 4) * part_scale,
//			(local[2] + vup[2] * 4) * part_scale);
//	ds_vertex3f((local[0] + vup[0] * 4 + vright[0] * 4) * part_scale,
//			(local[1] + vup[1] * 4 + vright[1] * 4) * part_scale,
//			(local[2] + vup[2] * 4 + vright[2] * 4) * part_scale);
//	ds_vertex3f((local[0] + vright[0] * 4) * part_scale,
//			(local[1] + vright[1] * 4) * part_scale,
//			(local[2] + vright[2] * 4) * part_scale);

//	ds_vertex3f((float)local_fp[0] / 8192 * part_scale,
//			(float)local_fp[1] / 8192 * part_scale,
//			(float)local_fp[2] / 8192 * part_scale);
//	ds_vertex3f((float)(local_fp[0] + part_vup[0] * 4) / 8192 * part_scale,
//			(float)(local_fp[1] + part_vup[1] * 4) / 8192 * part_scale,
//			(float)(local_fp[2] + part_vup[2] * 4) / 8192 * part_scale);
//	ds_vertex3f((float)(local_fp[0] + part_vup[0] * 4 + part_vright[0] * 4) / 8192 * part_scale,
//			(float)(local_fp[1] + part_vup[1] * 4 + part_vright[1] * 4) / 8192 * part_scale,
//			(float)(local_fp[2] + part_vup[2] * 4 + part_vright[2] * 4) / 8192 * part_scale);
//	ds_vertex3f((float)(local_fp[0] + part_vright[0] * 4) / 8192 * part_scale,
//			(float)(local_fp[1] + part_vright[1] * 4) / 8192 * part_scale,
//			(float)(local_fp[2] + part_vright[2] * 4) / 8192 * part_scale);

//	ds_vertex3f((float)local_fp[0] / 8192 * part_scale,
//			(float)local_fp[1] / 8192 * part_scale,
//			(float)local_fp[2] / 8192 * part_scale);
	DS_VERTEX3V16(local_fp[0] >> 9,
			local_fp[1] >> 9,
			(int)((float)local_fp[2] / 512));
	ds_vertex3f((float)(local_fp[0] + part_vup[0] * 4) / 8192 * part_scale,
			(float)(local_fp[1] + part_vup[1] * 4) / 8192 * part_scale,
			(float)(local_fp[2] + part_vup[2] * 4) / 8192 * part_scale);
	ds_vertex3f((float)(local_fp[0] + part_vup[0] * 4 + part_vright[0] * 4) / 8192 * part_scale,
			(float)(local_fp[1] + part_vup[1] * 4 + part_vright[1] * 4) / 8192 * part_scale,
			(float)(local_fp[2] + part_vup[2] * 4 + part_vright[2] * 4) / 8192 * part_scale);
	ds_vertex3f((float)(local_fp[0] + part_vright[0] * 4) / 8192 * part_scale,
			(float)(local_fp[1] + part_vright[1] * 4) / 8192 * part_scale,
			(float)(local_fp[2] + part_vright[2] * 4) / 8192 * part_scale);
}

#endif	// !id386

