/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// mathlib.h

typedef float vec_t;
typedef vec_t vec3_t[3];
typedef vec_t vec5_t[5];

typedef	int	fixed4_t;
typedef	int	fixed8_t;
typedef	int	fixed16_t;

#include "fixed_point.h"
typedef fixed_point fixed_point3[3];

#ifndef M_PI
#define M_PI		3.14159265358979323846	// matches value in gcc v2 math.h
#endif

struct mplane_s;

extern vec3_t vec3_origin;
extern	int nanmask;

#define	IS_NAN(x) (((*(int *)&x)&nanmask)==nanmask)

#define DotProduct(x,y) (x[0]*y[0]+x[1]*y[1]+x[2]*y[2])
//#define DotProductII(x, y) ((x[0] * y[0]) >> 10) + ((x[1] * y[1]) >> 10) + ((x[2] * y[2]) >> 10)
//#define DotProductIFP(x,y) ((((float)((float)x[0] * (float)y[0])) / 1024 )+ (((float)((float)x[1] * (float)y[1])) / 1024) + (((float)((float)x[2] * (float)y[2])) / 1024))
#define VectorSubtract(a,b,c) {c[0]=a[0]-b[0];c[1]=a[1]-b[1];c[2]=a[2]-b[2];}
//#define VectorSubtractFPFPI(a,b,c) {c[0]=(a[0]-b[0]) * 1024;c[1]=(a[1]-b[1]) * 1024;c[2]=(a[2]-b[2]) * 1024;}
//#define VectorSubtractFPII(a,b,c) { c[0] = (a[0] - (b[0] >> 10)) << 10; c[1] = (a[1] - (b[1] >> 10)) << 10; c[2] = (a[2] - (b[2] >> 10)) << 10; }
#define VectorAdd(a,b,c) {c[0]=a[0]+b[0];c[1]=a[1]+b[1];c[2]=a[2]+b[2];}
#define VectorCopy(a,b) {b[0]=a[0];b[1]=a[1];b[2]=a[2];}
#define VectorFPCopy(a, b) {memcpy(&b, &a, sizeof(fixed_point) * 3);}
//#define VectorCopyFP2I(a,b) { b[0] = a[0] * 1024; b[1] = (a[1] * 1024); b[2] = (a[2] * 1024); }
//#define VectorCopyI2FP(a, b) {b[0] = (float)a[0] / 1024; b[1] = (float)a[1] / 1024; b[2] = (float)a[2] / 1024; }

void VectorMA (vec3_t veca, float scale, vec3_t vecb, vec3_t vecc);

vec_t _DotProduct (vec3_t v1, vec3_t v2);
void _VectorSubtract (vec3_t veca, vec3_t vecb, vec3_t out);
void _VectorAdd (vec3_t veca, vec3_t vecb, vec3_t out);
void _VectorCopy (vec3_t in, vec3_t out);

int VectorCompare (vec3_t v1, vec3_t v2);
vec_t Length (vec3_t v);
fixed_point LengthFP (fixed_point *v);
void CrossProduct (vec3_t v1, vec3_t v2, vec3_t cross);
float VectorNormalize (vec3_t v);		// returns vector length
//float VectorNormalize (fixed_point *v);		// returns vector length
void VectorInverse (vec3_t v);
void VectorScale (vec3_t in, vec_t scale, vec3_t out);
void VectorScale (fixed_point *in, vec_t scale, vec3_t out);
void VectorScaleIFPFP (int *in, vec_t scale, vec3_t out);
int Q_log2(int val);

void R_ConcatRotations (float in1[3][3], float in2[3][3], float out[3][3]);
void R_ConcatTransforms (float in1[3][4], float in2[3][4], float out[3][4]);

void FloorDivMod (double numer, double denom, int *quotient,
		int *rem);
fixed16_t Invert24To16(fixed16_t val);
int GreatestCommonDivisor (int i1, int i2);

void AngleVectors (vec3_t angles, vec3_t forward, vec3_t right, vec3_t up);
int BoxOnPlaneSide (vec3_t emins, vec3_t emaxs, struct mplane_s *plane);
int BoxOnPlaneSideFP (fixed_point *emins, fixed_point *emaxs, struct mplane_s *plane);
float	anglemod(float a);



#define BOX_ON_PLANE_SIDE(emins, emaxs, p)	\
	(((p)->type < 3)?						\
	(										\
		((p)->dist <= (emins)[(p)->type])?	\
			1								\
		:									\
		(									\
			((p)->dist >= (emaxs)[(p)->type])?\
				2							\
			:								\
				3							\
		)									\
	)										\
	:										\
		BoxOnPlaneSide( (emins), (emaxs), (p)))

#define BOX_ON_PLANE_SIDE_FP(emins, emaxs, p)	\
	(((p)->type < 3)?						\
	(										\
		((p)->dist.value <= (emins)[(p)->type].value)?	\
			1								\
		:									\
		(									\
			((p)->dist.value >= (emaxs)[(p)->type].value)?\
				2							\
			:								\
				3							\
		)									\
	)										\
	:										\
		BoxOnPlaneSideFP( (emins), (emaxs), (p)))
