/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// r_sky.c
#define USE_3D
#ifndef USE_3D

#include "quakedef.h"
#include "r_local.h"
#include "d_local.h"


int		iskyspeed = 8;
int		iskyspeed2 = 2;
float	skyspeed, skyspeed2;

float		skytime;

byte		*r_skysource;

int r_skymade;
int r_skydirect;		// not used?


// TODO: clean up these routines

byte	bottomsky[128*131];
byte	bottommask[128*131];
byte	newsky[128*256];	// newsky and topsky both pack in here, 128 bytes
							//  of newsky on the left of each scan, 128 bytes
							//  of topsky on the right, because the low-level
							//  drawers need 256-byte scan widths


/*
=============
R_InitSky

A sky texture is 256*128, with the right side being a masked overlay
==============
*/
void R_InitSky (texture_t *mt)
{
	int			i, j;
	byte		*src;

	src = (byte *)mt + mt->offsets[0];

	for (i=0 ; i<128 ; i++)
	{
		for (j=0 ; j<128 ; j++)
		{
			newsky[(i*256) + j + 128] = src[i*256 + j + 128];
		}
	}

	for (i=0 ; i<128 ; i++)
	{
		for (j=0 ; j<131 ; j++)
		{
			if (src[i*256 + (j & 0x7F)])
			{
				bottomsky[(i*131) + j] = src[i*256 + (j & 0x7F)];
				bottommask[(i*131) + j] = 0;
			}
			else
			{
				bottomsky[(i*131) + j] = 0;
				bottommask[(i*131) + j] = 0xff;
			}
		}
	}
	
	r_skysource = newsky;
}


/*
=================
R_MakeSky
=================
*/
void R_MakeSky (void)
{
	int			x, y;
	int			ofs, baseofs;
	int			xshift, yshift;
	unsigned	*pnewsky;
	static int	xlast = -1, ylast = -1;

	xshift = skytime*skyspeed;
	yshift = skytime*skyspeed;

	if ((xshift == xlast) && (yshift == ylast))
		return;

	xlast = xshift;
	ylast = yshift;
	
	pnewsky = (unsigned *)&newsky[0];

	for (y=0 ; y<SKYSIZE ; y++)
	{
		baseofs = ((y+yshift) & SKYMASK) * 131;

// FIXME: clean this up
#if UNALIGNED_OK

		for (x=0 ; x<SKYSIZE ; x += 4)
		{
			ofs = baseofs + ((x+xshift) & SKYMASK);

		// PORT: unaligned dword access to bottommask and bottomsky

			*pnewsky = (*(pnewsky + (128 / sizeof (unsigned))) &
						*(unsigned *)&bottommask[ofs]) |
						*(unsigned *)&bottomsky[ofs];
			pnewsky++;
		}

#else

		for (x=0 ; x<SKYSIZE ; x++)
		{
			ofs = baseofs + ((x+xshift) & SKYMASK);

			*(byte *)pnewsky = (*((byte *)pnewsky + 128) &
						*(byte *)&bottommask[ofs]) |
						*(byte *)&bottomsky[ofs];
			pnewsky = (unsigned *)((byte *)pnewsky + 1);
		}

#endif

		pnewsky += 128 / sizeof (unsigned);
	}

	r_skymade = 1;
}


/*
=================
R_GenSkyTile
=================
*/
void R_GenSkyTile (void *pdest)
{
	int			x, y;
	int			ofs, baseofs;
	int			xshift, yshift;
	unsigned	*pnewsky;
	unsigned	*pd;

	xshift = skytime*skyspeed;
	yshift = skytime*skyspeed;

	pnewsky = (unsigned *)&newsky[0];
	pd = (unsigned *)pdest;

	for (y=0 ; y<SKYSIZE ; y++)
	{
		baseofs = ((y+yshift) & SKYMASK) * 131;

// FIXME: clean this up
#if UNALIGNED_OK

		for (x=0 ; x<SKYSIZE ; x += 4)
		{
			ofs = baseofs + ((x+xshift) & SKYMASK);

		// PORT: unaligned dword access to bottommask and bottomsky

			*pd = (*(pnewsky + (128 / sizeof (unsigned))) &
				   *(unsigned *)&bottommask[ofs]) |
				   *(unsigned *)&bottomsky[ofs];
			pnewsky++;
			pd++;
		}

#else

		for (x=0 ; x<SKYSIZE ; x++)
		{
			ofs = baseofs + ((x+xshift) & SKYMASK);

			*(byte *)pd = (*((byte *)pnewsky + 128) &
						*(byte *)&bottommask[ofs]) |
						*(byte *)&bottomsky[ofs];
			pnewsky = (unsigned *)((byte *)pnewsky + 1);
			pd = (unsigned *)((byte *)pd + 1);
		}

#endif

		pnewsky += 128 / sizeof (unsigned);
	}
}


/*
=================
R_GenSkyTile16
=================
*/
void R_GenSkyTile16 (void *pdest)
{
	int				x, y;
	int				ofs, baseofs;
	int				xshift, yshift;
	byte			*pnewsky;
	unsigned short	*pd;

	xshift = skytime * skyspeed;
	yshift = skytime * skyspeed;

	pnewsky = (byte *)&newsky[0];
	pd = (unsigned short *)pdest;

	for (y=0 ; y<SKYSIZE ; y++)
	{
		baseofs = ((y+yshift) & SKYMASK) * 131;

// FIXME: clean this up
// FIXME: do faster unaligned version?
		for (x=0 ; x<SKYSIZE ; x++)
		{
			ofs = baseofs + ((x+xshift) & SKYMASK);

			*pd = d_8to16table[(*(pnewsky + 128) &
					*(byte *)&bottommask[ofs]) |
					*(byte *)&bottomsky[ofs]];
			pnewsky++;
			pd++;
		}

		pnewsky += TILE_SIZE;
	}
}


/*
=============
R_SetSkyFrame
==============
*/
void R_SetSkyFrame (void)
{
	int		g, s1, s2;
	float	temp;

	skyspeed = iskyspeed;
	skyspeed2 = iskyspeed2;

	g = GreatestCommonDivisor (iskyspeed, iskyspeed2);
	s1 = iskyspeed / g;
	s2 = iskyspeed2 / g;
	temp = SKYSIZE * s1 * s2;

	skytime = cl.time - ((int)(cl.time / temp) * temp);
	

	r_skymade = 0;
}

#else

#include "quakedef.h"
#include "r_local.h"
#include "d_local.h"


int		iskyspeed = 8;
int		iskyspeed2 = 2;
float	skyspeed, skyspeed2;

float		skytime;

int r_skymade;
int r_skydirect;		// not used?


// TODO: clean up these routines

/*
=============
R_InitSky

A sky texture is 256*128, with the right side being a masked overlay
==============
*/
//int ds_gentexture(void);
//int ds_teximage2d(int sizeX, int sizeY, unsigned char* texture, bool transparency, int transparent_colour);

int register_texture_immediate(char *name, unsigned char *data, int sizeX, int sizeY, int transparency, int transparent_colour);
int register_texture_deferred(char *name, unsigned char *data, int sizeX, int sizeY, int transparency, int transparent_colour);
int find_texture(char *name);
int find_texture(void *);
void *get_texture_address(int id);

void ds_lock_vram(void);
void ds_unlock_vram(void);

int lower_sky_handle, upper_sky_handle;

#define FULL_WIDTH 128
#define NEW_WIDTH 64
#define HEIGHT 64

unsigned char upper_sky[NEW_WIDTH * HEIGHT];
unsigned char lower_sky[NEW_WIDTH * HEIGHT];

//void R_InitSky (unsigned char *src)
//{
//	printf("loading sky...\n");
//	for (int y = 0; y < HEIGHT; y++)
//		for (int x = 0; x < NEW_WIDTH; x++)
//		{
//			lower_sky[y * NEW_WIDTH + x] = src[x * FULL_WIDTH + y];
//			upper_sky[y * NEW_WIDTH + x] = src[x * FULL_WIDTH + y + NEW_WIDTH];
//		}
//	
////	lower_sky_handle = ds_gentexture();
////	ds_bindtexture(lower_sky_handle);
////	ds_teximage2d(NEW_WIDTH, HEIGHT, lower_sky, true, 0);
//
//	lower_sky_handle = find_texture("lower sky");
//	
//	if (lower_sky_handle == -1)
//		lower_sky_handle = register_texture_immediate("lower sky", lower_sky, NEW_WIDTH, HEIGHT, true, 0);
//	else
//	{
//		unsigned int *addr = (unsigned int *)get_texture_address(lower_sky_handle);
//		
//		printf("lower sky at %08x\n", addr);
//		
//		while(1);
//		
//		ds_unlock_vram();
//		memcpy(addr, lower_sky, NEW_WIDTH * HEIGHT);
//		ds_lock_vram();
//	}
//	
////	upper_sky_handle = ds_gentexture();
////	ds_bindtexture(upper_sky_handle);
////	ds_teximage2d(NEW_WIDTH, HEIGHT, upper_sky, false, 0);
//	
//	upper_sky_handle = find_texture("upper sky");
//	
//	if (upper_sky_handle == -1)
//		upper_sky_handle = register_texture_immediate("upper sky", upper_sky, NEW_WIDTH, HEIGHT, false, 0);
//	else
//	{
//		unsigned int *addr = (unsigned int *)get_texture_address(upper_sky_handle);
//		
//		printf("upper sky at %08x\n", addr);
//		
//		ds_unlock_vram();
//		memcpy(addr, upper_sky, NEW_WIDTH * HEIGHT);
//		ds_lock_vram();
//	}
//
////	lower_sky_handle = r_notexture_mip->texture_handle;
////	upper_sky_handle = r_notexture_mip->texture_handle;
//}

void R_InitSky (unsigned char *src)
{
	printf("loading sky...\n");
	for (int y = 0; y < HEIGHT; y++)
		for (int x = 0; x < NEW_WIDTH; x++)
		{
			lower_sky[y * NEW_WIDTH + x] = src[x * FULL_WIDTH + y];
			upper_sky[y * NEW_WIDTH + x] = src[x * FULL_WIDTH + y + NEW_WIDTH];
		}

//	lower_sky_handle = find_texture("lower sky");
	lower_sky_handle = find_texture(lower_sky);
	
	if (lower_sky_handle == -1)
	{
		printf("making new lower sky\n");
		lower_sky_handle = register_texture_deferred("lower sky", lower_sky, NEW_WIDTH, HEIGHT, true, 0);
	}
	else
		printf("replacing existing lower sky\n");
	
//	upper_sky_handle = find_texture("upper sky");
	upper_sky_handle = find_texture(upper_sky);
	
	if (upper_sky_handle == -1)
	{
		printf("making new upper sky\n");
		upper_sky_handle = register_texture_deferred("upper sky", upper_sky, NEW_WIDTH, HEIGHT, false, 0);
	}
	else
		printf("replacing existing upper sky\n");

//	lower_sky_handle = r_notexture_mip->texture_handle;
//	upper_sky_handle = r_notexture_mip->texture_handle;
}

/*
=============
R_SetSkyFrame
==============
*/
int sky_shift = 0;
float time_shift = 0;
int turb_s = 0, turb_t = 0;
int turb_s2 = 0, turb_t2 = 0;
int add[32] = {8, 7, 6, 5, 4, 3, 2, 1, 0, -1, -2, -3, -4, -5, -6, -7, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7};
int add_count = 0;

float last_sky_time = 0;
float this_sky_time = 0;

void R_SetSkyFrame (void)
{
//	int		g, s1, s2;
//	float	temp;
//
//	skyspeed = iskyspeed;
//	skyspeed2 = iskyspeed2;
//
//	g = GreatestCommonDivisor (iskyspeed, iskyspeed2);
//	s1 = iskyspeed / g;
//	s2 = iskyspeed2 / g;
//	temp = SKYSIZE * s1 * s2;
//
//	skytime = cl.time - ((int)(cl.time / temp) * temp);
//	
//
//	r_skymade = 0;

	this_sky_time = Sys_FloatTime();
	time_shift += ((this_sky_time - last_sky_time) * 15);
	
	sky_shift = (int)time_shift;
	
//	if (sky_shift > 127)
//		printf("reset\n");
//	
//	sky_shift = sky_shift & 0x7f;
	
	turb_s = add[add_count & 0x1f];
	turb_t = add[(add_count + 12) & 0x1f];
	
	turb_s2 = add[(add_count + 16) & 0x1f];
	turb_t2 = add[(add_count + 12) & 0x1f];
	
	add_count = (int)time_shift;
	
	last_sky_time = this_sky_time;
}

#endif
