#include <stdio.h>
#include "ds.h"

//#define TIME_RAM

#ifdef TIME_RAM

unsigned int dummy_array[1024];

unsigned int ram_latency_dma_test(void *address, volatile unsigned short *timer_value)
{
	unsigned int start_time = *timer_value;
	unsigned int operations = 0;
	
	while (*timer_value > start_time)
	{
		ds_dmacopywords_async(0, address, dummy_array, 4096);
		operations += 1024;
		ds_waitfordma(0);
	}
	return operations;
}

unsigned int ram_latency_test(void *address, volatile unsigned short *timer_value)
{
	unsigned int start_time = *timer_value;
	unsigned int operations = 0;
	
	while (*timer_value > start_time)
	{
		__asm__ __volatile__(
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			"ldr r0, [%0, #0]\n"
			"ldr r1, [%0, #1024]\n"
			:
			: "r" (address)
			: "r0", "r1"
			);
		operations += 32;
	}
	return operations;
}

unsigned int ram_latency_test_seq(void *address, volatile unsigned short *timer_value)
{
	unsigned int start_time = *timer_value;
	unsigned int operations = 0;
	
	while (*timer_value > start_time)
	{
		__asm__ __volatile__(
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			"ldm %0, {r0, r1, r2, r3, r4, r5, r6, r7}\n"
			:
			: "r" (address)
			: "r0", "r1", "r2", "r3", "r4", "r5", "r6", "r7"
			);
		operations += 256;
	}
	return operations;
}

void time_ram(const char * const name, void *address, volatile unsigned short *timer)
{
	printf("%s\n", name);
	
	unsigned int operations = ram_latency_test_seq(address, timer);
	printf("%.1f MB/s, %.1f ns, %.0f clocks\n",
		(float)(operations * 512 * 4) / 1048576,
		1000000.0f / (operations * 512) * 1000,
		1000000.0f / (operations * 512) * 1000 / 15);
	
	operations = ram_latency_test(address, timer);
	printf("%.1f MB/s, %.1f ns, %.0f clocks\n",
		(float)(operations * 512 * 4) / 1048576,
		1000000.0f / (operations * 512) * 1000,
		1000000.0f / (operations * 512) * 1000 / 15);
}

#endif
