/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// vid_null.c -- null video driver to aid porting efforts

#include "quakedef.h"
#include "d_local.h"
#include "ds.h"

viddef_t	vid;				// global video state

#define	BASEWIDTH	256
#define	BASEHEIGHT	192
#define USE_3D

#ifndef USE_3D

byte	vid_buffer[BASEWIDTH*BASEHEIGHT];
short	zbuffer[BASEWIDTH*BASEHEIGHT];
byte	surfcache[60*1024];

#else

byte	*vid_buffer = NULL;
short *zbuffer = NULL;
byte	*surfcache = NULL;

#endif

unsigned short	d_8to16table[256];
unsigned	d_8to24table[256];

unsigned char *my_palette;

#define RGB15(r,g,b)  ((r)|((g)<<5)|((b)<<10))
#define RGB5(r,g,b)  ((r)|((g)<<5)|((b)<<10))
#define RGB8(r,g,b)  ((((r)>>3)|(((g)>>3)<<5)|(((b)>>3)<<10)) | (1 << 15))

void ds_schedule_loadpalette(unsigned short *palette);

unsigned short convert_8_16(unsigned char pix)
{
	extern unsigned char *my_palette;
	unsigned char res_r, res_g, res_b;
	
	res_r = my_palette[pix * 3];
	res_g = my_palette[pix * 3 + 1];
	res_b = my_palette[pix * 3 + 2];
	
	unsigned short result = RGB8(res_r, res_g, res_b);
	
//	int total = res_r + res_g + res_b;
//	unsigned short result = RGB8(total / 3, total / 3, total / 3);
	return result;
}

void	VID_SetPalette (unsigned char *palette)
{
	int count;
	
	ds_memcpy(my_palette, palette, 256 * 3);
	
	for (count = 0; count < 256; count++)
		d_8to16table[count] = convert_8_16(count);
	
//	d_8to16table[0] = RGB8(3, 3, 3);
	
	ds_schedule_loadpalette(d_8to16table);
}

void	VID_ShiftPalette (unsigned char *palette)
{
	VID_SetPalette(palette);
}

void	VID_Init (unsigned char *palette)
{
	extern unsigned short *frame_buffer_base;
	
	vid.maxwarpwidth = vid.width = vid.conwidth = BASEWIDTH;
	vid.maxwarpheight = vid.height = vid.conheight = BASEHEIGHT;
	vid.aspect = 1.0;
	vid.numpages = 1;
	vid.colormap = host_colormap;
	vid.fullbright = 256 - LittleLong (*((int *)vid.colormap + 2048));
	vid.buffer = vid.conbuffer = vid.direct = vid_buffer;

	vid.rowbytes = vid.conrowbytes = BASEWIDTH;
	
	my_palette = (unsigned char *)malloc(256 * 3);
	VID_SetPalette(palette);
	
	d_pzbuffer = zbuffer;
#ifndef USE_3D
	D_InitCaches (surfcache, sizeof(surfcache));
#else
	vid.conwidth = 256;
	vid.conheight = 192;
#endif
}

void	VID_Shutdown (void)
{
}

void	VID_Update (vrect_t *rects)
{
	if (zbuffer != NULL)
		ds_memset(zbuffer, 0, sizeof(zbuffer));
}

/*
================
D_BeginDirectRect
================
*/
void D_BeginDirectRect (int x, int y, byte *pbitmap, int width, int height)
{
}


/*
================
D_EndDirectRect
================
*/
void D_EndDirectRect (int x, int y, int width, int height)
{
}


