
// Baker: All cvars in one place, cvar.h externs them.  cvar.c has the variables.
// Note: Textpad has ability to do sort starting at character #35 per line easily
//       so you can sort the list by alpha instead of by category.

// Remember, we cannot ifdef away any of these to ensure they preserve.
//            																																					Try for keywords, begin capital.  End with period.
CVAR_DEF( Movie_Init  , AVI       ,  DEP_AVI  , capture_codec             , "capturevideo_codec"      , "auto"    , CVAR_ARCHIVE      , CaptureCodec_Validate,  "4 character video capture compression codec (XVID, DIVX, H264, VP80, etc).  Codec must already be installed on operating system.  XVID is fast.")
CVAR_DEF( Movie_Init  , AVI       ,  DEP_AVI  , capture_console           , "capturevideo_console"    , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Prevents video capture from capturing frames while console is on-screen by skipping those frames."            )
CVAR_DEF( Movie_Init  , AVI       ,  DEP_AVI  , capture_fps               , "capturevideo_fps"        , "30.0"    , CVAR_ARCHIVE      , NULL                 ,  "Frames per second for video capture."            )
CVAR_DEF( Movie_Init  , AVI       ,  DEP_AVI  , capture_hack              , "capturevideo_hack"       , "0"       , CVAR_ARCHIVE      , NULL                 ,  "(TODO: Related to video capture frames per seconds but use not known.)"            )
CVAR_DEF( Movie_Init  , AVI       ,  DEP_AVI  , capture_mp3               , "capturevideo_mp3"        , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle video capture of sound."            )
CVAR_DEF( Movie_Init  , AVI       ,  DEP_AVI  , capture_mp3_kbps          , "capturevideo_mp3_kbps"   , "128"     , CVAR_ARCHIVE      , NULL                 ,  "Set video capture sound quality."            )

CVAR_DEF( VID_Init    , CLIENT    ,  DEP_NONE , hd_folder                 , "_hd_folder"               , "hd"      , CVAR_ARCHIVE | CVAR_STRINGISH      , NULL				,  "Internal use for hd_folder command."            )
CVAR_DEF( CL_Init     , CLIENT    ,  DEP_NONE , cutscene                  , "cutscene"                , "1"       , CVAR_ARCHIVE      , NULL                    ,  "Toggles whether to play Nehahra cut-scenes between levels."            )
CVAR_DEF( CL_Init     , CLIENT    ,  DEP_NONE , cl_autodemo               , "cl_autodemo"             , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle whether demos are automatically recorded every time you play.  Only 3 are kept at any given time so does not use much disk space at all.  Did you wish you recorded that?  Don't worry you did."            )
CVAR_DEF( CL_Init     , CLIENT    ,  DEP_NONE , cl_backspeed              , "cl_backspeed"            , "400"     , CVAR_ARCHIVE      , NULL                 ,  "The speed the player moves backward."            ) // Baker: Always run default, was 200
CVAR_DEF( CL_Init     , CLIENT    ,  DEP_NONE , cl_color                  , "_cl_color"               , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Internal storage for current player colors (changed by color command)"            )
CVAR_DEF( CL_Init     , CLIENT    ,  DEP_NONE , cl_forwardspeed           , "cl_forwardspeed"         , "400"     , CVAR_ARCHIVE      , NULL                 ,  "Forward movement speed"            ) // Baker: Always run default, was 200
CVAR_DEF( CL_Init     , CLIENT    ,  DEP_NONE , cl_name                   , "_cl_name"                , "player"  , CVAR_ARCHIVE      , NULL                 ,  "Internal storage for current player name (changed by name command)"            )
CVAR_DEF( CL_Init     , CLIENT    ,  DEP_NONE , cl_nolerp                 , "cl_nolerp"               , "0"       , CVAR_NONE         , NULL                 ,  "If enabled, the game will not predict the movements of entities and all moving objects in the game will seem to jump from one point to another instead of moving in a smooth motion."            )
CVAR_DEF( CL_Init     , CLIENT    ,  DEP_NONE , cl_shownet                , "cl_shownet"              , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the display about network packet transmissions."            ) // can be 0, 1, or 2
//CVAR_DEF( CL_Init     , CLIENT    ,  DEP_NONE , con_verbose               , "con_verbose"              , "1"       , CVAR_ARCHIVE     , NULL                 ,  "Suppress messages about sound track, external .vis, fish fix, impulse 12."            ) // can be 0, 1, or 2
CVAR_DEF( CL_Init     , CLIENT    ,  DEP_NONE , cl_sidespeed              , "cl_sidespeed"            , "350"     , CVAR_ARCHIVE      , NULL                 ,  "The speed the player moves left and right."            )

CVAR_DEF( Utilities_Init, CLIENT,  DEP_NONE , install_depot_source, "install_depot_source"             , "http://www.quaddicted.com/filebase"       , CVAR_NONE      , NULL                 ,  "Single player archive web site for download capability"            )


CVAR_DEF( COM_InitFilesystem,HOST,  DEP_NONE , cmdline                   , "cmdline"                 , ""        , CVAR_SERVERINFO   , NULL                 ,  "Display the parameters used on the command line to start the game."            )
CVAR_DEF( Host_Init   , HOST      ,  DEP_NONE , developer                 , "developer"               , "0"       , CVAR_NONE         , NULL                 , "Toggle the use of developer mode and the display of internal game information."            )
CVAR_DEF( Host_Init   , HOST      ,  DEP_NONE , devstats                  , "devstats"                , "0"       , CVAR_NONE         , NULL                 , "Toggle the display of certain mapping information."            ) // johnfitz -- track developer statistics that vary every frame
CVAR_DEF( Host_Init   , HOST      ,  DEP_NONE , devstuffcmdprint        , "devstuffcmdprint"     , "0"       , CVAR_NONE         , NULL                 , "Toggle the printing of stuffcmds received."            ) // Baker: for debugging and tuning for mods that use a lot of stuffcmds.
CVAR_DEF( Host_Init   , HOST      ,  DEP_NONE , host_framerate            , "host_framerate"          , "0"       , CVAR_NONE         , NULL                 ,  "Time adjustment value for the game.  Host_timescale is a better alterative."            ) // set for slow motion
//CVAR_DEF( Host_Init   , HOST      ,  DEP_NONE , host_max_edicts           , "max_edicts"              , "0"       , CVAR_NONE         , Max_Edicts_f         ,  ""            ) // Baker: 0 = automatic
CVAR_DEF( Host_Init   , HOST      ,  DEP_NONE , host_maxfps               , "host_maxfps"             , "72"      , CVAR_ARCHIVE      , NULL                 ,  "Maximum frames per second.  In single player -- but not as a client to a multiplayer server -- changing this alters physics and a high value may cause missed triggers or killer lifts."            ) // johnfitz
CVAR_DEF( Host_Init   , HOST      ,  DEP_NONE , host_sleep                , "host_sleep"              , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Toggles an extra kick of CPU sleeping per frame, which can considerably reduce cpu usage.")
CVAR_DEF( Host_Init   , HOST      ,  DEP_NONE , host_speeds               , "host_speeds"             , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the display of the game engine's performance statistics."            ) // set for running times
CVAR_DEF( Host_Init   , HOST      ,  DEP_NONE , host_startdemos           , "host_startdemos"         , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle whether or not the starting demos automatically play when loading up the game."            ) // Baker
CVAR_DEF( Host_Init   , HOST      ,  DEP_NONE , host_timescale            , "host_timescale"          , "0"       , CVAR_NONE         , NULL                 ,  "Set to 0 or 1 for normal speed, 2 is twice normal speed, 0.5 is half of normal speed."            ) // johnfitz
CVAR_DEF( NET_Init    , HOST      ,  DEP_NONE , hostname                  , "hostname"                , "UNNAMED" , CVAR_NONE         , NULL                 ,  "The name of the server."            ) // Server, really, a client-only doesn't need this
CVAR_DEF( COM_InitFilesystem,HOST      ,  DEP_NONE , registered                , "registered"              , "0"       , CVAR_NONE         , NULL                 ,  "Toggle if the game is considered to be the full version or the shareware."            )
CVAR_DEF( CL_Init     , INPUT     ,  DEP_NONE , cfg_unbindall             , "cfg_unbindall"           , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Write out an unbindall command at the beginning of config.cfg when saving."            )
CVAR_DEF( CL_Init     , INPUT     ,  DEP_NONE , cl_anglespeedkey          , "cl_anglespeedkey"        , "1.5"     , CVAR_ARCHIVE      , NULL                 ,  "The speed you turn when running."            )
CVAR_DEF( CL_Init     , INPUT     ,  DEP_NONE , cl_maxpitch               , "cl_maxpitch"             , "90"      , CVAR_CLIENT | CVAR_ARCHIVE , NULL, "Modify client-side pitch clamping. Default 90 (straight down.) Set to 80 to mimic normal quake."           ) //johnfitz -- variable pitch clamping
CVAR_DEF( CL_Init     , INPUT     ,  DEP_NONE , cl_minpitch               , "cl_minpitch"             , "-90"     , CVAR_CLIENT | CVAR_ARCHIVE , NULL, "Modify client-side pitch clamping. Default -90 (straight up.) Set to -70 to mimic normal quake."           ) //johnfitz -- variable pitch clamping
CVAR_DEF( CL_Init     , INPUT     ,  DEP_NONE , cl_movespeedkey           , "cl_movespeedkey"         , "2.0"     , CVAR_ARCHIVE      , NULL                 ,  "Multiplier value for the player movement speeds when using the +speed command."            )
CVAR_DEF( CL_Init     , INPUT     ,  DEP_NONE , cl_pitchspeed             , "cl_pitchspeed"           , "150"     , CVAR_ARCHIVE      , NULL                 ,  "The speed the commands +lookup and +lookdown work."            )
CVAR_DEF( CL_Init     , INPUT     ,  DEP_NONE , cl_upspeed                , "cl_upspeed"              , "200"     , CVAR_ARCHIVE      , NULL                 ,  "The speed the player moves up and down."            )
CVAR_DEF( CL_Init     , INPUT     ,  DEP_NONE , cl_yawspeed               , "cl_yawspeed"             , "140"     , CVAR_ARCHIVE      , NULL                 ,  "The speed the +left and +right commands make the player turn left and right."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , in_joystick               , "joystick"                , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle the use of joystick.  TODO: This value is not used."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_name                  , "joyname"                 , "joystick", CVAR_NONE         , NULL                 ,  "The name given to the joystick."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_advanced              , "joyadvanced"             , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the use of advanced joystick features."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_advaxisx              , "joyadvaxisx"             , "0"       , CVAR_NONE         , NULL                 ,  "Mapping of joystick x-axis."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_advaxisy              , "joyadvaxisy"             , "0"       , CVAR_NONE         , NULL                 ,  "Mapping of joystick y-axis."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_advaxisz              , "joyadvaxisz"             , "0"       , CVAR_NONE         , NULL                 ,  "Mapping of joystick z-axis."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_advaxisr              , "joyadvaxisr"             , "0"       , CVAR_NONE         , NULL                 ,  "Mapping of joystick r-axis."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_advaxisu              , "joyadvaxisu"             , "0"       , CVAR_NONE         , NULL                 ,  "Mapping of joystick u-axis."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_advaxisv              , "joyadvaxisv"             , "0"       , CVAR_NONE         , NULL                 ,  "Mapping of joystick v-axis."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_forwardthreshold      , "joyforwardthreshold"     , "0.15"    , CVAR_NONE         , NULL                 ,  "Controls the dead-zone for moving forward and backward."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_sidethreshold         , "joysidethreshold"        , "0.15"    , CVAR_NONE         , NULL                 ,  "Dead-zone for fly."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_flysensitivity        , "joyflysensitivity"       , "-1.0"    , CVAR_NONE         , NULL                 ,  "Fly sensitivity"            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_flythreshold          , "joyflythreshold"         , "0.15"    , CVAR_NONE         , NULL                 ,  "Dead-zone for fly."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_pitchthreshold        , "joypitchthreshold"       , "0.15"    , CVAR_NONE         , NULL                 ,  "Dead-zone for looking up and down."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_yawthreshold          , "joyyawthreshold"         , "0.15"    , CVAR_NONE         , NULL                 ,  "Dead-zone for looking left and right."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_forwardsensitivity    , "joyforwardsensitivity"   , "-1.0"    , CVAR_NONE         , NULL                 ,  "Determines the ramp-up speed for moving forward and backward."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_sidesensitivity       , "joysidesensitivity"      , "-1.0"    , CVAR_NONE         , NULL                 ,  "Ramp-up speed for moving side to side."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_pitchsensitivity      , "joypitchsensitivity"     , "1.0"     , CVAR_NONE         , NULL                 ,  "Speed that you look up and down."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_yawsensitivity        , "joyyawsensitivity"       , "-1.0"    , CVAR_NONE         , NULL                 ,  "Speed that you look left to right."            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_wwhack1               , "joywwhack1"              , "0.0"     , CVAR_NONE         , NULL                 ,  "Toggles a hack for a (now very old) joystick called the Logitech WingMan Warrior driver bug.  (TODO: remove)"            )
CVAR_DEF( Input_Joystick_Init, INPUT     ,  DEP_NONE , joy_wwhack2               , "joywwhack2"              , "0.0"     , CVAR_NONE         , NULL                 ,  "(TODO: UNUSED -- remove)"            )
CVAR_DEF( CL_Init     , INPUT     ,  DEP_NONE , lookspring                , "lookspring"              , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle centering of the screen after the -klook command."            )
CVAR_DEF( CL_Init     , INPUT     ,  DEP_NONE , lookstrafe                , "lookstrafe"              , "0"       , CVAR_NONE         , NULL                 ,  "Toggle automatic strafing when the +klook command is used."            )
CVAR_DEF( CL_Init     , INPUTMOUSE,  DEP_NONE , in_freelook               , "in_freelook"             , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle mouselook (mouse forward and back movement will make the player look up and down)"            )
CVAR_DEF( VID_Init     , INPUTKEYBOARD,  DEP_NONE , in_keymap                 , "in_keymap"               , "1"       , CVAR_ARCHIVE      , Key_Release_Keys     ,  "Toggle automatic use of current system keyboard language mapping.  Off = USA keyboard layout."            )
CVAR_DEF( VID_Init    , INPUTKEYBOARD,  DEP_NONE , in_system_enhanced_keys   , "in_system_enhanced_keys" , "1"       , CVAR_ARCHIVE      , Input_System_Enhanced_Keys_Changed     ,  "Set to 0 and on Windows sticky keys and the 'Windows' key will never be suppressed."            )
CVAR_DEF( VID_Init     , INPUTMOUSE,  DEP_NONE , in_nomouse                , "nomouse"                 , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle use of the mouse."            )
CVAR_DEF( CL_Init     , INPUTMOUSE,  DEP_NONE , m_forward                 , "m_forward"               , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Precision mouse uses to move the player forward and back."            )
CVAR_DEF( CL_Init     , INPUTMOUSE,  DEP_NONE , m_filter                  , "m_filter"                , "0"       , CVAR_ARCHIVE      , NULL                 ,  "(TODO: UNUSED -- remove)"            )
CVAR_DEF( CL_Init     , INPUTMOUSE,  DEP_NONE , m_pitch                   , "m_pitch"                 , "0.022"   , CVAR_ARCHIVE      , NULL                 ,  "Precision mouse uses to make the player look up and down if using mouselook."            )
CVAR_DEF( CL_Init     , INPUTMOUSE,  DEP_NONE , m_side                    , "m_side"                  , "0.8"     , CVAR_ARCHIVE      , NULL                 ,  "Precision mouse uses move the player left and right."            )
CVAR_DEF( CL_Init     , INPUTMOUSE,  DEP_NONE , m_yaw                     , "m_yaw"                   , "0.022"   , CVAR_ARCHIVE      , NULL                 ,  "Precision mouse uses to turn the player left and right."            )
CVAR_DEF( CL_Init     , INPUTMOUSE,  DEP_NONE , sensitivity               , "sensitivity"             , "3"       , CVAR_ARCHIVE      , NULL                 ,  "Precision used for mouse movements."            )

CVAR_DEF( Mod_Init    , MODEL     ,  DEP_GL   , gl_external_lits          , "external_lits"           , "1"       , CVAR_NONE         , Host_Changelevel_Required_Msg,  "Toggle use of external per map color lighting files (.lit files)."    )
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_GL   , gl_external_textures      , "external_textures"       , "1"       , CVAR_NONE         , External_Textures_Change_f,  "Toggle use of external textures in real time."       )
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_GL   , gl_fbrighthack_list       , "r_fbrighthack_list"      , "progs/flame.mdl,progs/flame2.mdl,progs/boss.mdl" , CVAR_NONE , Mod_Flags_Refresh_f                 ,  "Comma delimited list of models that will not be affected by lighting (fullbright). (TODO)"            )
CVAR_DEF( TexMgr_Init , MODEL     ,  DEP_GL   , gl_greyscale              , "gl_greyscale"            , "0"       , CVAR_NONE         , TexMgr_GreyScale_f   ,  "Toggle the option to render everything as gray-scale."            )
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_GL   , gl_nocolormap_list        , "r_nocolormap_list"       , ""        , CVAR_NONE         , NULL                 ,  "(TODO: UNUSED)"            ) // Under consideration: progs/eyes.mdl,progs/h_player.mdl,progs/gib1.mdl,progs/gib2.mdl,progs/gib3.mdl
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_GL   , gl_noshadow_list          , "r_noshadow_list"         , "progs/flame.mdl,progs/flame2.mdl,progs/bolt.mdl,progs/bolt1.mdl,progs/bolt2.mdl,progs/bolt3.mdl,progs/laser.mdl,progs/k_spike.mdl,progs/lavaball.mdl"     , CVAR_NONE     , Mod_Flags_Refresh_f ,  "Comma delimited list of models that should not display a shadow."            )
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_GL   , gl_texprefix_envmap       , "r_texprefix_envmap"      , "envmap_" , CVAR_NONE         , Host_Changelevel_Required_Msg                 ,  "Experimental.  Sets a specific texture name to render using an environmental mapping effect."            ) // sphere mapped
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_GL   , gl_texprefix_mirror       , "r_texprefix_mirror"      , "window02_1"  , CVAR_NONE         , Host_Changelevel_Required_Msg                 ,  "Experimental.  Sets a specific texture name to be a mirror for use with r_mirroralpha.  GLQuake used window02_1 and the effect could seen on the start map."            ) // Mirror texture
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_GL   , gl_texprefix_scrollx      , "r_texprefix_scrollx"     , "scrollx" , CVAR_NONE         , Host_Changelevel_Required_Msg                 ,  "Experimental.  Sets a specific texture name to scroll left to right."            ) // Scroll left -> right
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_GL   , gl_texprefix_scrolly      , "r_texprefix_scrolly"     , "scrolly" , CVAR_NONE         , Host_Changelevel_Required_Msg                 ,  "Experimental.  Sets a specific texture name to scroll up to down."            ) // Scroll up -> down
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_MIRROR  , gl_mirroralpha            , "r_mirroralpha"           , "0.2"       , CVAR_ARCHIVE   , R_Level_Key_Alpha_SkyFog_Changed                 ,  "Enables mirror effect in conjunction with the experimental r_texprefix_mirror console variable. "            ) // R_Level_Key_Alpha_SkyFog_Changed allows overriding a worldspawn key by setting "set" to -1
CVAR_DEF( Host_Init   , MODEL     ,  DEP_NONE , model_external_vis        , "external_vis"            , "1"       , CVAR_NONE         , NULL                 ,  "Toggle use of external visibility files (.vis files).  There is a set of these available that can be put in id1/maps folder to conveniently make the standard Quake maps support transparent water (r_wateralpha)."            )
CVAR_DEF( R_Init      , MODEL     ,  DEP_NONE , r_lavaalpha               , "r_lavaalpha"             , "1"       , CVAR_ARCHIVE | CVAR_CLIENT , R_Level_Key_Alpha_SkyFog_Changed, "Set lava transparency level where 0.5 is half transparent and 1 is not transparent at all.  Engine will refuse to display transparent liquids if the map does not support it (unless r_novis is set to 1) because it will render terribly."           )
CVAR_DEF( R_Init      , MODEL     ,  DEP_NONE , r_nolerp_list             , "r_nolerp_list"           , "progs/flame.mdl,progs/flame2.mdl,progs/braztall.mdl,progs/brazshrt.mdl,progs/longtrch.mdl,progs/flame_pyre.mdl,progs/v_saw.mdl,progs/v_xfist.mdl,progs/h2stuff/newfire.mdl"      , CVAR_NONE     , Mod_Flags_Refresh_f,  "Comma delimited list of models that will not be smoothly animated (r_lerpmodels 2 will ignore this list)."            )
CVAR_DEF( R_Init      , MODEL     ,  DEP_NONE , r_slimealpha              , "r_slimealpha"            , "0.7"     , CVAR_ARCHIVE | CVAR_CLIENT , R_Level_Key_Alpha_SkyFog_Changed, "Set slime transparency level where 0.5 is half transparent and 1 is not transparent at all.  Engine will refuse to display transparent liquids if the map does not support it (unless r_novis is set to 1) because it will render terribly."           )
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_NONE , r_texprefix_tele          , "r_texprefix_tele"        , "*tele"   , CVAR_NONE         , Host_Changelevel_Required_Msg,  "Define the prefix of a teleporter texture."    ) // To prevent r_wateralpha etc from affecting teleporters (Lava, Slime are own contents type but a tele isn't}.
CVAR_DEF( R_Init      , MODEL     ,  DEP_NONE , r_wateralpha              , "r_wateralpha"            , "0.5"     , CVAR_ARCHIVE | CVAR_CLIENT , R_Level_Key_Alpha_SkyFog_Changed, "Set water transparency level where 0.5 is half transparent and 1 is not transparent at all.  Engine will refuse to display transparent liquids if the map does not support it (unless r_novis is set to 1) because it will render terribly."           )
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_NONE , model_external_ents       , "external_ents"           , "1"       , CVAR_NONE         , NULL                 ,  "Toggle use of external per map entity override files (.ent files)."            )
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_SW   , sw_sky_load_skyboxes      , "sw_sky_load_skyboxes"    , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle use of skyboxes.  Applies only to the WinQuake version."            ) // Baker
CVAR_DEF( Mod_Init    , MODEL     ,  DEP_NONE , cl_sky					  , "_cl_sky"				  , ""        , CVAR_ARCHIVE      , NULL                 ,  "Internal variable controlling current skybox texture (changed sky command)."            ) // Baker
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_affinemodels           , "gl_affinemodels"         , "0"       , CVAR_NONE         , NULL                 ,  "Toggle use of perspective correction hint in hardware renderer."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_clear                  , "gl_clear"                , "0"       , CVAR_NONE         , NULL                 ,  "Toggle clearing of video buffer each frame in hardware renderer."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_cull                   , "gl_cull"                 , "1"       , CVAR_NONE         , NULL                 ,  "Toggle use of face culling in hardware renderer."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_drawworld              , "r_drawworld"             , "1"       , CVAR_NONE         , NULL                 ,  "Toggle drawing of the world each frame."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_dynamic                , "r_dynamic"               , "1"       , CVAR_NONE         , NULL                 ,  "Toggle use of dynamic lights."            )

CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_farclip                , "gl_farclip"              , "16384"   , CVAR_NONE         , NULL                 ,  "Distance that geometry cuts-off. (TODO: Software renderer should add too?)"            )
CVAR_DEF( Sky_Init    , SCENE     ,  DEP_GL   , gl_fastsky                , "r_fastsky"               , "0"       , CVAR_NONE         , NULL                 ,  "Toggle drawing of sky as single color."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_finish                 , "gl_finish"               , "0"       , CVAR_NONE         , NULL                 ,  "Toggle use of finish command in hardware renderer."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_flashblend             , "gl_flashblend"           , "0"       , CVAR_ARCHIVE | CVAR_CLIENT , NULL        ,  "Toggle the rendering of a ball of light around dynamic light sources."           )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_flatlightstyles         , "r_flatlightstyles"       , "0"       , CVAR_NONE         , NULL                 ,  "If 1, styled lights (torch flicker, etc.) will be displayed as a steady light. If 2, the peak intensity will be used instead of the average intensity. Default 0."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_fullbrights            , "gl_fullbrights"          , "1"       , CVAR_NONE         , GL_Fullbrights_f     ,  "Toggle drawing of fullbrights in hardware renderer."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_lightmap               , "r_lightmap"              , "0"       , CVAR_NONE         , NULL                 ,  "Toggle drawing of only lightmap."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_nocolors               , "gl_nocolors"             , "0"       , CVAR_NONE         , NULL                 ,  "Toggle drawing of per-player colors."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_norefresh              , "r_norefresh"             , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the redrawing of the game screen."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_oldskyleaf             , "r_oldskyleaf"            , "0"       , CVAR_NONE         , R_VisChanged         ,  "If 0, surfaces inside sky leaves will be skipped by the renderer. If 1, they will be drawn whenever they are in your PVS, just like any other surface. Default 0."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_oldwater               , "r_oldwater"              , "1"       , CVAR_ARCHIVE      , NULL                 ,  "If 1, use the old GLQuake method of subdividing the water surface to enable a warping animation. If 0, use the new render-to-texture method. Note: in general, r_oldwater 0 looks better and runs slower. So experiment to see if the performance hit is acceptable to you. Default 1."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_overbright             , "gl_overbright"           , "1"       , CVAR_NONE         , GL_Overbright_f      ,  "This variable controls overbright lighting on the world polygons. (For lighting on models, use gl_overbright_models.) If 1, overbright will be enabled and lighting will resemble software Quake. If 0, overbright will be disabled and lighting will resemble GLQuake. Default 1."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_overbright_models      , "gl_overbright_models"    , "1"       , CVAR_NONE         , NULL                 ,  "If 1, models will be rendered using 2x overbrightening and will appear at roughly the same brightness as they do in software quake, which is noticably brighter than the default fitzquake / glquake appearance. Default 1. Set to 0 to mimic glquake (and speed things up if your card doesn't support texture combiners or multitexture.)"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_particles              , "r_particles"             , "1"       , CVAR_ARCHIVE      , R_SetParticleTexture_f,  "0 = no particles, 1 = circular particles, 2 = square particles. Default 1."           ) // johnfitz
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_quadparticles          , "r_quadparticles"         , "1"       , CVAR_ARCHIVE      , NULL                 ,  "If 1, particles are drawn as GL_QUADS instead of GL_TRIANGLES. Quads use 4 verts instead of 3, but the fillrate cost is 1/2 that of triangles. Depending on your card, either one may be faster. This cvar has no effect on the appearance of particles. Default 1."            ) // johnfitz
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_shadows                , "r_shadows"               , "0"       , CVAR_NONE         , NULL                 ,  "Toggle drawing of shadows in hardware renderer."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_showbboxes             , "r_showbboxes"            , "0"       , CVAR_NONE         , NULL                 ,  "Draw a wireframe bounding box around each entity. Note that these are the server-side per-edict physics bounding boxes, not the client-side per-model rendering bboxes."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_showtris               , "r_showtris"              , "0"       , CVAR_NONE         , NULL                 ,  "If 1, draw wireframe outlines for every triangle in the scene. Like in Quake 3, the lines will be visible even through solid geometry. If 2, draw the outlines only on visible surfaces (like r_showtris 2 in Medal of Honor.) If 0, disable wireframe overlay. Default 0."            )
CVAR_DEF( Sky_Init    , SCENE     ,  DEP_GL   , gl_sky_quality            , "r_sky_quality"           , "12"      , CVAR_NONE         , NULL                 ,  "Higher number divides the sky more, for a smoother effect and slower performance. Default 12."            )
CVAR_DEF( Sky_Init    , SCENE     ,  DEP_GL   , gl_skyalpha               , "r_skyalpha"              , "1"       , CVAR_NONE         , NULL                 ,  "Sets the alpha of the front sky layer. Note that if sky alpha is less than 1.0, the sky will be drawn in two passes even if you have multitexture. Default 1."            )
CVAR_DEF( Sky_Init    , SCENE     ,  DEP_GL   , gl_skyfog                 , "r_skyfog"                , "0.5"     , CVAR_NONE         , R_Level_Key_Alpha_SkyFog_Changed                 ,  "Controls how much the sky is obscured by the fog. 0 = sky is completely unfogged, 1 = sky is completely fogged. Default 0.5."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_smoothmodels           , "gl_smoothmodels"         , "1"       , CVAR_NONE         , NULL                 ,  "Toggle the smoothing of textures used for models."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_stereo                 , "r_stereo"                , "0"       , CVAR_NONE         , NULL                 ,  "If nonzero, the scene will be rendered once in red, and again in cyan, with the two views shifted slightly. If you have 3D glasses you can appreciate this (assumes that the left eye is red and the right eye is cyan.) The value of r_stereo sets the eye separation. If your glasses have red on the right eye, use a negative value to flip the views. Default 0."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_stereodepth            , "r_stereodepth"           , "128"     , CVAR_NONE         , NULL                 ,  "Sets the distance the two views will converge when stereo rendering is active. Default 128."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_subdivide_size         , "gl_subdivide_size"       , "128"     , CVAR_ARCHIVE      , Host_Changelevel_Required_Msg, "The value used to divide the sky into individual brushes."     )
CVAR_DEF( TexMgr_Init , SCENE     ,  DEP_GL   , gl_texture_anisotropy     , "gl_texture_anisotropy"   , "1"       , CVAR_ARCHIVE      , TexMgr_Anisotropy_f  ,  "Controls the amount of anisotropy in texture filtering. If 1 or less than 1, texture filtering is normal (isotropic.) If greater than 1, increasing degrees of anisotropic filtering are used, up to the hardware maximum. Set value to 2 for 2x anisotropic, 4 for 4x, etc. Default 1."            )
CVAR_DEF( SCR_Init    , SCENE     ,  DEP_GL   , gl_triplebuffer           , "gl_triplebuffer"         , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle the use of triple buffering for video modes that support it."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_waterquality           , "r_waterquality"          , "8"       , CVAR_NONE         , NULL                 ,  "Sets the quality of the water when r_oldwater is 0. Lower values give better performance, higher values look better. A value of 4 will provide water that looks at least as good as glquake can get, and 32 is close enough to software quake for all but the most picky. To control the quality of water when r_oldwater is 1, use gl_subdivide_size instead. Default 8."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , gl_waterripple            , "r_waterripple"           , "0"       , CVAR_ARCHIVE | CVAR_CLIENT, NULL         ,  "Set the amount of water rippling effect."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , gl_zfix                   , "gl_zfix"                 , "0"       , CVAR_NONE         , NULL                 ,  "Toggle an automatic z-fixing algorithm -- any z-fixing algorithm will produce inconsistent results from video card to video card and can cause mappers to not notice glaring map flaws."            )
#if 0
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_particles             , "qmb_particles"           , "0"       , CVAR_ARCHIVE, NULL        ,  "Toggle the use of the QMB particle effects system (not available in software renderer)."           )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_explosions             , "qmb_explosions"         , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_trails             	   , "qmb_trails"             , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_spikes                 , "qmb_spikes"             , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_gunshots               , "qmb_gunshots"           , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_blood                  , "qmb_blood"              , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_telesplash             , "qmb_telesplash"         , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_blobexplosions         , "qmb_blobexplosions"     , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_lavasplash             , "qmb_lavasplash"         , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_inferno                , "qmb_inferno"            , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_flames                 , "qmb_flames"             , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_lightning              , "qmb_lightning"          , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_spiketrails            , "qmb_spiketrails"        , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_explosionlightcolor    , "qmb_explosionlightcolor"  , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_rocketlightcolor       , "qmb_rocketlightcolor"     , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )

CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_explosiontype          , "qmb_explosiontype"        , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_explosionlight         , "qmb_explosionlight"       , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_rocketlight            , "qmb_rocketlight"          , "1"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )

CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_rockettrail            , "qmb_rockettrail"       , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_grenadetrail           , "qmb_grenadetrail"          , "1"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_bounceparticles        , "qmb_bounceparticles"          , "1"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_disableblood        , "qmb_disableblood"          , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_GL   , qmb_clipparticles        , "qmb_clipparticles"          , "0"       , CVAR_ARCHIVE         , NULL              ,  "QMB particle system setting"            )
#endif


CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_clearcolor              , "r_clearcolor"            , "2"       , CVAR_ARCHIVE      , R_SetClearColor_f    ,  "Sets the Quake palette color (0-255) for clearing a scene."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_drawentities            , "r_drawentities"          , "1"       , CVAR_NONE         , NULL                 ,  "Toggle drawing of entities."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_drawflat                , "r_drawflat"              , "0"       , CVAR_NONE         , NULL                 ,  "If 1, polygons will be drawn as a solid color with no lightmap or texture. Default 0."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_fullbright              , "r_fullbright"            , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the use of lights at full brightness on the map."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_lerpmodels              , "r_lerpmodels"            , "1"       , CVAR_NONE         , NULL                 ,  "If 1, do interpolation on model animations, with exceptions for torches (r_nolerp_list) & muzzleflares (interpolation is suspended for two frames if EF_MUZZLEFLASH is encountered, on the assumption a muzzleflare happens at the same time.) If 2, lerp all animations, without exception. If 0, disable interpolation (to mimic standard quake.) Default 0."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_lerpmove                , "r_lerpmove"              , "1"       , CVAR_NONE         , NULL                 ,  "If 1, do movement interpolation on MOVETYPE_STEP entities (i.e. monsters.) If 0, disable interpolation (to mimic standard quake.) I recommend that you use r_lerpmove and r_lerpmodels together, or turn them both off, otherwise monsters will move strangely. Default 0."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_lockfrustum             , "r_lockfrustum"           , "0"       , CVAR_NONE         , NULL                 ,  "Lock the frustum to current frame."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_lockpvs                 , "r_lockpvs"               , "0"       , CVAR_NONE         , NULL                 ,  "Lock the PVS to current frame."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_novis                   , "r_novis"                 , "0"       , CVAR_NONE         , R_VisChanged         ,  "Toggle the use of VIS information from the map data."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_speeds                  , "r_speeds"                , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the display of information about the renderer performance."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_stains                  , "r_stains"                , "1"       , CVAR_ARCHIVE      , Stain_Change_f       ,  "Toggle use stainmaps."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_stains_fadeamount       , "r_stains_fadeamount"     , "1"       , CVAR_NONE         , NULL                 ,  "Stainmap fade amount."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_NONE , r_stains_fadetime         , "r_stains_fadetime"       , "1"       , CVAR_NONE         , NULL                 ,  "Stainmap fade time."            )
CVAR_DEF( D_Init      , SCENE     ,  DEP_SW   , sw_d_mipscale             , "d_mipscale"              , "1"       , CVAR_NONE         , NULL                 ,  "Level of detail for rendering textures on the map."            )
CVAR_DEF( D_Init      , SCENE     ,  DEP_SW   , sw_d_subdiv16             , "d_subdiv16"              , "1"       , CVAR_NONE         , NULL                 ,  "(TODO: Unknown)"            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_aliasstats           , "r_polymodelstats"        , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the display of information about the number of models being drawn."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_aliastransadj        , "r_aliastransadj"         , "100"     , CVAR_NONE         , NULL                 ,  "Adjustment value for clipping model objects on the map."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_aliastransbase       , "r_aliastransbase"        , "200"     , CVAR_NONE         , NULL                 ,  "Adjustment value for clipping model objects on the map."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_ambient              , "r_ambient"               , "0"       , CVAR_NONE         , NULL                 ,  "The amount of ambient lighting on the map."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_draworder            , "r_draworder"             , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the correct order of rendering walls."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_dspeeds              , "r_dspeeds"               , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the display of renderer speed statistics."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_graphheight          , "r_graphheight"           , "10"      , CVAR_NONE         , NULL                 ,  "Vertical size in pixels of the graph displayed by the r_timegraph command."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_maxedges             , "r_maxedges"              , "0"       , CVAR_NONE         , NULL                 ,  "Maximum number of plane surface edges to be rendered."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_maxsurfs             , "r_maxsurfs"              , "0"       , CVAR_NONE         , NULL                 ,  "Maximum number of plane surfaces to be rendered."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_numedges             , "r_numedges"              , "0"       , CVAR_NONE         , NULL                 ,  "Toggle display of number of edges currently being rendered."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_numsurfs             , "r_numsurfs"              , "0"       , CVAR_NONE         , NULL                 ,  "Toggle display of number of surfaces which are being rendered."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_reportedgeout        , "r_reportedgeout"         , "0"       , CVAR_NONE         , NULL                 ,  "Toggle display of the number of edges which would be rendered outside of the map."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_reportsurfout        , "r_reportsurfout"         , "0"       , CVAR_NONE         , NULL                 ,  "Toggle display of the number of surfaces which would be rendered outside of the map."            )
CVAR_DEF( R_Init      , SCENE     ,  DEP_SW   , sw_r_timegraph            , "r_timegraph"             , "0"       , CVAR_NONE         , NULL                 ,  "Toggle display of a graph which shows the performance of the renderer in graphical format."            )
CVAR_DEF( D_Init      , SCENE     ,  DEP_SW   , sw_d_mipcap               , "d_mipcap"                , "0"       , CVAR_NONE         , NULL                 ,  "Level of detail for rendering textures on the map."            )


CVAR_DEF( SCR_Init    , SCREEN    ,  DEP_GL   , gl_conalpha               , "scr_conalpha"            , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Opacity when the console is halfscreen. Default 1. Set to 0.6 to mimic GLQuake."            ) //johnfitz
CVAR_DEF( SCR_Init    , SCREEN    ,  DEP_GL   , gl_conscale               , "scr_conscale"            , "1"       , CVAR_ARCHIVE      , SCR_Conwidth_f       ,  "Scales the console text larger, but only has an effect when scr_conwidth is 0. Default 1."            )
CVAR_DEF( SCR_Init    , SCREEN    ,  DEP_GL   , gl_conwidth               , "scr_conwidth"            , "0"       , CVAR_ARCHIVE      , SCR_Conwidth_f       ,  "Sets the virtual console width, where smaller numbers means larger text. Values larger than window width, or smaller than 320, will be clamped to that range, and all values will be rounded to a multiple of 8. If 0, the window width will be used. Note: values that divide evenly into the window width will make the text look nicest. Default 0."            )
CVAR_DEF( SCR_Init    , SCREEN    ,  DEP_GL   , gl_crosshairscale         , "scr_crosshairscale"      , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Scales the crosshair larger. 1 = normal, 10 = maximum enlargement. Default 1."            )
CVAR_DEF( SCR_Init    , SCREEN    ,  DEP_GL   , gl_menuscale              , "scr_menuscale"           , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Sets the scale factor for menus and other centered overlays. If 1, images will be drawn at 1:1 scale. If 2, images will be double size. Menus will never be drawn smaller than 1:1, and never larger than the size of the window. Note: integer values will make the text look nicest. Default 1."            )
CVAR_DEF( SCR_Init    , SCREEN    ,  DEP_NONE , scr_sbaralpha              , "scr_sbaralpha"           , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Controls the transparency of the statusbar background. 0 = invisible, 1 = opaque (original quake behavior), in-between values give different levels of transparency. Pro tip: set it to 0.99 and it will still appear opaque, but the 3D view will expand to fill the area on both sides of the statusbar. Default 1."            )
CVAR_DEF( SCR_Init    , SCREEN    ,  DEP_GL   , gl_sbarscale              , "scr_sbarscale"           , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Sets the scale factor for the statusbar. If 1, images will be drawn at 1:1 scale. If 2, images will be double size. The statusbar will never be drawn smaller than 1:1, and never larger than the width of the window. Note: integer values will make the text look nicest. Default 1."            )
CVAR_DEF( SCR_Init    , SCREEN    ,  DEP_NONE , scr_originalquake2d       , "scr_originalquake2d"            , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle use of original Quake positioning for scoreboard and centerprint."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_centertime            , "scr_centertime"          , "2"       , CVAR_NONE         , NULL                 ,  "Amount of time in seconds that center printed messages stay on the screen."            )
CVAR_DEF( SCR_Init    , SCREEN    ,  DEP_NONE , scr_clock                 , "scr_clock"               , "-1"      , CVAR_ARCHIVE      , NULL                 ,  "When to draw the clock on-screen (1: always, 0: deathmatch only, -1: never)."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_con_notifylines       , "con_notifylines"         , "4"       , CVAR_NONE         , NULL                 ,  "Number of notify messages (chat, \"you got the nails\", ..) drawn on the screen."            )  //seconds
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_con_notifytime        , "con_notifytime"          , "3"       , CVAR_NONE         , NULL                 ,  "Time in seconds that notify messages (chat, \"you got the nails\", ..) are displayed on the screen."            )  //seconds
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_conspeed              , "scr_conspeed"            , "300"     , CVAR_ARCHIVE      , NULL                 ,  "The speed the console screen lowers."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_crosshair             , "crosshair"               , "0"       , CVAR_ARCHIVE | CVAR_CLIENT , NULL        ,  "Toggles drawing of the crosshair.  Set to 2 for just a small dot."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_logcenterprint        , "con_logcenterprint"      , "1"       , CVAR_NONE         , NULL                 ,  "If 1, centerprint messages will be logged to the console in sp/coop. If 2, they will also be logged in deathmatch. Default 1."            ) //johnfitz
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_printspeed            , "scr_printspeed"          , "8"       , CVAR_NONE         , NULL                 ,  "Episode ending final message text printing speed (i.e. E1M7, END, ..)."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_sbarcentered          , "scr_sbarcentered"        , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle centering of status bar (ammo, health, ..) in deathmatch."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_scaleauto             , "scr_scaleauto"           , "1"       , CVAR_ARCHIVE      , SCR_Conwidth_f       ,  "Scale the menu, font and status bar autmatically (0: Off  1: medium  2: large)."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_scoreboard_pings      , "scr_scoreboardpings"        , "1"       , CVAR_NONE         , NULL                 ,  "Toggle drawing of scoreboard pings in multiplayer."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_showfps               , "scr_showfps"             , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle drawing of a frames-per-second (fps) indicator."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_showpos               , "scr_showpos"             , "0"       , CVAR_NONE         , NULL                 ,  "Toggle drawing of current location coordinates.  Related: viewpos, setpos."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_showspeed             , "scr_showspeed"           , "0"       , CVAR_NONE         , NULL                 ,  "Toggle drawing of current speed."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_showpause             , "showpause"               , "1"       , CVAR_NONE         , NULL                 ,  "Toggle graphical icon when the game is paused."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_showram               , "showram"                 , "1"       , CVAR_NONE         , NULL                 ,  "Toggle graphical icon when the game is running out of memory."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_showturtle            , "showturtle"              , "0"       , CVAR_NONE         , NULL                 ,  "Toggle graphical icon when the frame rate in the game drops below 10 frames-per-second."            )
CVAR_DEF( CL_Init     , SCREEN    ,  DEP_NONE , scr_viewsize              , "viewsize"                , "100"     , CVAR_ARCHIVE | CVAR_CLIENT , NULL        ,  "Size of viewable game screen (100: normal, 110: no weapons, 120: no status bar)."            )
CVAR_DEF( S_Init      , SOUND     ,  DEP_NONE , _snd_mixahead             , "_snd_mixahead"           , "0.1"     , CVAR_ARCHIVE      , NULL                 ,  "Amount of time in seconds to delay sound playback."            )
CVAR_DEF( S_Init      , SOUND     ,  DEP_NONE , ambient_fade              , "ambient_fade"            , "100"     , CVAR_NONE         , NULL                 ,  "Speed at which sounds fade in and out."            )
CVAR_DEF( S_Init      , SOUND     ,  DEP_NONE , ambient_level             , "ambient_level"           , "0.3"     , CVAR_CLIENT       , NULL                 ,  "Relative volume for ambient sounds heard throughout a map."            )
CVAR_DEF( S_Init      , SOUND     ,  DEP_NONE , bgmvolume                 , "bgmvolume"               , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Volume the music from the CD or mp3 is played."            )
CVAR_DEF( CDAudio_Init, SOUND     ,  DEP_NONE , external_music            , "external_music"          , "1"       , CVAR_ARCHIVE      , external_music_toggle_f,  "Toggle playback of external mp3 music (quake/id1/music/track06.mp3, ...)."          )
CVAR_DEF( S_Init      , SOUND     ,  DEP_NONE , nosound                   , "nosound"                 , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the playback of sound effects in the game."            )
CVAR_DEF( S_Init      , SOUND     ,  DEP_NONE , precache                  , "precache"                , "1"       , CVAR_NONE         , NULL                 ,  "Toggle preloading of all necessary sound files before the map starts."            )
CVAR_DEF( S_Init      , SOUND     ,  DEP_NONE , sfxvolume                 , "volume"                  , "0.7"     , CVAR_ARCHIVE      , NULL                 ,  "The volume for music and sound effects in the game."            )
CVAR_DEF( S_Init      , SOUND     ,  DEP_NONE , snd_noextraupdate         , "snd_noextraupdate"       , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the update of sound information for correct statistics for the host_speeds command."            )
CVAR_DEF( S_Init      , SOUND     ,  DEP_NONE , snd_show                  , "snd_show"                , "0"       , CVAR_NONE         , NULL                 ,  "Toggle display of the number of currently playing sound files."            )
CVAR_DEF( S_Init      , SOUND     ,  DEP_NONE , sndspeed                  , "sndspeed"                , "11025"   , CVAR_ARCHIVE      , S_Snd_Speed_Notify_f ,  "Sound output rate hz (values: 11025 Quake default, 22050, 44100)")
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , serverprofile             , "serverprofile"           , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the display of server performance statistics."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_autosave               , "sv_autosave"             , "1"       , CVAR_NONE		  , NULL                 ,  "Toggle automatic saving of single player progress every 90 seconds.  On by default: a0.sav, a1.sav, a2.sav are the save games names.  Useful if critical mistake was made and played for an hour without thinking of saving."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_progs                  , "sv_progs"                , DEFAULT_PROGS_DAT_NAME, CVAR_NONE		  , NULL                 ,  "Change the name of the program that the Quake VM runs, which is normally \"progs.dat\".")
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_pausable               , "pausable"                , "1"       , CVAR_NONE         , NULL                 ,  "Toggle ability of the player to temporarily stop the game."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sys_ticrate               , "sys_ticrate"             , "0.05"    , CVAR_NONE         , NULL                 ,  "The amount of time in seconds between consecutive packets send out by the server to the client."            ) // dedicated server
CVAR_DEF( SV_Init     , MODEL_PR  ,  DEP_NONE , sv_fix_func_train_angles  , "sv_gameplayfix_func_train_angles", "1"       , CVAR_NONE         , Host_Changelevel_Required_Msg                 ,  "Fix bad train angles like the single player release APSP1."            )
CVAR_DEF( SV_Init     , SV		  ,  DEP_NONE , sv_fix_setmodelrealbox    , "sv_gameplayfix_setmodelrealbox", "1"       , CVAR_NONE      , Host_Changelevel_Required_Msg                 ,  "Toggle use of real bounding box for setmodel.  Original Quake did not use the real model bounding box for physics instead setting +/- 16, some mods (Quake Rally is an example) depend on the bugged original behavior."            ) // mdl phys bbox
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_aim                    , "sv_aim"                  , "0.93"    , CVAR_ARCHIVE      , NULL                 ,  "The leniency value for player's aim adjustment."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_cheats                 , "sv_cheats"               , "1"       , CVAR_NONE | CVAR_SERVERINFO       , SV_Cheats_f ,  "Disable cheating (god, noclip, notarget, ..) in single/cooperative mode. (0: off, 1: no cheats, -1: minor cheats like give allowed).  Used primarily to prevent players from ruining cooperative games."     )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_cullentities           , "sv_cullentities"         , "0"       , CVAR_NOTIFY | CVAR_SERVERINFO     , NULL                 ,  "Anti-wallhack: very precise culling of objects that cannot be seen.  (0: off, 1: players only, 2: everything)  It's cpu intensive so doing a few players is fine but doing everything is overkill."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_idealpitchscale        , "sv_idealpitchscale"      , "0.8"     , CVAR_NONE         , NULL                 ,  "The height that the player's view moves up when going up stairs."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_novis                  , "sv_novis"                , "0"       , CVAR_NOTIFY | CVAR_SERVERINFO     , NULL                 ,  "Like r_novis, except the server ignores VIS information as well for a more complete level of r_novis."            )

CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_public                 , "sv_public"               , "0"       , CVAR_NOTIFY | CVAR_SERVERINFO     , NULL                 ,  "Reports server to master servers to appear in server lists."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_reportheartbeats       , "sv_reportheartbeats"     , "0"       , CVAR_NONE     , NULL                 ,  "Print server heartbeat status information to console."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , com_protocolname           , "host_protocolnames"         , "FTE-Quake,DarkPlaces-Quake"       , CVAR_NOTIFY | CVAR_SERVERINFO     , NULL                 ,  "Comma delimited list of game types requested from master server. The first one is what we would report as our gametype, if serving a game."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , net_masters				  , "net_masters", "dpmaster.deathmask.net:27950,dpmaster.tchr.no:27950,ghdigital.com:27950"            , CVAR_NOTIFY | CVAR_SERVERINFO     , NULL,  "Comma delimited list of master servers."            )


CVAR_DEF( CL_Init     , CL        ,  DEP_NONE , pq_bindprotect            , "pq_bindprotect"             , "0"       , CVAR_ARCHIVE						, NULL                 ,  "Ignore server sent key binds (1: Ignore silently, 2: Ignore and print).  Disabled by default.   "            )
CVAR_DEF( CL_Init     , CL        ,  DEP_NONE , pq_teamscores             , "pq_teamscores"              , "1"       , CVAR_NONE						, NULL                 ,  "Displays teamscores in HUD status bar for supporting mods (ProQuake extension)."            )
#ifdef SUPPORTS_PQ_CL_HTTP_DOWNLOAD 
CVAR_DEF( CL_Init     , CL        ,  DEP_NONE , pq_download_http		  , "pq_download_http"		  , "1"       , CVAR_NONE						, NULL                 ,  "Attempt downloading missing maps and models when connected to a server reporting as ProQuake 3.50 or greater server."            )
CVAR_DEF( CL_Init     , CL        ,  DEP_NONE , pq_download_http_url	  , "pq_download_http_url",	   "downloads.quake-1.com"  , CVAR_NONE						, NULL     ,  "Download source if attempting to download a map/model/sound when connected to a ProQuake 3.5 or greater server."            )
CVAR_DEF( CL_Init     , CL        ,  DEP_NONE , pq_download_http_locs	  , "pq_download_http_locs",	   "1"  , CVAR_ARCHIVE						, NULL     ,  "Toggle download attempt of .loc files if pq_download_http is also enabled."            )
#endif // SUPPORTS_PQ_CL_HTTP_DOWNLOAD 
CVAR_DEF( CL_Init     , CL        ,  DEP_NONE , pq_rquake				  , "pq_rquake"					 , "0"       , CVAR_NONE						, NULL                 ,  "Single player entities appear in deathmatch for RQuake.  RQuake is a co-op mod that uses the deathmatch scoreboard, certain entities like doors are sometimes marked NOT_IN_DEATHMATCH and would not normally appear."            )
CVAR_DEF( CL_Init     , SV        ,  DEP_NONE , pq_timer				  , "pq_timer"					 , "1"       , CVAR_NONE						, NULL                 ,  "Toggle use of match time display when a ProQuake server sends team game match information."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_chat_frags_to_talk	  , "pq_chat_frags_to_talk"		 , "0"       , CVAR_NONE						, NULL                 ,  "Minimum score for newly connected player to talk."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_chat_color_change_delay , "pq_chat_color_change_mute"  , "0"       , CVAR_NONE						, NULL                 ,  "Sets a delay when a player changes color before they can talk.")
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_chat_connect_mute_seconds      ,	"pq_chat_time_to_talk"		 , "0"       , CVAR_NONE						, NULL                 ,  "Number of seconds before newly connecting player can talk, allows a mod ban file to kick in first (which takes a few seconds, so a determined disruptor can chat spam and reconnect continually)."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_chat_log_player_number , "pq_chat_log_player_number"  , "1"       , CVAR_NONE						, NULL                 ,  "For chat logging, put the player # in the log to avoid name changing scripts faking a name."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_remove_cr		      , "pq_remove_cr"		     , "1"       , CVAR_NONE						, NULL                 ,  "Remove carriage returns from chat and console logging."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_chat_to_log			  , "pq_chat_to_log"		     , "0"       , CVAR_NONE						, NULL                 ,  "Log player chat messages to the console log."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_dedicated_dequake			  , "pq_dedicated_dequake"		     , "1"       , CVAR_NONE						, NULL                 ,  "Quake characters converted to ascii for legible dedicated console output."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_filter_gibs     , "sv_filter_gibs"           , "0"      , CVAR_NONE     , Mod_Flags_Refresh_f,  "Toggle server filtering gibs from clients."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_filter_gibs_list, "sv_filter_gibs_list"           , "progs/s_bubble.spr,progs/gib1.mdl,progs/gib2.mdl,progs/gib3.mdl,progs/h_player.mdl,progs/h_dog.mdl,progs/h_guard.mdl,progs/h_mega.mdl,progs/h_knight.mdl,progs/h_hellkn.mdl,progs/h_wizard.mdl,progs/h_ogre.mdl,progs/h_demon.mdl,progs/h_shal.mdl,progs/h_shams.mdl,progs/h_zombie.mdl"      , CVAR_NONE     , Mod_Flags_Refresh_f,  "Comma delimited list of models defined as gibs."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_full_invisibility   , "sv_full_invisibility"    , "0"       , CVAR_NONE | CVAR_SERVERINFO      , NULL                 ,  "Having invisibility ring conveys no information to other players."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_map_rotation   , "sv_map_rotation"    , ""       , CVAR_NONE | CVAR_SERVERINFO      , SV_Map_Rotation_Refresh_f,  "Easily set a space delimited map rotation for server."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_privacy_ipmasking	  , "pq_privacy_ipmasking"		 , "0"       , CVAR_NONE						, NULL                 ,  "Sets ip privacy ... 0: Quake normal, 1: ip masked, 2: masked and test shows 'private', 3: private to all"            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_privacy_name			  , "pq_privacy_name"			 , "0"       , CVAR_NONE						, NULL                 ,  "Sets name privacy ... 0: Quake normal, 1: 'anonymous' externally, 2: anonymous in-game."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_ping_rounding	      , "pq_ping_rounding"		     , "0"       , CVAR_NONE						, NULL                 ,  "Rounds ping displays to nearest 40 millisecond interval for external clients."            )
CVAR_DEF( SV_Init     , HOST      ,  DEP_NONE , pq_password               , "pq_password"                , ""       , CVAR_NONE						, NULL                 ,  "Server password."            )

CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_chat_word_filter       , "pq_chat_word_filter"        , "0"       , CVAR_NONE						, NULL                 ,  "Toggle \"bad\" word filter."            )
CVAR_DEF( SV_Init     , HOST      ,  DEP_NONE , rcon_password			  , "rcon_password"		         , ""       , CVAR_NONE						, NULL                 ,  "Remote console ability password, which is a basically admin (the ability to do \"rcon changelevel e4m5\", ..)."            )
CVAR_DEF( CL_Init     , CL        ,  DEP_NONE , rcon_server				  , "rcon_server"		         , ""       , CVAR_NONE						, NULL                 ,  "Run commands connected as if at this server console typing them."            )

CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_url_banfile			  , "sv_url_banfile"    , ""       , CVAR_NONE      , Admin_Banlist_URL_Changed_f,  "(TODO: UNUSED)"            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_url_whitelist		  , "sv_url_whitelist"    , ""       , CVAR_NONE      , Admin_Whitelist_URL_Changed_f,  "(TODO: UNUSED)"            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_max_sameip_connections , "sv_max_same_ip_connections" , "4"       , CVAR_NONE, NULL,  "TODO: Unimplemented.  Maximum connections from same ip.  Keep in mind LAN games, so try to exclude local networks."            )
CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , sv_fileserver_port		  ,	"sv_fileserver_port" , "+10"       , CVAR_NONE, NULL,  "File server port."            )


#if 0


//No server uses these because it is annoying
//CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_chat_spam_grace		  , "pq_chat_spam_grace"		 , "0"       , CVAR_NONE						, NULL                 ,  "Talking twice within this number of seconds triggers throttling of a player's chat"            )
//CVAR_DEF( SV_Init     , SV        ,  DEP_NONE , pq_chat_spam_rate		  , "pq_chat_spam_rate"			 , "0"       , CVAR_NONE						, NULL                 ,  "Amount to slow chatting"            )








#endif

CVAR_DEF( NET_Init    , SVNET     ,  DEP_NONE , net_connecttimeout        , "net_connecttimeout"      , "20"      , CVAR_NONE         , NULL                 ,  "Number of seconds of network inactivity before kicking a new connection."            ) // From ProQuake - qkick/qflood protection
CVAR_DEF( NET_Init    , SVNET     ,  DEP_NONE , net_messagetimeout        , "net_messagetimeout"      , "300"     , CVAR_NONE         , NULL                 ,  "Number of seconds of network inactivity before kicking a player."            )
CVAR_DEF( SV_Init     , SVPHYSICS ,  DEP_NONE , sv_accelerate             , "sv_accelerate"           , "10"      , CVAR_NONE         , NULL                 ,  "The value for player movement acceleration."            )
CVAR_DEF( SV_Init     , SVPHYSICS ,  DEP_NONE , sv_altnoclip              , "sv_altnoclip"            , "1"       , CVAR_ARCHIVE      , NULL                 ,  "If 1, enable the alternative noclip movement which resembles quake2 and is not constrained to the horizontal plane. Set to 0 to retain quake's original noclip behavior. Default 1."            ) //johnfitz
CVAR_DEF( SV_Init     , SVPHYSICS ,  DEP_NONE , sv_bouncedownslopes       , "sv_bouncedownslopes"     , "0"       , CVAR_NOTIFY | CVAR_SERVERINFO     , NULL                 ,  "Toggle a physics fix that will allow grenades to bounce down slopes."            )
CVAR_DEF( SV_Init     , SVPHYSICS ,  DEP_NONE , sv_friction               , "sv_friction"             , "4"       , CVAR_NOTIFY | CVAR_SERVERINFO     , NULL                 ,  "The friction value for the player's movement."            )
CVAR_DEF( SV_Init     , SVPHYSICS ,  DEP_NONE , sv_gravity                , "sv_gravity"              , "800"     , CVAR_NOTIFY | CVAR_SERVERINFO     , NULL                 ,  "The amount of gravity on the level."            )
CVAR_DEF( SV_Init     , SVPHYSICS ,  DEP_NONE , sv_maxspeed               , "sv_maxspeed"             , "320"     , CVAR_NOTIFY | CVAR_SERVERINFO     , NULL                 ,  "The maximum speed that the player can achieve through running."            )
CVAR_DEF( SV_Init     , SVPHYSICS ,  DEP_NONE , sv_maxvelocity            , "sv_maxvelocity"          , "2000"    , CVAR_NONE         , NULL                 ,  "The maximum speed that an object can achieve in the game."            )
CVAR_DEF( SV_Init     , SVPHYSICS ,  DEP_NONE , sv_nostep                 , "sv_nostep"               , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the automatic climbing of steps by the player."            )
CVAR_DEF( SV_Init     , SVPHYSICS ,  DEP_NONE , sv_edgefriction           , "edgefriction"            , "2"       , CVAR_NONE         , NULL                 ,  "The amount of imaginary friction when standing on an edge."            )
CVAR_DEF( SV_Init     , SVPHYSICS ,  DEP_NONE , sv_stopspeed              , "sv_stopspeed"            , "100"     , CVAR_NONE         , NULL                 ,  "The velocity the player will start slowing down to stop his movement."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_coop                   , "coop"                    , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the usage of the cooperative game mode."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_deathmatch             , "deathmatch"              , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the deathmatch game mode."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_fraglimit              , "fraglimit"               , "0"       , CVAR_NOTIFY | CVAR_SERVERINFO , Host_Callback_Notify,  "The amount of kills necessary to proceed to the next map in deathmatch games." )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_gamecfg                , "gamecfg"                 , "0"       , CVAR_NONE         , NULL                 ,  "Server variable for use custom mod use."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_noexit                 , "noexit"                  , "0"       , CVAR_NOTIFY | CVAR_SERVERINFO , Host_Callback_Notify,  "Toggle if players are allowed to exit the level in multiplayer games." )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_nomonsters             , "nomonsters"              , "0"       , CVAR_NONE         , NULL                 ,  "Supposed to toggle the presence of monsters on the map.  It never worked."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_samelevel              , "samelevel"               , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the constant cycling of the same map on a server."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_saved1                 , "saved1"                  , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Server variable for use custom mod use."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_saved2                 , "saved2"                  , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Server variable for use custom mod use."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_saved3                 , "saved3"                  , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Server variable for use custom mod use."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_saved4                 , "saved4"                  , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Server variable for use custom mod use."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_savedgamecfg           , "savedgamecfg"            , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Server variable for use custom mod use."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_scratch1               , "scratch1"                , "0"       , CVAR_NONE         , NULL                 ,  "Server variable for use custom mod use."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_scratch2               , "scratch2"                , "0"       , CVAR_NONE         , NULL                 ,  "Server variable for use custom mod use."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_scratch3               , "scratch3"                , "0"       , CVAR_NONE         , NULL                 ,  "Server variable for use custom mod use."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_scratch4               , "scratch4"                , "0"       , CVAR_NONE         , NULL                 ,  "Server variable for use custom mod use."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_skill                  , "skill"                   , "1"       , CVAR_NONE         , NULL                 ,  "The difficulty setting for the game."            )      // 0 - 3
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_teamplay               , "teamplay"                , "0"       , CVAR_NOTIFY | CVAR_SERVERINFO , Host_Callback_Notify,  "Toggle the settings for teamplay games." )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_temp1                  , "temp1"                   , "0"       , CVAR_NONE         , NULL                 ,  "Server variable for use custom mod use."            )
CVAR_DEF( PR_Init     , SVPR      ,  DEP_NONE , pr_timelimit              , "timelimit"               , "0"       , CVAR_NOTIFY | CVAR_SERVERINFO , Host_Callback_Notify,  "Minutes of play before automatically switching to the next map." )
CVAR_DEF( PR_Init     , SVVM      ,  DEP_NONE , vm_coop_enhancements      , "sv_coop_enhancements"    , "1"       , CVAR_NONE         , NULL                 ,  "Toggle per-player coop scoreboard and similar coop niceties like forcing coop teamplay players to all have the same pants color so cannot hurt each other."            )
CVAR_DEF( PR_Init     , SVVM      ,  DEP_NONE , vm_fishfix                , "sv_gameplayfix_fish_count_bug_override"   , "1"       , CVAR_NONE         , NULL                 ,  "Toggle automatic fish count bug-fix."            )
CVAR_DEF( PR_Init     , SVVM      ,  DEP_NONE , vm_imp12hack              , "sv_gameplayfix_no_impulse12_override"     , "1"       , CVAR_NONE         , NULL                 ,  "Toggle automatic support for impulse 12 (previous weapon) even in mods that unintentionally did not support impulse 12."            )
CVAR_DEF( PR_Init     , SVVM      ,  DEP_NONE , vm_imp12hack_exceptions   , "sv_gameplayfix_no_impulse12_exceptions"     , "ne_ruins"       , CVAR_NONE         , NULL                 ,  "Exclude impulse 12 (previous weapon) fix from gamedirs with these names."            )
CVAR_DEF( PR_Init     , SVVM      ,  DEP_NONE , sv_fix_flush_alias_exceptions   , "sv_gameplayfix_flush_alias_exceptions"     , "frogbot"       , CVAR_NONE         , NULL                 ,  "Disable alias and keybind flushing for certain clevel mods like frogbots that preserve information in cvars for memory across disconnects."            )

CVAR_DEF( VID_Init    , VIDEO     ,  DEP_NONE , vid_gamma                 , "gamma"                   , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Screen gamma correction level."            )
CVAR_DEF( VID_Init    , VIDEO     ,  DEP_GL   , vid_hardwaregamma         , "vid_hardwaregamma"       , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle use of hardware gamma/contrast correction."            )
CVAR_DEF( VID_Init    , VIDEO     ,  DEP_GL   , vid_multisample           , "vid_multisample"         , "0"       , CVAR_ARCHIVE      , VID_Local_Multisample_f,  "Enables costly edge smoothing (values: 0, 2, 4, 8)"          )
CVAR_DEF( VID_Init    , VIDEO     ,  DEP_NONE , vid_contrast              , "contrast"                , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Screen contrast correction level."            )
CVAR_DEF( VID_Init    , VIDEO     ,  DEP_NONE , vid_fullscreen            , "vid_fullscreen"          , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Set fullscreen preference. Requires vid_restart."            )
CVAR_DEF( VID_Init    , VIDEO     ,  DEP_SW   , vid_sw_stretch            , "vid_stretch"             , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Stretch simulates lower resoluton (2: 320 x 240 1:640 x 480 0: off) as close as possible.  Requires vid_restart. Provide lower resolution appearance on displays without low resolution modes available."            )
CVAR_DEF( VID_Init    , VIDEO     ,  DEP_NONE , vid_height                , "vid_height"              , "480"     , CVAR_ARCHIVE      , NULL                 ,  "Requested video mode height."            )
CVAR_DEF( VID_Init    , VIDEO     ,  DEP_FREQ , vid_refreshrate           , "vid_refreshrate"         , "60"      , CVAR_ARCHIVE      , NULL                 ,  "Requested video mode refresh rate. (TODO: This isn't used.  Remove?)"            )
CVAR_DEF( VID_Init    , VIDEO     ,  DEP_FREQ , vid_vsync                 , "vid_vsync"              , "0"       , CVAR_ARCHIVE      , VID_Local_Vsync_f   ,  "Toggle use of vsync to eliminate tearing."            )
CVAR_DEF( VID_Init    , VIDEO     ,  DEP_NONE , vid_width                 , "vid_width"               , "640"     , CVAR_ARCHIVE      , NULL                 ,  "Requested video mode width."            )
CVAR_DEF( VID_Init    , VIDEO     ,  DEP_NONE , vid_sound_thread		  , "vid_sound_thread"        , "1"       , CVAR_ARCHIVE      , NULL                 ,  "(TODO: Unused)"            )
CVAR_DEF( Chase_Init  , VIEW      ,  DEP_NONE , chase_active              , "chase_active"            , "0"       , CVAR_NONE         , NULL                 ,  "Toggle the use of a chase camera."            )
CVAR_DEF( Chase_Init  , VIEW      ,  DEP_NONE , chase_back                , "chase_back"              , "100"     , CVAR_NONE         , NULL                 ,  "Distance chase camera behind the player."            )
CVAR_DEF( Chase_Init  , VIEW      ,  DEP_NONE , chase_right               , "chase_right"             , "0"       , CVAR_NONE         , NULL                 ,  "Distance chase camera to the right of the player."            )
CVAR_DEF( Chase_Init  , VIEW      ,  DEP_NONE , chase_up                  , "chase_up"                , "16"      , CVAR_NONE         , NULL                 ,  "Distance chase camera above the player."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , cl_bob                    , "cl_bob"                  , "0.02"    , CVAR_ARCHIVE | CVAR_CLIENT , NULL        ,  "Distance that weapon moves up and down on the screen when running."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , cl_bobcycle               , "cl_bobcycle"             , "0.6"     , CVAR_ARCHIVE      , NULL                 ,  "Time in seconds that it takes the weapon to move up and down on the screen."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , cl_bobside                , "cl_bobside"              , "0.02"    , CVAR_ARCHIVE      , NULL                 ,  "Amount of side bobbing."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , cl_bobsidecycle           , "cl_bobsidecycle"         , "0.9"     , CVAR_ARCHIVE      , NULL                 ,  "The time in seconds that it takes the weapon to side bobbing to complete a cycle.."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , cl_bobsideup              , "cl_bobsideup"            , "0.5"     , CVAR_ARCHIVE      , NULL                 ,  "Side bobbing setting."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , cl_bobup                  , "cl_bobup"                , "0.5"     , CVAR_ARCHIVE      , NULL                 ,  "Time in seconds that the weapon stays in the up position."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , cl_rollangle              , "cl_rollangle"            , "2.0"     , CVAR_ARCHIVE      , NULL                 ,  "Angle in degrees the player tilts when strafing right and left."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , cl_rollspeed              , "cl_rollspeed"            , "200"     , CVAR_NONE         , NULL                 ,  "Speed the player recovers to a straight posture after tilting left or right."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , cl_sidebobbing            , "cl_sidebobbing"          , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle the use of side bobbing."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , cl_titledemos_list        , "cl_titledemos_list"      , ""        , CVAR_NONE         , NULL                 ,  "Comma delimited list of title demos."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , r_drawviewmodel           , "r_drawviewmodel"         , "1"       , CVAR_CLIENT       , NULL                 ,  "Toggle drawing of view model (gun)."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , r_lavacshift              , "r_lavacolor"             , "255 80 0 150", CVAR_NONE    , View_LavaCshift_f    ,  "Screen color when submerged in lava."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , r_slimecshift             , "r_slimecolor"            , "0 25 5 150", CVAR_NONE       , View_SlimeCshift_f   ,  "Screen color when submerged in slime."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , r_viewmodel_ring          , "r_viewmodel_ring"      , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Toggles drawing of (transparent) weapon when holding invisibility ring."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , r_viewmodel_size         , "r_viewmodel_size"       , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Increase amount of weapon shown (2 is more, 0.5 is less)")
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , r_viewmodel_fov           , "r_viewmodel_fov"         , "90"      , CVAR_ARCHIVE      , NULL                 ,  "Makes weapon drawing immune to field of view settings.  When set to a non-zero value, the gun will be drawn as if the screen field-of-view is this number --- no matter what fov value is actually used."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , r_viewmodel_quake         , "r_viewmodel_quake"       , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle drawing of weapon in same position as original Quake, instead of the FitzQuake position."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , r_viewmodel_offset        , "r_viewmodel_offset"      , "0"       , CVAR_ARCHIVE      , NULL                 ,  "Adjust weapon position to the left or right (example: 5)."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , r_watercshift             , "r_watercolor"            , "130 80 50 128", CVAR_NONE    , View_WaterCshift_f   , "Screen color when submerged in water."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , r_waterwarp               , "r_waterwarp"             , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle the use of the screen warping effect when the player is submerged in liquids.  Set to below zero for water warp in GL version, but not in WinQuake version."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , scr_fov                   , "fov"                     , "90"      , CVAR_ARCHIVE | CVAR_CLIENT , NULL        ,  "Size in degrees of the field-of-vision that the player sees."            ) // 10 - 170
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_centermove              , "v_centermove"            , "0.15"    , CVAR_NONE         , NULL                 ,  "Distance that the player must move before the screen automatically centers itself when the lookspring toggle is enabled."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_centerspeed             , "v_centerspeed"           , "500"     , CVAR_NONE         , NULL                 ,  "Speed the screen will automatically return to the center position."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_cshiftpercent           , "gl_cshiftpercent"        , "100"     , CVAR_NONE         , NULL                 ,  "Percent of content shifting to display."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_gunkick                 , "v_gunkick"               , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle gun kicking (0: none, 1: WinQuake, 2: animation smoothed)"            ) // johnfitz
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_smoothstairs            , "v_smoothstairs"          , "1"       , CVAR_ARCHIVE      , NULL                 ,  "Toggle stair step smoothing."            ) // johnfitz
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_idlescale               , "v_idlescale"             , "0"       , CVAR_CLIENT       , NULL                 ,  "The amount that the screen should sway."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_ipitch_cycle            , "v_ipitch_cycle"          , "1"       , CVAR_NONE         , NULL                 ,  "The speed the screen should sway up and down."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_ipitch_level            , "v_ipitch_level"          , "0.3"     , CVAR_NONE         , NULL                 ,  "Distance that the screen should sway up and down."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_iroll_cycle             , "v_iroll_cycle"           , "0.5"     , CVAR_NONE         , NULL                 ,  "Speed the screen should roll clockwise and counter clockwise."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_iroll_level             , "v_iroll_level"           , "0.1"     , CVAR_NONE         , NULL                 ,  "Distance the screen should roll clockwise and counter clockwise."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_iyaw_cycle              , "v_iyaw_cycle"            , "2"       , CVAR_NONE         , NULL                 ,  "Speed the screen should turn left and right."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_iyaw_level              , "v_iyaw_level"            , "0.3"     , CVAR_NONE         , NULL                 ,  "Distance the screen should turn left and right."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_kickpitch               , "v_kickpitch"             , "0.6"     , CVAR_ARCHIVE      , NULL                 ,  "Distance the screen should move up or down when the player is shot."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_kickroll                , "v_kickroll"              , "0.6"     , CVAR_ARCHIVE      , NULL                 ,  "Distance the screen should roll clockwise or counter clockwise when the player is shot."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_kicktime                , "v_kicktime"              , "0.5"     , CVAR_ARCHIVE      , NULL                 ,  "The amount of time that the screen should remain tiled after the player has been shot."            )
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_polyblend               , "gl_polyblend"            , "1"       , CVAR_ARCHIVE | CVAR_CLIENT , R_PolyBlendChanged_f, "Toggle the use of palette color blending and flashing effects."           )  // Baker: --> // JPG 3.30 - winquake version of r_polyblend
CVAR_DEF( View_Init   , VIEW      ,  DEP_NONE , v_polyblend_lite          , "v_polyblend_lite"        , "0"       , CVAR_ARCHIVE | CVAR_CLIENT , R_PolyBlendChanged_f, "Toggle use of less intense polyblending."           )  // Baker: --> // JPG 3.30 - winquake version of r_polyblend

// Class = Client?  Fieldn't isn't used at this time anyway.
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx00                 , "nehx00"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx01                 , "nehx01"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx02                 , "nehx02"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx03                 , "nehx03"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx04                 , "nehx04"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx05                 , "nehx05"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx06                 , "nehx06"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx07                 , "nehx07"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx08                 , "nehx08"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx09                 , "nehx09"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx10                 , "nehx10"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx11                 , "nehx11"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx12                 , "nehx12"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx13                 , "nehx13"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx14                 , "nehx14"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx15                 , "nehx15"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx16                 , "nehx16"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx17                 , "nehx17"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx18                 , "nehx18"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )
//	CVAR_DEF( Nehahra_Init     , CLIENT    ,  DEP_NONE , nehx19                 , "nehx19"               , "0"       , CVAR_NONE         , NULL                 ,  "Nehahra internal variable."            )



#undef CVAR_DEF
