/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef _PROGS_H_
#define _PROGS_H_

#include "pr_comp.h"			// defs shared with qcc
#include "progdefs.h"			// generated by program cdefs

typedef union eval_s
{
	string_t		string;
	float			_float;
	float			vector[3];
	func_t			function;
	int				_int;
	int				edict;
} eval_t;


typedef struct link_s
{
	struct link_s	*prev, *next;
} link_t;

// (type *)STRUCT_FROM_LINK(link_t *link, type, member)
// ent = STRUCT_FROM_LINK(link,entity_t,order)
// FIXME: remove this mess!
#define	STRUCT_FROM_LINK(l,t,m) ((t *)((byte *)l - (size_t)&(((t *)0)->m)))
#define	EDICT_FROM_AREA(l) STRUCT_FROM_LINK(l,edict_t,area)


#define	MAX_ENT_LEAFS	16
typedef struct edict_s
{
	qbool		inuse;
	link_t		area;				// linked to a division node or leaf

	int			num_leafs;
	short		leafnums[MAX_ENT_LEAFS];	// for pvs checks, already -1

	entity_state_t	baseline;

	float		freetime;			// sv.time when the object was freed
	double		lastruntime;		// sv.time when SV_RunEntity was last
									// called for this edict
	entvars_t	v;					// C exported fields from progs
// other fields from progs come immediately after
} edict_t;

//============================================================================

extern	dprograms_t		*progs;
extern	dfunction_t		*pr_functions;
extern	char			*pr_strings;
extern	ddef_t			*pr_globaldefs;
extern	ddef_t			*pr_fielddefs;
extern	dstatement_t	*pr_statements;
extern	globalvars_t	*pr_global_struct;
extern	float			*pr_globals;			// same as pr_global_struct

extern	int				pr_edict_size;	// in bytes


#ifdef WITH_NQPROGS

extern	qbool			pr_nqprogs;

extern	int pr_fieldoffsetpatch[106];
extern	int pr_globaloffsetpatch[62];

#define PR_FIELDOFS(i) ((unsigned int)(i) > 105 ? (i) : pr_fieldoffsetpatch[i])
#define PR_GLOBAL(field) (((globalvars_t *)((byte *)pr_global_struct + \
	pr_globaloffsetpatch[((int *)&((globalvars_t *)0)->field - (int *)0) - 28]))->field)

void NQP_Reset (void);

#else	// !WITH_NQPROGS

#define pr_nqprogs 0
#define PR_FIELDOFS(i) (i)
#define PR_GLOBAL(field) pr_global_struct->field
#define NQP_Reset()

#endif



void PR_Init (void);
void PR_InitBuiltins (void);

void PR_ExecuteProgram (func_t fnum);
void PR_LoadProgs (void);

void PR_Profile_f (void);

edict_t *ED_Alloc (void);
void ED_Free (edict_t *ed);

char	*ED_NewString (char *string);
// returns a copy of the string allocated from the server's string heap

void ED_Print (edict_t *ed);
void ED_Write (FILE *f, edict_t *ed);
char *ED_ParseEdict (char *data, edict_t *ent);

void ED_WriteGlobals (FILE *f);
void ED_ParseGlobals (char *data);

void ED_LoadFromFile (char *data);

//define EDICT_NUM(n) ((edict_t *)((byte *)sv.edicts + (n)*pr_edict_size))
//define NUM_FOR_EDICT(e) (((byte *)(e) - (byte *)sv.edicts)/pr_edict_size)

edict_t *EDICT_NUM(int n);
int NUM_FOR_EDICT(edict_t *e);

#define	NEXT_EDICT(e) ((edict_t *)( (byte *)e + pr_edict_size))

#define	EDICT_TO_PROG(e) ((byte *)e - (byte *)sv.edicts)
#define PROG_TO_EDICT(e) ((edict_t *)((byte *)sv.edicts + e))

//============================================================================

#define	G_FLOAT(o) (pr_globals[o])
#define	G_INT(o) (*(int *)&pr_globals[o])
#define	G_EDICT(o) ((edict_t *)((byte *)sv.edicts+ *(int *)&pr_globals[o]))
#define G_EDICTNUM(o) NUM_FOR_EDICT(G_EDICT(o))
#define	G_VECTOR(o) (&pr_globals[o])
#define	G_STRING(o) (PR_GetString(*(string_t *)&pr_globals[o]))
#define	G_FUNCTION(o) (*(func_t *)&pr_globals[o])

#define	E_FLOAT(e,o) (((float*)&e->v)[o])
#define	E_INT(e,o) (*(int *)&((float*)&e->v)[o])
#define	E_VECTOR(e,o) (&((float*)&e->v)[o])
#define	E_STRING(e,o) (PR_GetString(*(string_t *)&((float*)&e->v)[PR_FIELDOFS(o)]))

extern	int		type_size[8];

typedef void (*builtin_t) (void);
extern builtin_t *pr_builtins;
extern int pr_numbuiltins;

// list of extensions which are off by default
// a checkextension(..) call from progs enables the corresponding extension
extern struct pr_ext_enabled_s {
	qbool zq_clientcommand;
	qbool zq_consolecommand;
	qbool zq_pause;
} pr_ext_enabled;

extern int		pr_argc;

extern	qbool		pr_trace;
extern	dfunction_t	*pr_xfunction;
extern	int			pr_xstatement;


extern func_t SpectatorConnect, SpectatorDisconnect, SpectatorThink;
extern func_t BotConnect, BotDisconnect, BotPreThink, BotPostThink;
extern func_t GE_ClientCommand, GE_ConsoleCommand, GE_PausedTic, GE_ShouldPause;

extern int	fofs_gravity, fofs_maxspeed, fofs_items2;
extern int	fofs_forwardmove, fofs_sidemove, fofs_upmove;
#ifdef VWEP_TEST
extern int	fofs_vw_index;
#endif
extern int	fofs_buttonX[8-3];

#define EdictFieldFloat(ed, fieldoffset) ((eval_t *)((byte *)&(ed)->v + (fieldoffset)))->_float


void PR_RunError (char *error, ...);

void ED_PrintEdicts_f (void);
void ED_PrintNum (int ent);

//
// PR strings stuff
//
#define MAX_PRSTR 1024		// max static strings
#define MAX_DYN_PRSTR 1024	// max dynamic strings

extern char *pr_strtbl[MAX_PRSTR + MAX_DYN_PRSTR];
extern int num_prstr;

char *PR_GetString(int num);
int PR_SetString(char *s);
void PR_InitStrings (void);
void PR_FreeStrings (void);

#endif /* _PROGS_H_ */

