/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// gl_local.h -- private refresh defs


// disable data conversion warnings

#pragma warning (disable : 4244)     // MIPS
#pragma warning (disable : 4136)     // X86
#pragma warning (disable : 4051)     // ALPHA
  
#ifdef _WIN32
#include <windows.h>
#endif

#ifdef MACOSX
#include 	<OpenGL/gl.h>
#include 	<OpenGL/glu.h>
#include	<OpenGL/glext.h>
#include	<math.h>
#elif defined(DX8QUAKE)
#include "dx8_fakegl.h"
#else
#include <GL/gl.h>
#endif /* MACOSX */

#ifndef APIENTRY
#define APIENTRY
#endif



#include "gl_texture.h"


void GL_BeginRendering (int *x, int *y, int *width, int *height);
void GL_EndRendering (void);

typedef struct {
	float	x, y, z;
	float	s, t;
	float	r, g, b;
} glvert_t;

extern	glvert_t	glv;

extern	int	glx, gly, glwidth, glheight;

#define ALIAS_BASE_SIZE_RATIO	(1.0 / 11.0) // normalizing factor so player model works out to about 1 pixel per triangle
#define	MAX_LBM_HEIGHT		480

#define SKYSHIFT		7
#define	SKYSIZE			(1 << SKYSHIFT)
#define SKYMASK			(SKYSIZE - 1)

#define BACKFACE_EPSILON	0.01



void QMB_InitParticles (void);
void QMB_ClearParticles (void);
void QMB_DrawParticles (void);

void QMB_RunParticleEffect (vec3_t org, vec3_t dir, int color, int count);
void QMB_RocketTrail (vec3_t start, vec3_t end, vec3_t *trail_origin, trail_type_t type);
void QMB_BlobExplosion (vec3_t org);
void QMB_ParticleExplosion (vec3_t org);
void QMB_LavaSplash (vec3_t org);
void QMB_TeleportSplash (vec3_t org);
void QMB_InfernoFlame (vec3_t org);
void QMB_StaticBubble (entity_t *ent);
void QMB_ColorMappedExplosion (vec3_t org, int colorStart, int colorLength);
void QMB_TorchFlame (vec3_t org, float size, float time);
void QMB_MissileFire (vec3_t org, vec3_t start, vec3_t end);
void QMB_ShamblerCharge (vec3_t org);
void QMB_LightningBeam (vec3_t start, vec3_t end);
void QMB_GenSparks (vec3_t org, byte col[3], float count, float size, float life);

extern	qboolean	qmb_initialized;

void CheckParticles (void);

//====================================================


extern	qboolean	r_cache_thrash;		// compatability
extern	vec3_t		modelorg, r_entorigin;
extern	entity_t	*currententity;
extern	int			r_visframecount;
extern	int		r_framecount;
extern	mplane_t	frustum[4];
extern	int		c_brush_polys, c_alias_polys;

// view origin
extern	vec3_t	vup;
extern	vec3_t	vpn;
extern	vec3_t	vright;
extern	vec3_t	r_origin;

// screen size info
extern	refdef_t	r_refdef;
extern	mleaf_t		*r_viewleaf, *r_oldviewleaf;
extern	mleaf_t		*r_viewleaf2, *r_oldviewleaf2;	// for watervis hack

extern	int	gl_solid_format;
extern	int	gl_alpha_format;

// rendering cvar stuffs
extern	cvar_t	r_drawentities;
extern	cvar_t	r_drawworld;

extern	cvar_t	r_speeds;
extern	cvar_t	r_waterwarp;
extern	cvar_t	r_fullbright;
extern	cvar_t	r_lightmap;
extern	cvar_t	r_shadows;
extern	cvar_t	r_wateralpha;
extern	cvar_t	r_dynamic;
extern	cvar_t	r_novis;
extern	cvar_t	r_fullbrightskins;
extern	cvar_t	r_fastsky;
extern	cvar_t	r_skycolor;
extern	cvar_t	r_skybox;
extern	cvar_t	r_farclip;

// fenix@io.com: model interpolation
extern  cvar_t  r_interpolate_animation;
extern  cvar_t  r_interpolate_transform;



// gl rendering cvars and stuff
extern	cvar_t	gl_clear;
extern	cvar_t	gl_cull;
extern	cvar_t	gl_poly;
extern	cvar_t	gl_ztrick; // vid_glcommon
extern	cvar_t	gl_smoothmodels;
extern	cvar_t	gl_affinemodels;
extern	cvar_t	gl_polyblend;
extern	cvar_t	gl_flashblend;
extern	cvar_t	gl_nocolors;
extern	cvar_t	gl_doubleeyes;
#ifdef SUPPORTS_XFLIP
extern	cvar_t	gl_xflip;
#endif
extern	cvar_t	gl_playermip;
extern	cvar_t	gl_picmip;
extern	cvar_t	gl_picmip_all;


// qmb and joequakey gl cvars (nostly)
extern  cvar_t  gl_caustics;
extern  cvar_t  gl_detail;
extern	cvar_t	gl_loadlitfiles;
extern	cvar_t	gl_interdist;
extern  cvar_t  gl_waterfog;		
extern  cvar_t  gl_waterfog_density;
extern	cvar_t	gl_fb_bmodels;
extern	cvar_t	gl_fb_models;
extern  cvar_t  gl_solidparticles;

extern  cvar_t  gl_vertexlights;

extern  cvar_t	gl_part_explosions;
extern  cvar_t	gl_part_trails;
extern  cvar_t	gl_part_spikes;
extern  cvar_t	gl_part_gunshots;
extern  cvar_t	gl_part_blood;
extern  cvar_t	gl_part_telesplash;
extern  cvar_t	gl_part_blobs;
extern  cvar_t	gl_part_lavasplash;
extern  cvar_t	gl_part_inferno;
extern	cvar_t	gl_part_flames;
extern	cvar_t	gl_part_lightning;
extern	cvar_t	gl_part_spiketrails;

extern	cvar_t	gl_bounceparticles;
extern	cvar_t	gl_clipparticles;
extern 	cvar_t gl_externalTextures_world, gl_externalTextures_bmodels;


extern	float	r_world_matrix[16];

extern	const char *gl_vendor;
extern	const char *gl_renderer;
extern	const char *gl_version;
extern	const char *gl_extensions;





// gl_warp.c
void GL_SubdivideSurface (msurface_t *fa);
void EmitWaterPolys (msurface_t *fa);
void EmitSkyPolys (msurface_t *fa, qboolean mtex);
void CalcCausticTexCoords(float *v, float *s, float *t);
void EmitCausticsPolys (void);
void R_DrawSkyChain (void);
void R_AddSkyBoxSurface (msurface_t *fa);
void R_ClearSkyBox (void);
void R_DrawSkyBox (void);
extern qboolean	r_skyboxloaded;
int R_SetSky (char *skyname);

// gl_draw.c
void GL_Set2D (void);

// gl_rmain.c
qboolean R_CullBox (vec3_t mins, vec3_t maxs);
qboolean R_CullSphere (vec3_t centre, float radius);
void R_RotateForEntity (entity_t *e);
void R_PolyBlend (void);
void R_BrightenScreen (void);

// gl_rlight.c
void R_MarkLights (dlight_t *light, int bit, mnode_t *node);
void R_AnimateLight (void);
void R_RenderDlights (void);
int R_LightPoint (vec3_t p);
float R_GetVertexLightValue (int index, float apitch, float ayaw);
float R_LerpVertexLight (int index1, int index2, float ilerp, float apitch, float ayaw);
void R_InitVertexLights (void);
extern	float	bubblecolor[NUM_DLIGHTTYPES][4];
extern	vec3_t	lightspot, lightcolor;
extern	float	vlight_pitch, vlight_yaw;


// gl_refrag.c
void R_StoreEfrags (efrag_t **ppefrag);

// gl_mesh.c
void GL_MakeAliasModelDisplayLists (model_t *m, aliashdr_t *hdr);

// gl_rsurf.c
void EmitDetailPolys (void);
void R_DrawBrushModel (entity_t *e);
void R_DrawWorld (void);
void GL_BuildLightmaps (void);


// gl_rmisc.c
void R_TimeRefresh_f (void);
void R_ReadPointFile_f (void);
void R_InitOtherTextures (void);
#define ISTRANSPARENT(ent)	((ent)->istransparent && (ent)->transparency > 0 && (ent)->transparency < 1)

// gl_rpart.c

//vid_common_gl.c


extern qboolean	gl_add_ext;
extern qboolean gl_allow_ztrick;

qboolean CheckExtension (const char *extension);



//palette stuffs
void Check_Gamma (unsigned char *pal);
void VID_SetPalette (unsigned char *palette);
void GL_Init (void);

extern	float	gldepthmin, gldepthmax;
extern	byte	color_white[4], color_black[4];

