/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// quakedef.h -- primary header for client

//#define	GLTEST			// experimental stuff

#define	QUAKE_GAME			// as opposed to utilities

#define ENGINE_NAME "ProQuake Dedicated Ex"
#define ENGINE_VERSION 	"1.00"
#define PROQUAKE_SERIES_VERSION		3.50


#define SV_IPMASKING_NO_MASK_0			0
#define SV_IPMASKING_SIMPLE_MASK_1		1	// Simple 192.168.1.x masking
#define SV_IPMASKING_ANON_EXTERNAL_2	2	// Above + "anonymous" to test2 queries
#define SV_IPMASKING_ANONYMOUS_ALL_3	3	// Anonymous all
#define SV_IPMASKING_ANONYMOUS_EXTERN_4	4	// Anonymous all (test does not show names)


#if 1
#define SUPPORTS_MAP_NOT_FOUND_DEFAULT	// If map isn't found, use start map instead.
#define SUPPORTS_CHECK_RIGHT_DIR		// If can't find in working directory uses executable directory (Windows)
#define SUPPORTS_SV_IPMASKING			// 1 = Mask IP, 2 = Mask here block external, 3 = Anonymous all, 4 = Test does not show names
#define SUPPORTS_ANTI_WALLHACK			// Obvious
#define SUPPORTS_PQ_CONNECTMUTE			// Prevents players from talking for 3 seconds (by default)
#define SUPPORTS_IPLOG_DEFAULTS_ON		// Obvious
#define SUPPORTS_SV_PROGS 				// (sv_progs) Can be useful for testing
#define SUPPORTS_QC_EXEC				// QC Exec ability
#define SUPPORTS_CLOCK_FIX				// Important
#define SUPPORTS_EXTERNAL_ENTS			// Always on.  External entities from id1\maps folders "start.ent", etc.
#define SUPPORTS_SV_RQUAKE				// RQuake support (sv_rquake 1)
#define SUPPORTS_ENTITY_SEND_FILTERING	// Eyes, gibs, bubbles (sv_full_invisibility, sv_gibless)
#define SUPPORTS_DISABLE_CHEATS			// Ability to disable "god", "notarget", "noclip" in coop and non-deathmatch
#define SUPPORTS_NEW_DEFAULTS			// Small log changes
#define SUPPORTS_FRAGS_TO_TALK			// (sv_frags_to_talk) Talking allowed only for those with at least X frags
#define SUPPORTS_WORD_FILTER			// Minor bad words asterisked, inappropriate words make speaker look stupid.
#define SUPPORTS_CONDEBUG_ALWAYS		// Always create a console log
#define SUPPORTS_IP_ADDRESS_TO_LOG		// pq_logbinds writes ip address to file
#define SUPPORTS_RCON_ATTEMPTS_LOGGED	// rcon attempts logged to file
#define SUPPORTS_RCON_FAILURE_BLACKOUT	// 3 failed rcons results in a blackout for that ip for several minutes

// Version 1.2
#define SUPPORTS_END_OF_MATCH_STATS		// QuakeC function #5
#define SUPPORTS_MAP_ROTATION_CVAR		// Map rotation cvar overrides map rotation
#endif


//define	PARANOID			// speed sapping error checking

#define	GAMENAME	"id1"		// directory to look in by default

#include <math.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>





#define	MINIMUM_MEMORY			0x550000
#define	MINIMUM_MEMORY_LEVELPAK	(MINIMUM_MEMORY + 0x100000)

#define MAX_NUM_ARGVS	50

// up / down
#define	PITCH	0

// left / right
#define	YAW		1

// fall over
#define	ROLL	2


#define	MAX_QPATH		64			// max length of a quake game pathname
#define	MAX_OSPATH		128			// max length of a filesystem pathname

#define	ON_EPSILON		0.1			// point on plane side epsilon

#define	MAX_MSGLEN		8000		// max length of a reliable message
#define	MAX_DATAGRAM	1024		// max length of unreliable message

//
// per-level limits
//
#define	MAX_EDICTS		600			// FIXME: ouch! ouch! ouch!
#define	MAX_LIGHTSTYLES	64
#define	MAX_MODELS		256			// these are sent over the net as bytes
#define	MAX_SOUNDS		256			// so they cannot be blindly increased

#define	SAVEGAME_COMMENT_LENGTH	39

#define	MAX_STYLESTRING	64

//
// stats are integers communicated to the client by the server
//
#define	MAX_CL_STATS		32
#define	STAT_HEALTH			0
#define	STAT_FRAGS			1
#define	STAT_WEAPON			2
#define	STAT_AMMO			3
#define	STAT_ARMOR			4
#define	STAT_WEAPONFRAME	5
#define	STAT_SHELLS			6
#define	STAT_NAILS			7
#define	STAT_ROCKETS		8
#define	STAT_CELLS			9
#define	STAT_ACTIVEWEAPON	10
#define	STAT_TOTALSECRETS	11
#define	STAT_TOTALMONSTERS	12
#define	STAT_SECRETS		13		// bumped on client side by svc_foundsecret
#define	STAT_MONSTERS		14		// bumped by svc_killedmonster

// stock defines

#define	IT_SHOTGUN				1
#define	IT_SUPER_SHOTGUN		2
#define	IT_NAILGUN				4
#define	IT_SUPER_NAILGUN		8
#define	IT_GRENADE_LAUNCHER		16
#define	IT_ROCKET_LAUNCHER		32
#define	IT_LIGHTNING			64
#define IT_SUPER_LIGHTNING      128
#define IT_SHELLS               256
#define IT_NAILS                512
#define IT_ROCKETS              1024
#define IT_CELLS                2048
#define IT_AXE                  4096
#define IT_ARMOR1               8192
#define IT_ARMOR2               16384
#define IT_ARMOR3               32768
#define IT_SUPERHEALTH          65536
#define IT_KEY1                 131072
#define IT_KEY2                 262144
#define	IT_INVISIBILITY			524288
#define	IT_INVULNERABILITY		1048576
#define	IT_SUIT					2097152
#define	IT_QUAD					4194304
#define IT_SIGIL1               (1<<28)
#define IT_SIGIL2               (1<<29)
#define IT_SIGIL3               (1<<30)
#define IT_SIGIL4               (1<<31)

//===========================================
//rogue changed and added defines

#define RIT_SHELLS              128
#define RIT_NAILS               256
#define RIT_ROCKETS             512
#define RIT_CELLS               1024
#define RIT_AXE                 2048
#define RIT_LAVA_NAILGUN        4096
#define RIT_LAVA_SUPER_NAILGUN  8192
#define RIT_MULTI_GRENADE       16384
#define RIT_MULTI_ROCKET        32768
#define RIT_PLASMA_GUN          65536
#define RIT_ARMOR1              8388608
#define RIT_ARMOR2              16777216
#define RIT_ARMOR3              33554432
#define RIT_LAVA_NAILS          67108864
#define RIT_PLASMA_AMMO         134217728
#define RIT_MULTI_ROCKETS       268435456
#define RIT_SHIELD              536870912
#define RIT_ANTIGRAV            1073741824
#define RIT_SUPERHEALTH         2147483648

//MED 01/04/97 added hipnotic defines
//===========================================
//hipnotic added defines
#define HIT_PROXIMITY_GUN_BIT 16
#define HIT_MJOLNIR_BIT       7
#define HIT_LASER_CANNON_BIT  23
#define HIT_PROXIMITY_GUN   (1<<HIT_PROXIMITY_GUN_BIT)
#define HIT_MJOLNIR         (1<<HIT_MJOLNIR_BIT)
#define HIT_LASER_CANNON    (1<<HIT_LASER_CANNON_BIT)
#define HIT_WETSUIT         (1<<(23+2))
#define HIT_EMPATHY_SHIELDS (1<<(23+3))

//===========================================

#define	MAX_SCOREBOARD		16
#define	MAX_SCOREBOARDNAME	32

#define	SOUND_CHANNELS		8

// This makes anyone on id's net privileged
// Use for multiplayer testing only - VERY dangerous!!!
// #define IDGODS

#include "common.h"
#include "bspfile.h"
#include "sys.h"
#include "zone.h"
#include "mathlib.h"

typedef struct
{
	vec3_t	origin;
	vec3_t	angles;
	int		modelindex;
	int		frame;
	int		colormap;
	int		skin;
	int		effects;
} entity_state_t;

#include "cvar.h"
#include "net.h"
#include "security.h"	// JPG 3.20
#include "protocol.h"
#include "cmd.h"
#include "render.h"
//#include "client.h"
#include "progs.h"
#include "server.h"


#include "model.h"
#include "world.h"


#include "crc.h"




#include "location.h"	// JPG - for %l formatting speficier
#include "iplog.h"		// JPG 1.05 - ip address logging

//=============================================================================

// the host system specifies the base of the directory tree, the
// command line parms passed to the program, and the amount of memory
// available for the program to use

typedef struct
{
	char	*basedir;
	char	*cachedir;		// for development over ISDN lines
	int		argc;
	char	**argv;
	void	*membase;
	int		memsize;
} quakeparms_t;


//=============================================================================



extern qboolean noclip_anglehack;


//
// host
//
extern	quakeparms_t host_parms;

extern	cvar_t		sys_ticrate;
extern	cvar_t		sys_nostdout;
extern	cvar_t		developer;

extern	qboolean	host_initialized;		// true if into command execution
extern	double		host_frametime;
extern	byte		*host_basepal;
extern	byte		*host_colormap;
extern	int			host_framecount;	// incremented every frame, never reset
extern	double		realtime;			// not bounded in any way, changed at
										// start of every frame, never reset
//extern double last_angle_time; // JPG - need this for smooth chasecam

// JPG 3.20
#ifdef WIN32
extern char	*argv[MAX_NUM_ARGVS];
#else
extern char	**argv;
#endif

void Host_ClearMemory (void);
void Host_ServerFrame (void);
void Host_InitCommands (void);
void Host_Init (quakeparms_t *parms);
void Host_Shutdown(void);
void Host_Error (char *error, ...);
void Host_EndGame (char *message, ...);
void Host_Frame (float time);
void Host_Quit_f (void);
void Host_ClientCommands (char *fmt, ...);
void Host_ShutdownServer (qboolean crash);

extern int			current_skill;		// skill level for currently loaded level (in case
										//  the user changes the cvar while the level is
										//  running, this reflects the level actually in use)

extern qboolean		isDedicated;

extern int			minimum_memory;


extern char dequake[256];	// JPG 1.05 - dedicated console translation
extern cvar_t pq_dequake;	// JPG 1.05 - dedicated console translation



