//http://www.gamers.org/dEngine/quake/spec/quake-spec34/qkspec_1.htm
#define MAX_MAP_LEAFS (1<<16)
typedef struct
{
	unsigned int offset;
	unsigned int size;
} bsp_entry_t;
enum
{
	LUMP_ENTITIES,
	LUMP_PLANES,
	LUMP_MIPTEX,
	LUMP_VERTICIES,
	LUMP_VIS,
	LUMP_NODES,
	LUMP_TEXINFO,
	LUMP_FACES,
	LUMP_LIGHTMAP,
	LUMP_CLIPNODES,
	LUMP_LEAVES,
	LUMP_FACEREFS,
	LUMP_EDGES,
	LUMP_EDGEREFS,
	LUMP_MODELS,
	LUMP_COUNT
};
typedef struct
{
	unsigned int	version;
	bsp_entry_t		lumps[LUMP_COUNT];
} bsp_header_t;

typedef struct
{
	float			mins[3];
	float			maxs[3];
	float			origin[3];
	unsigned int	node[4];
	unsigned int	visleafs; //leafs-1, only useful for world model
	unsigned int	face_first;
	unsigned int	face_count;
} bsp_model_quake_t;

typedef struct
{
	float			mins[3];
	float			maxs[3];
	float			origin[3];
	unsigned int	node[8];
	unsigned int	visleafs; //leafs-1, only useful for world model
	unsigned int	face_first;
	unsigned int	face_count;
} bsp_model_hexen2_t;

typedef struct
{
	unsigned short	verts[2];
} bsp29_edge_t;
typedef struct
{
	unsigned int	verts[2];
} bsp2_edge_t;

#define TEX_SPECIAL (1u<<0)
typedef struct
{
	struct
	{
		float		normal[3];
		float		dist;
	} tplanes[2];
	unsigned int	texture_id;
	unsigned int	flags;
} bsp_texinfo_t;


typedef struct  
{
	unsigned short	plane_id;
	unsigned short	side;		
	unsigned int	edgeref_first;
	unsigned short	edgeref_count;
	unsigned short	texinfo_id;
	unsigned char	lightstyle[4];
	unsigned int	lightofs;
} bsp29_face_t;
typedef struct  
{
	unsigned int	plane_id;
	unsigned int	side;		
	unsigned int	edgeref_first;
	unsigned int	edgeref_count;
	unsigned int	texinfo_id;
	unsigned char	lightstyle[4];
	unsigned int	lightofs;
} bsp2_face_t;

typedef struct
{
	unsigned int	numtex;
	unsigned int	offset[1];
} bsp_miplump_t;
typedef struct
{
	char			name[16];
	unsigned int	width;
	unsigned int	height;
	unsigned int	offset[4];
} miptex_t;

typedef struct
{
	unsigned int	plane_id;
	signed short	children[2];	//front, back
	signed short	mins[3];
	signed short	maxs[3];
	unsigned short	face_first;
	unsigned short	face_count;
} bsp29_node_t;
typedef struct
{
	unsigned int	plane_id;
	signed int		children[2];	//front, back
	float			mins[3];
	float			maxs[3];
	unsigned int	face_first;
	unsigned int	face_count;
} bsp2_node_t;

typedef struct
{
	signed int		type;
	unsigned int	vis_offset;
	signed short	mins[3];
	signed short	maxs[3];
	unsigned short	faceref_first;
	unsigned short	faceref_count;
	unsigned char	sounds[4];
} bsp29_leaf_t;
typedef struct
{
	signed int		type;
	unsigned int	vis_offset;
	float			mins[3];
	float			maxs[3];
	unsigned int	faceref_first;
	unsigned int	faceref_count;
	unsigned char	sounds[4];
} bsp2_leaf_t;

typedef struct
{
	float			normal[3];
	float			dist;
	unsigned int	type;
} bsp_plane_t;

typedef struct
{
	float			pos[3];
} bsp_vertex_t;

typedef struct
{
	unsigned int	planenum;	
	short			children[2];	//negative are contents
} clipnode_t;
