#ifndef _COMMON_H_
#define _COMMON_H_

#if !defined(USEVK) && !defined(USEGL)
#if 0
	#define USEVK
#else
	#define USEGL
//	#define USEBINDLESS
#endif
#endif


#define _CRT_NONSTDC_NO_WARNINGS	//fuck off, microsoft. I'll use standards if I want to.
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>

#include "maths.h"

#if defined(_M_X86) || defined(__i386__) || defined(_M_X64) || defined(__amd64__)	//x86/amd64 chips support misaligned data efficiently enough that we don't need to care about it if it allows other optimisations.
#define MISALIGNED_OKAY 1
#endif

#ifdef _MSC_VER
//#pragma warning(4: 4018)	//signed/unsigned mismatch
#pragma warning(4: 4244)
#endif


#ifdef _MSC_VER
typedef intptr_t ssize_t;
#endif

#define countof(x) (sizeof(x)/sizeof(x[0]))

typedef unsigned char byte;

//special class to cope with wrapping msec values
class msec_c
{
public:
	unsigned int val;

	inline bool operator < (msec_c &ms2)
	{
		return val+1000 < ms2.val+1000 || val-1000 < ms2.val-1000;
	}
	inline bool operator <= (msec_c &ms2)
	{
		return val+1000 <= ms2.val+1000 || val-1000 <= ms2.val-1000;
	}
	inline bool operator > (msec_c &ms2)
	{
		return val+1000 > ms2.val+1000 || val-1000 > ms2.val-1000;
	}
	inline bool operator >= (msec_c &ms2)
	{
		return val+1000 >= ms2.val+1000 || val-1000 >= ms2.val-1000;
	}
	inline unsigned int operator - (msec_c &ms2)
	{
		return val - ms2.val;
	}
	inline float operator / (float frac)
	{
		return val/frac;
	}
	inline float operator * (float frac)
	{
		return val*frac;
	}
	inline int operator / (int frac)
	{
		return val/frac;
	}
	inline int operator * (int frac)
	{
		return val*frac;
	}
	inline unsigned int operator - (unsigned int time)
	{
		return val - time;
	}
	inline msec_c operator + (msec_c &ms2)
	{
		return msec_c(val + ms2.val);
	}
	inline msec_c operator + (unsigned int time)
	{
		return msec_c(val + time);
	}
	inline void operator += (unsigned int time)
	{
		val += time;
	}
	msec_c(unsigned int time)
	{
		val = time;
	}
	msec_c()
	{
	}
};


#define strlcpy strncpyz
#define strlcat strncatz
inline void strlcpy(char *out, const char *in, size_t maxlen)
{
	if (!maxlen)
		return;
	strncpy(out, in, maxlen-1);
	out[maxlen-1] = '\0';
}
void strlcpy(byte *out, const byte *in, size_t maxlen);
void strlcpy(byte *out, const char *in, size_t maxlen);
void strlcpy(char *out, const byte *in, size_t maxlen);

inline void strlcat(char *out, const char *in, size_t maxlen)
{
	maxlen -= strlen(out);
	out += strlen(out);
	strlcpy(out, in, maxlen);
}

int stricmp(const byte *s1, const byte *s2);
inline int stricmp(const byte *s1, const char *s2)
{
	return stricmp(s1, (byte*)s2);
}

inline size_t strlen(const byte *s1) {return strlen((const char *)s1);}

inline byte *strcpy(byte *s1, const byte *s2) {return (byte*)strcpy((char*)s1, (const char*)s2);}
inline byte *strcpy(byte *s1, const char *s2) {return (byte*)strcpy((char*)s1, (const char*)s2);}
inline char *strcpy(char *s1, const byte *s2) {return (char*)strcpy((char*)s1, (const char*)s2);}

inline int atoi(const unsigned char *s1) {return atoi((const char*)s1);}
inline float atof(const unsigned char *s1) {return (float)atof((const char*)s1);}

char *Str_Parse(char *instr, char *result, int resultlen);
void Str_MakeNiceName(char *outb, char *inb, int outlen);

#ifdef _WIN32
#define snprintf _snprintf
#define vsnprintf _vsnprintf
#define strlwr STRLWR
#endif

inline void strtolwr(char *in)
{
	while(*in)
	{
		if (*in >= 'A' && *in <= 'Z')
			*in = *in - 'A' + 'a';
	}
}



//endian
#ifdef BIGENDIAN
inline int LittleInt(int i)
{
	int i1, i2, i3, i4;
	i1 = (i>>0)&0xff;
	i2 = (i>>8)&0xff;
	i3 = (i>>16)&0xff;
	i4 = (i>>24)&0xff;
	return (((i>>0)&0xff)<<24) | (((i>>8)&0xff)<<16) | (((i>>16)&0xff)<<8) | (((i>>24)&0xff)<<0);
}
inline float LittleFloat(float in)
{
	union {
		int i;
		float f;
	} u;

	u.f = in;
	u.i = LittleInt(u.i);

	return u.f;
}
#else
inline int LittleInt(int i)
{
	return i;
}
inline float LittleFloat(float i)
{
	return i;
}
#endif



class inputsink
{
public:
	virtual void KeyEvent		(int down, int scancode) = NULL;
	virtual void TextInput		(char *text) = NULL;

	virtual void ButtonEvent	(int down, int button) = NULL;
	virtual void MouseDelta		(int x, int y) = NULL;
	virtual void MouseAbsolute(int x, int y) = NULL;
};

class vid_t {
public:
	inputsink *input;
	int width, height;	//real
	int bpp;
	int mousex, mousey, mousebuttons;
	int mode;
	unsigned int keys;
protected:
	bool isactiveapp;
	bool isopengl;

	vid_t(void) :input(0)
	{
	}

public:
	virtual bool GetDroppedFileName(char *buf, size_t bufsize) = 0;
	virtual void SetTitle(const char *newtitle) = 0;
	virtual bool Startup(const char *title) = 0;
	virtual void Shutdown() = 0;
	virtual bool PreFrame(bool cursorgrabs) = 0;
	virtual bool PostFrame() = 0;
	virtual double GetTime() = 0;
};

void Sys_Error(const char *s, ...);
msec_c Sys_Milliseconds(void);



typedef enum {
	PRINT_DEBUG,
	PRINT_INFO,
	PRINT_NOTIFCATION,
	PRINT_WARNING,
	PRINT_ERROR
} printtype_e;
void Com_Printf(printtype_e ptype, const char *fmt, ...);


#define premainfunc(func) class premainc_##func { public: premainc_##func(int i) {func();} };premainc_##func premaini_##func(0);
#define premain(unique) class premain_##unique { public: premain_##unique(int i)  
#define endpremain(unique)  };premain_##unique unique(0);



class genclient
{
public:
	virtual bool Run(vid_t *vid) = 0;
};

genclient *CL_Init(const char *server, float time);
genclient *MapView_Init(const char *map, vec3 origin, vec3 angles);

#endif	//_COMMON_H_
