#ifndef __FILESYSTEM_H__
#define __FILESYSTEM_H__

//'debug' filenames are human-readable text that probably mean nothing to the os (archives like directories)

#define MAX_RPATH	256

class file
{
public:
	virtual ~file(void) {};
	virtual void seek(size_t offset) {};
	virtual void seektoend(void) {};
	virtual size_t tell(void) {return 0;};
	virtual size_t read(void*buffer, size_t size) {return 0;};
	virtual size_t write(const void*buffer, size_t size) {return 0;};
};

class file_c : public file
{
protected:
	void *data;
	size_t length;
	size_t base;
	char name[MAX_RPATH];

public:
	virtual ~file_c(void);
	virtual void seek(size_t offset);
	virtual void seektoend(void);
	virtual size_t tell(void);
	virtual size_t read(void*buffer, size_t size);
	virtual size_t write(const void*buffer, size_t size);

	static file_c *Create(const char *filename, const char *accessmode);
};

class filesys
{
public:
	virtual ~filesys() {}
	virtual int SizeOfFile(const char *name) = 0;
	virtual unsigned char *ReadFile(const char *name, unsigned int *retlen) = 0;	//returns a malloced buffer.
	virtual file *OpenRFile(const char *name, char *debugname, int debugnamelen) = 0;	//returns a handle to a file.
	virtual file *OpenWFile(const char *name, char *debugname, int debugnamelen) = 0;	//returns a handle to a file.
	virtual void EnumerateFiles(const char *filematch, void (*callback) (filesys *fs, const char *filename, void *userdata), void *userdata) = 0;
	filesys *mNext;	//handy for all sorts of things.
};

class fsdrv
{
public:
	fsdrv(const char *extension, const char *name, filesys *(*openpath) (const char *path));	//for special filesystems (stdio/http)
	fsdrv(const char *extension, const char *name, filesys *(*openpath) (file *basef, char *debugfname));	//file_c is the file to base the filesystem on.
	const char *extension;
	const char *name;
	fsdrv *mNext;
	filesys *(*OpenPath) (const char *path);
	filesys *(*OpenFile) (file *path, char *debugfname);
};

int wildcmp(const char *wild, const char *string);
void FS_InitFileSystem(const char *basedir, const char *basegame, const char *subgame);
void FS_AddGameDir(const char *basepath);
void FS_ShutdownAllFileSystems();
void FS_EnumerateFiles(const char *filematch, void (*callback) (filesys *fs, const char *filename, void *userdata), void *userdata);
int FS_SizeOfFile(const char *filename);
file *FS_OpenRFile(const char *filename);
file *FS_OpenWFile(const char *filename);
unsigned char *FS_ReadFile(const char *filename, unsigned int *size);
#endif //__FILESYSTEM_H__
