#include "common.h"
#ifndef USEVK
#include "glrenderer.h"
//#include "../cvar.h"
#include "filesystem.h"

//#include "../client/client.h"

#include <SDL.h>
#include <SDL_syswm.h>

//the definitions of the gl function pointers
#define GLExtFunc(e,r,n,l) GLFunc(r,n,l)
#define GLFunc(r,n,l) gltype_##n p##n
	GLFuncs;
#undef GLFunc
#undef GLExtFunc

void APIENTRY glDrawRangeElementsWrapper (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices)
{
	pglDrawElements(mode, count, type, indices);
}

void GL_InitFunctionPointers(void)
{
	const GLubyte *vendor;
	const GLubyte *renderer;
	const GLubyte *version;
	const GLubyte *extensions;

	const GLubyte *end;
	char extname[1024];
	uint32_t extnum;

	bool arbshader				= false;
	bool arbvshader				= false;
	bool arbfshader				= false;
	bool arbshaderlang100		= false;
	bool arbvbo					= false;
	bool arbcombine				= false;
	bool arbmultitexture		= false;
	bool extrangeelements		= false;
	bool bindlesstexture		= false;
	bool base_instance			= false;
	bool multi_draw_indirect	= false;
	bool buffer_storage			= false;
	bool instanced_arrays		= false;
	bool texture_storage		= false;
	bool uniform_buffer_object	= false;
	bool sync					= false;
	GLint numexts;


	pglGetError = (gltype_glGetError)SDL_GL_GetProcAddress("glGetError");

	pglGetString = (gltype_glGetString)SDL_GL_GetProcAddress("glGetString");
	pglGetStringi = (gltype_glGetStringi)SDL_GL_GetProcAddress("glGetStringi");
	pglGetIntegerv = (gltype_glGetIntegerv)SDL_GL_GetProcAddress("glGetIntegerv");
	vendor = pglGetString(GL_VENDOR);
	renderer = pglGetString(GL_RENDERER);
	version = pglGetString(GL_VERSION);
	extensions = pglGetString(GL_EXTENSIONS);
	Com_Printf(PRINT_INFO, "vendor %s\nrenderer %s\nversion %s\n", vendor, renderer, version);

	float glver = atof(version);

	numexts = 0;
	if (pglGetStringi)
		pglGetIntegerv(GL_NUM_EXTENSIONS, &numexts);

	end = pglGetStringi?NULL:extensions;
	extnum = 0;
	while (extnum < numexts || (end && *end))
	{
		if (numexts)
		{
			strcpy(extname, pglGetStringi(GL_EXTENSIONS, extnum++));
		}
		else
		{
			while (*end > ' ')
				end++;

			strncpy(extname, (char*)extensions, end - extensions);
			extname[end-extensions] = 0;

			while (*end == ' ' || *end == '\t')
				end++;
			extensions = end;
		}

		Com_Printf(PRINT_DEBUG, "extension \"%s\"\n", extname);

//		if (!strcmp(extname, "GL_ARB_shader_objects"))
			arbshader = true;
//		if (!strcmp(extname, "GL_ARB_vertex_shader"))
			arbvshader = true;
//		if (!strcmp(extname, "GL_ARB_fragment_shader"))
			arbfshader = true;
//		if (!strcmp(extname, "GL_ARB_shading_language_100"))
			arbshaderlang100 = true;
//		if (!strcmp(extname, "GL_ARB_vertex_buffer_object"))
			arbvbo = true;

		if (!strcmp(extname, "GL_ARB_multitexture"))
			arbmultitexture = true;
		if (!strcmp(extname, "GL_ARB_texture_env_combine") || !strcmp(extname, "GL_EXT_texture_env_combine"))
			arbcombine = true;

		if (!strcmp(extname, "GL_EXT_draw_range_elements"))
			extrangeelements = true;

		if (!strcmp(extname, "GL_ARB_bindless_texture"))
			bindlesstexture = true;

		if (!strcmp(extname, "GL_ARB_uniform_buffer_object"))
			uniform_buffer_object = true;
		if (!strcmp(extname, "GL_ARB_instanced_arrays"))
			instanced_arrays = true;
		if (!strcmp(extname, "GL_ARB_base_instance"))
			base_instance = true;
		if (!strcmp(extname, "GL_ARB_multi_draw_indirect"))
			multi_draw_indirect = true;
		if (!strcmp(extname, "GL_ARB_buffer_storage"))
			buffer_storage = true;
		if (!strcmp(extname, "GL_ARB_sync"))
			sync = true;
		if (!strcmp(extname, "GL_ARB_texture_storage"))
			texture_storage = true;

		//we explicitly check for opengl 1.1, and use the non-ext form.
//		if (!strcmp(extname, "GL_EXT_texture_object"))
//			exttextureobject = true;
	}

	if (!arbvshader || !arbfshader || !arbshaderlang100)
		arbshader = false;	//don't bother with that extension if we can't get all the other (more useful) parts

	
	if (glver < 3.1)
	{
		Sys_Error("OpenGL 3.1 is required as a minimum");
	}
	if (glver < 2.0)
	{
		Sys_Error("OpenGL 1.1 is required as a minimum");
	}

//	if (!arbcombine)
//		Sys_Error("Your system does not provide the GL_ARB_texture_env_combine extension");
	if (!arbmultitexture)
		Sys_Error("Your system does not provide the GL_ARB_multitexture extension");
#ifdef USEBINDLESS
	if (!bindlesstexture)
		Sys_Error("Your system does not provide the GL_ARB_bindless_texture extension");
#endif
	if (!instanced_arrays)	//so we can use the baseinstance of draws to get the desired drawid (without having to modify a uniform between each draw call)
		Sys_Error("Your system does not provide the GL_ARB_instanced_arrays extension");
	if (!base_instance)	//we need the base index to index into our ubo
		Sys_Error("Your system does not provide the GL_ARB_base_instance extension");
	if (!multi_draw_indirect)	//could work around it with regular draws, but meh.
		Sys_Error("Your system does not provide the GL_ARB_multi_draw_indirect extension");

#define GLFunc(r,n,l) p##n = (gltype_##n) SDL_GL_GetProcAddress(#n); if (!p##n) Sys_Error("Couldn't obtain gl function " #n)
#define GLExtFunc(e,r,n,l) if (e) {GLFunc(r,n,l);} else p##n = NULL
	GLFuncs;
#undef GLFunc


	//some functions have arb forms, some do not.
	if (!pglVertexAttribDivisor)
		pglVertexAttribDivisor = pglVertexAttribDivisorARB;
	pglVertexAttribDivisorARB = NULL;


	if (!extrangeelements)
		pglDrawRangeElementsEXT = glDrawRangeElementsWrapper;
	else
		pglDrawRangeElementsEXT = NULL;	//cause an error when its used
}


class sdlvid_t : public vid_t
{
	bool close;
	SDL_Window *window;
	SDL_GLContext context;
	char *droppedfile;

	virtual double GetTime(void)
	{
		static bool first = true;
		static Uint64 start;
		if (first)
		{
			start = SDL_GetPerformanceCounter();
			first = false;
		}
		Uint64 now = SDL_GetPerformanceCounter();

		return (double)(now - start) / SDL_GetPerformanceFrequency();
	}

//	HDC dc;

	virtual void SetTitle(const char *newtitle)
	{
		SDL_SetWindowTitle(window, newtitle);
	}

	virtual bool Startup(const char *windowtitle)
	{
		int flags = SDL_WINDOW_OPENGL | SDL_WINDOW_SHOWN | SDL_WINDOW_RESIZABLE | SDL_WINDOW_MAXIMIZED;
		close = true;
		if (SDL_VideoInit(NULL))
			return false;

		keys = 0;
		mode = 0;
		droppedfile = NULL;

		SDL_GL_SetAttribute(SDL_GL_RED_SIZE,		5);
		SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE,		5);
		SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE,		5);
		SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE,		16);
		SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER,	1);
//		SDL_GL_SetAttribute(SDL_GL_STENCIL_SIZE,	8);

//		SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION,	3);
//		SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION,	3);
//		SDL_GL_SetAttribute(SDL_GL_CONTEXT_PROFILE_MASK,	SDL_GL_CONTEXT_PROFILE_CORE);
//		SDL_GL_SetAttribute(SDL_GL_CONTEXT_FLAGS,			SDL_GL_CONTEXT_FORWARD_COMPATIBLE_FLAG);

		window = SDL_CreateWindow(windowtitle, SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, 640, 480, flags);
		if (!window)
		{
			SDL_VideoQuit();
			return false;
		}

		context = SDL_GL_CreateContext(window);
		if (!context)
		{
			SDL_DestroyWindow(window);
			SDL_VideoQuit();
			return false;
		}

		SDL_GL_SetSwapInterval(0);
		SDL_GL_GetDrawableSize(window, &width, &height);

		SDL_EventState(SDL_DROPFILE, SDL_ENABLE);

		isactiveapp = true;
		isopengl = true;

		GL_InitFunctionPointers();

		pglClear(GL_COLOR_BUFFER_BIT);
		pglEnable(GL_DEPTH_TEST);
		pglEnable(GL_CULL_FACE);

/*		SDL_SysWMinfo wi;
		SDL_VERSION(&wi.version); 
		SDL_GetWindowWMInfo(window, &wi);
		dc = GetDC(wi.info.win.window);
*/
		close = !PostFrame();

	//	SDL_SetGamma(2, 2, 2);

		if (pglGetError())
			Com_Printf(PRINT_ERROR, "OpenGL Error after VID_Init\n");

		return true;
	}

	virtual void Shutdown(void)
	{
	//	SDL_SetGamma(1, 1, 1);
		SDL_DestroyWindow(window);
		SDL_VideoQuit();
	}

	void WindowEvents(void)
	{
		SDL_Event ev;
		while(SDL_PollEvent(&ev))
		{
			switch(ev.type)
			{
			case SDL_WINDOWEVENT:
				switch(ev.window.event)
				{
				default:
					break;
				case SDL_WINDOWEVENT_SIZE_CHANGED:
					#if SDL_PATCHLEVEL >= 1
						SDL_GL_GetDrawableSize(window, &width, &height);	//get the proper physical size.
					#else
						SDL_GetWindowSize(window, &width, &height);
					#endif
					break;
				case SDL_WINDOWEVENT_FOCUS_GAINED:
					isactiveapp = true;
					break;
				case SDL_WINDOWEVENT_FOCUS_LOST:
					isactiveapp = false;
					break;
				case SDL_WINDOWEVENT_CLOSE:
					close = true;
					break;
				}
				break;
			case SDL_KEYDOWN:
				if (ev.key.keysym.scancode >= SDL_SCANCODE_F1 && ev.key.keysym.scancode <= SDL_SCANCODE_F12)
					mode = ev.key.keysym.scancode-SDL_SCANCODE_F1;

				if (this->input)
					this->input->KeyEvent(true, ev.key.keysym.sym);
				break;
			case SDL_KEYUP:
				if (this->input)
					this->input->KeyEvent(false, ev.key.keysym.sym);
				break;
			case SDL_MOUSEMOTION:
				if (this->input)
					this->input->MouseDelta(ev.motion.xrel, ev.motion.yrel);
				else
				{
					mousex += ev.motion.xrel;
					mousey += ev.motion.yrel;
				}
				break;
			case SDL_MOUSEBUTTONDOWN:
				if (this->input)
					this->input->ButtonEvent(true, ev.button.button);
				mousebuttons |= 1<<(ev.button.button-1);
				break;
			case SDL_MOUSEBUTTONUP:
				if (this->input)
					this->input->ButtonEvent(false, ev.button.button);
				mousebuttons &= ~(1<<(ev.button.button-1));
				break;

			case SDL_DROPFILE:
				if (droppedfile)
					SDL_free(droppedfile);
				droppedfile = ev.drop.file;
                break;
			}
		}
	}
	bool GetDroppedFileName(char *buf, size_t bufsize)
	{
		if (droppedfile)
		{
			strncpy(buf, droppedfile, bufsize-1);
			buf[bufsize-1] = 0;

			SDL_free(droppedfile);
			droppedfile = NULL;
			return true;
		}
		return false;
	}
//#pragma comment(lib, "opengl32.lib")
	bool PreFrame(bool cursorgrab)
	{
		WindowEvents();

		if (1)
		{
			pglClearColor (0,0.1f,0,0);	//clear to black so that it looks a little nicer on start.
			pglClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		}
		else
			pglClear(GL_DEPTH_BUFFER_BIT);

		if (!isactiveapp)
			cursorgrab = false;
		SDL_SetWindowGrab(window, cursorgrab?SDL_TRUE:SDL_FALSE);
		SDL_SetRelativeMouseMode(cursorgrab?SDL_TRUE:SDL_FALSE);
		return false;
	}
	bool PostFrame(void)
	{
//		if (dc)	//this is worth about 200 fps, even though there is only one layer anyway.
//			wglSwapLayerBuffers(dc, WGL_SWAP_MAIN_PLANE);
//		else
			SDL_GL_SwapWindow(window);
		
		if (close)
		{
			close = false;
			return true;
		}
		return false;
	}
void ML_NewTranslation(matrix4x4 ret, vec x, vec y, vec z);

/*
void GL_VID_DrawScene(rstate_t *rs)
{
	rentity_t *currentrent;
	matrix4x4 vm;
	unsigned int i;

	rs->frustum.FromMatricies(rs->viewmatrix, rs->projectionmatrix);

	pglViewport(rs->rectx, rs->recty, rs->rectwidth, rs->rectheight);

	pglShadeModel (GL_FLAT);

	pglDisable(GL_DEPTH_TEST);
	pglDisable(GL_ALPHA_TEST);
	pglEnable(GL_CULL_FACE);
	pglEnable(GL_DEPTH_TEST);


	pglMatrixMode(GL_PROJECTION);
	pglLoadMatrixf(rs->projectionmatrix.data);

	pglMatrixMode(GL_MODELVIEW);

	pglColor4f(1, 1, 1, 1);

	pglEnable(GL_VERTEX_ARRAY);

	for (i = 0; i < rs->numrents; i++)
	{
		if (!rs->rents[i].model)
			continue;

		currentrent = &rs->rents[i];
		vm = rs->viewmatrix*currentrent->modelmatrix;
		pglLoadMatrixf(vm.data);
		rs->rents[i].model->DrawEntity(currentrent, rs);
	}
}*/



};
vid_t *SDL_Vid_Create(void)
{
	vid_t *vid = new sdlvid_t();
	return vid;
}
#endif