#ifndef __GLRENDERER_H__
#define __GLRENDERER_H__

#include "renderer.h"
#ifdef _WIN32
#include <windows.h>	//this sucks
#endif


#include <GL/gl.h>
#include "glext.h"

#define GLcharARB char

//#define USEBINDLESS


#ifndef GL_ARB_multitexture
//#error "gl or glext headers are not sufficiently up to date"
#endif



struct indirectdrawcmd_s
{
	GLuint	count;
	GLuint	instanceCount;
	GLuint	firstIndex;
	GLuint	baseVertex;
	GLuint	baseInstance;
};




//the list of all gl functions we can use
//note that the macros take the gl name, and add a p on the front
#define GLFuncs \
	GLFunc(void, glViewport,		(GLint x, GLint y, GLsizei width, GLsizei height));					\
	GLFunc(void, glClear,			(GLenum buffer));													\
																										\
	/*GLFunc(void, glClearStencil,	(GLint val));														\
	GLFunc(void, glCullFace,		(GLenum face));														\
	GLFunc(void, glStencilFunc,		(GLenum op, GLint val, GLint mask));								\
	GLFunc(void, glStencilOpSeparateATI,(GLenum face, GLenum fail, GLenum zfail, GLenum zpass));		\
	GLFunc(void, glColorMask,		(GLboolean red, GLboolean blue, GLboolean gree, GLboolean alpha));	\
	GLFunc(void, glDepthMask,		(GLboolean param));													\
	GLFunc(void, glDepthFunc,		(GLenum func));	*/													\
																										\
	GLExtFunc(arbshader, GLuint,	glCreateShader,	(GLenum shaderType));								\
	GLExtFunc(arbshader, void, glShaderSource,			(GLhandleARB shaderObj, GLsizei count, const GLcharARB* *string, const GLint *length));	\
	GLExtFunc(arbshader, void, glCompileShader,		(GLhandleARB shaderObj));									\
	GLExtFunc(arbshader, void, glGetProgramiv, (GLhandleARB obj, GLenum pname, GLint *params));			\
	GLExtFunc(arbshader, void, glGetShaderiv, (GLhandleARB obj, GLenum pname, GLint *params));			\
	GLExtFunc(arbshader, GLhandleARB, glCreateProgram,	(void));											\
	GLExtFunc(arbshader, void, glAttachShader,			(GLhandleARB containerObj, GLhandleARB obj));				\
	GLExtFunc(arbshader, void, glLinkProgram,			(GLhandleARB programObj));									\
	GLExtFunc(arbshader, void, glUseProgram,		(GLhandleARB programObj));									\
	GLExtFunc(arbshader, void, glGetProgramInfoLog,			(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog));	\
	GLExtFunc(arbshader, void, glGetShaderInfoLog,			(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog));	\
	GLExtFunc(arbshader, GLint,glGetUniformLocation,	(GLhandleARB programObj, const GLcharARB *name));			\
	GLExtFunc(arbshader, void, glUniform1i,			(GLint location, GLint v0));								\
	GLExtFunc(arbshader, void, glUniform3f,			(GLint location, GLfloat v0, GLfloat v1, GLfloat v2));		\
																													\
	GLExtFunc(glver>=3.0, void, glBindVertexArray,			(GLuint array));		\
	GLExtFunc(glver>=3.0, void, glDeleteVertexArrays,			(GLsizei n, const GLuint *arrays));		\
	GLExtFunc(glver>=3.0, void, glGenVertexArrays,			(GLsizei n, GLuint *arrays));		\
	GLExtFunc(arbshader, void, glVertexAttribPointer, (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer));	\
	GLExtFunc(arbshader, void, glEnableVertexAttribArray, (GLuint index));	\
	GLExtFunc(glver>=3.3, void, glVertexAttribDivisor, (GLuint index,  GLuint divisor));	\
	GLExtFunc(instanced_arrays, void, glVertexAttribDivisorARB, (GLuint index,  GLuint divisor));	\
	GLExtFunc(arbshader, void, glBindAttribLocation, (GLuint program, GLuint index, const GLchar *name));	\
	GLExtFunc(arbshader, GLint, glGetAttribLocation, (GLuint program, const GLchar *name));	\
		\
	GLFunc(void, glTexSubImage3D, (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels));	\
	GLExtFunc(texture_storage, void, glTexStorage3D, (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth));	\
	GLExtFunc(bindlesstexture, GLuint64, glGetTextureHandleARB, (GLuint texture));	\
	GLExtFunc(bindlesstexture, void, glMakeTextureHandleResidentARB, (GLuint64 handle));	\
	GLExtFunc(glver>=3.0, void, glVertexAttribIPointer, (GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer));	\
	GLExtFunc(glver>=3.0, void*, glMapBufferRange,			(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access));		\
	GLExtFunc(glver>=3.0, void, glFlushMappedBufferRange,			(GLenum target, GLintptr offset, GLsizeiptr length));		\
	GLExtFunc(glver>=3.1||uniform_buffer_object, GLuint, glGetUniformBlockIndex,			(GLuint program, const GLchar *uniformBlockName));		\
	GLExtFunc(glver>=3.1||uniform_buffer_object, void, glUniformBlockBinding,			(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding));		\
	GLExtFunc(glver>=3.0, void, glBindBufferBase,			(GLenum target, GLuint index, GLuint buffer));		\
	GLExtFunc(glver>=3.0, void, glBindBufferRange,			(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size));		\
	\
	GLExtFunc(arbvbo, void, glBindBuffer,				(GLenum, GLuint));											\
	GLExtFunc(arbvbo, void, glDeleteBuffers,			(GLsizei, const GLuint *));									\
	GLExtFunc(arbvbo, void, glGenBuffers,				(GLsizei, GLuint *));										\
	GLExtFunc(arbvbo, GLboolean, glIsBuffer,			(GLuint));													\
	GLExtFunc(arbvbo, void, glBufferData,				(GLenum, GLsizei, const GLvoid *, GLenum));				\
	GLExtFunc(arbvbo, void, glBufferSubData,			(GLenum, GLint, GLsizei, const GLvoid *));			\
	GLExtFunc(arbvbo, void, glGetBufferSubData,		(GLenum, GLint, GLsizei, GLvoid *));					\
	GLExtFunc(arbvbo, GLvoid*, glMapBuffer,			(GLenum, GLenum));											\
	GLExtFunc(arbvbo, GLboolean, glUnmapBuffer,		(GLenum));													\
	GLExtFunc(arbvbo, void, glGetBufferParameteriv,	(GLenum, GLenum, GLint *));									\
	GLExtFunc(arbvbo, void, glGetBufferPointerv,		(GLenum, GLenum, GLvoid* *));								\
	GLExtFunc(buffer_storage||glver>=4.4, void, glBufferStorage,		(GLenum target, GLsizeiptr size, const void *data, GLbitfield flags));								\
	GLExtFunc(sync, GLsync, glFenceSync,			(GLenum condition, GLbitfield flags));								\
	GLExtFunc(sync, GLenum, glClientWaitSync,		(GLsync sync, GLbitfield flags, GLuint64 timeout));								\
	GLExtFunc(sync, void, glDeleteSync,				(GLsync sync));								\
																										\
	GLFunc(void, glGetIntegerv,		(GLenum name, GLint *params));										\
	GLFunc(const GLubyte*,glGetString,(GLenum name));													\
	GLExtFunc(false, const GLubyte*,glGetStringi,(GLenum name,GLuint index));									\
	GLFunc(void, glBlendFunc,		(GLenum sfactor, GLenum dfactor));									\
	GLFunc(void, glDrawElements,	(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices));	\
	GLExtFunc(extrangeelements, void, glDrawRangeElementsEXT, (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices));	\
	GLExtFunc(glver>=4.3||(base_instance&&multi_draw_indirect), void, glMultiDrawElementsIndirect, (GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride));	\
	GLFunc(void, glEnable,			(GLenum cap));														\
	GLFunc(void, glDisable,			(GLenum cap));														\
	GLFunc(void, glClearColor,		(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha));		\
	GLFunc(void, glPolygonMode,		(GLenum face, GLenum mode));										\
	GLFunc(void, glShadeModel,		(GLenum mode));														\
	GLFunc(void, glActiveTexture,	(GLenum texture));													\
	GLFunc(void, glBindTexture,		(GLenum target, GLuint texture));									\
	GLFunc(void, glGenTextures,		(GLsizei n, GLuint *textures));										\
	GLFunc(void, glDeleteTextures,	(GLsizei n, const GLuint *textures));								\
	GLFunc(void, glTexImage2D,		(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels));	\
	GLFunc(void, glTexParameteri,	(GLenum target, GLenum pname, GLint param));						\
	GLFunc(void, glTexEnvi,			(GLenum target, GLenum pname, GLint param));						\
	GLFunc(int, glGetError,			(void));										\
	GLFunc(int, glCompressedTexImage2DARB,			(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLint size, const GLvoid *pixels));										\
	GLFunc(int, glGenerateMipmap,			(GLenum target));										\

#define GLExtFunc(e,r,n,l) GLFunc(r,n,l)
#define GLFunc(r,n,l) typedef r (APIENTRY *gltype_##n) l;extern gltype_##n p##n
	GLFuncs
#undef GLFunc
#undef GLExtFunc

#endif

GLuint GL_CompileShader(const char *vertexprogram, const char *fragmentprogram);
void GL_FlushModels(void);









