#include "common.h"
#include "renderer.h"

static const char *lightstylestrings[] =
{
	"m",
	"mmnmmommommnonmmonqnmmo",
	"abcdefghijklmnopqrstuvwxyzyxwvutsrqponmlkjihgfedcba",
	"mmmmmaaaaammmmmaaaaaabcdefgabcdefg",
	"mamamamamama",
	"jklmnopqrstuvwxyzyxwvutsrqponmlkj",
	"nmonqnmomnmomomno",
	"mmmaaaabcdefgmmmmaaaammmaamm",
	"mmmaaammmaaammmabcdefaaaammmmabcdefmmmaaaa",
	"aaaaaaaazzzzzzzz",
	"mmamammmmammamamaaamammma",
	"abcdefghijklmnopqrrqponmlkjihgfedcba"
};

class mapview : public genclient, inputsink
{
	model_c *worldmodel;
	rentity_t worldent;

	size_t whoa;
	model_c *monsters[11];

	vec3 vieworg;
	vec3 viewang;
	float lasttime;

	int move_forward;
	int move_back;
	int move_left;
	int move_right;

	virtual void KeyEvent		(int down, int scancode)
	{
		down = !!down;
		if (scancode == 'w')
			move_forward = down;
		else if (scancode == 's')
			move_back = down;
		else if (scancode == 'a')
			move_left = down;
		else if (scancode == 'd')
			move_right = down;
		else if (scancode == '9' && down)
		{
			if (whoa > 0)
				whoa--;
		}
		else if (scancode == '0' && down)
			whoa++;
	}
	virtual void TextInput		(char *text)
	{
	}
	virtual void ButtonEvent	(int down, int button)
	{
		down = !!down;
		if (button == 1)
			move_forward = down;
	}
	virtual void MouseDelta		(int x, int y)
	{
		viewang.v[0] += y*0.3;
		viewang.v[1] -= x*0.3;
	}
	virtual void MouseAbsolute	(int x, int y)
	{
	}



public:
	mapview(const char *mapname, vec3 org, vec3 ang)
	{
		char fullmapname[256];
		snprintf(fullmapname, sizeof(fullmapname), "maps/%s.bsp", mapname);
		worldmodel = NULL;//R_Model_Get(fullmapname);
		vieworg = org;
		viewang = ang;

		move_forward = 0;
		move_back = 0;
		move_right = 0;
		move_left = 0;

		whoa = 256;
		monsters[0] = R_Model_Get("progs/knight.mdl");
		monsters[1] = R_Model_Get("progs/hknight.mdl");
		monsters[2] = R_Model_Get("progs/soldier.mdl");
		monsters[3] = R_Model_Get("progs/dog.mdl");
		monsters[4] = R_Model_Get("progs/enforcer.mdl");
		monsters[5] = R_Model_Get("progs/player.mdl");
		monsters[6] = R_Model_Get("progs/shalrath.mdl");
		monsters[7] = R_Model_Get("progs/shambler.mdl");
		monsters[8] = R_Model_Get("progs/ogre.mdl");
		monsters[9] = R_Model_Get("progs/tarbaby.mdl");
		monsters[10] = R_Model_Get("progs/demon.mdl");

		/*monsters[0] = R_Model_Get("maps/b_shell0.bsp");
		monsters[1] = R_Model_Get("maps/b_shell1.bsp");
		monsters[2] = R_Model_Get("maps/b_nail0.bsp");
		monsters[3] = R_Model_Get("maps/b_nail1.bsp");
		monsters[4] = R_Model_Get("maps/b_rock0.bsp");
		monsters[5] = R_Model_Get("maps/b_rock1.bsp");
		monsters[6] = R_Model_Get("maps/b_batt0.bsp");
		monsters[7] = R_Model_Get("maps/b_batt1.bsp");*/
	}
private:
	bool Run(vid_t *vid)
	{
		float time = vid->GetTime();
		float frametime = time - lasttime;
		lasttime = time;
		rstate_t scene;

		vid->input = this;

		memset(&scene, 0, sizeof(scene));
		memset(&worldent, 0, sizeof(worldent));
		scene.mode = vid->mode;

		float aspect = (float)vid->height/vid->width;
		scene.fovx = 90;
		scene.fovy = 360.0/M_PI * atan(aspect * tan(scene.fovx/360.0*M_PI));
		scene.projectionmatrix.MakeProjectionMatrix(scene.fovx, scene.fovy, 4);

		scene.vieworigin = vieworg;
		scene.viewmatrix.MakeViewMatrix(viewang, vieworg);
		scene.frustum.FromMatricies(scene.viewmatrix, scene.projectionmatrix);

		vec3 fwd,right,up;
		matrix4x4(viewang, vec3(0,0,0)).ToVectors(fwd,right,up);
		if (move_forward || move_back)
			vieworg += fwd * ((move_forward-move_back) * 400) * frametime;
		if (move_right || move_left)
			vieworg += right * ((move_right-move_left) * 400) * frametime;

		scene.viewproj = (scene.projectionmatrix * scene.viewmatrix);
		scene.time = time;

		float frac = (time*10) - floor(time*10);
		for (int i = 0; i < countof(lightstylestrings); i++)
		{
			size_t l = lightstylestrings[i]?strlen(lightstylestrings[i]):0;
			if (l)
			{
				size_t v1 = (size_t)(time*10) % l;
				size_t v2 = (size_t)((time*10)+1) % l;
				scene.lmscale[i] = ((lightstylestrings[i][v1]*(1-frac) + frac*lightstylestrings[i][v2] - 'a') * 22) / 128.0;
			}
			else
				scene.lmscale[i] = 1;	//unspecified styles are 1
		}
		for (int i = countof(lightstylestrings); i < countof(scene.lmscale); i++)
			scene.lmscale[i] = sin(time*.3)*.5 + 0.5;	//unspecified styles are 1

		worldent.matrix[0] = 1;
		worldent.matrix[5] = 1;
		worldent.matrix[10] = 1;
		worldent.matrix[15] = 1;

		if (worldmodel)
			worldmodel->DrawEntity(&worldent, &scene);

		for (size_t i = 0; i < whoa*whoa; i++)
		{
			worldent.matrix[12] = (i/whoa - whoa/2.0) * 64;
			worldent.matrix[13] = (i%whoa - whoa/2.0) * 64;
			worldent.matrix[14] = 24;
			if (!scene.frustum.Contains(vec3(worldent.matrix[12], worldent.matrix[13], worldent.matrix[14]), 64))
				continue;

			float atime = time * 10 + i * 10;
			worldent.anim[0] = atime;
			worldent.anim[1] = atime+1;
			worldent.animweight[1] = atime-(int)atime;
			worldent.animweight[0] = 1-(atime-(int)atime);


			atime = time + i;

			float sinatime = sin(atime);
			float cosatime = cos(atime);

			worldent.matrix[0] = sinatime;
			worldent.matrix[1] = cosatime;
			worldent.matrix[2] = 0;
			worldent.matrix[4] = -cosatime;
			worldent.matrix[5] = sinatime;
			worldent.matrix[6] = 0;
			worldent.matrix[8] = 0;
			worldent.matrix[9] = 0;
			worldent.matrix[10] = 1;

			if (monsters[i%(countof(monsters))])
				monsters[i%(countof(monsters))]->DrawEntity(&worldent, &scene);
		}
		return true;
	}
};
genclient *MapView_Init(const char *mapname, vec3 origin, vec3 angles)
{
	return new mapview(mapname, origin, angles);
}
