//contains vec, vec3, and matrix definitions.

#ifndef __MATHS_H__
#define __MATHS_H__

#include <math.h>

#ifndef M_PI
#define M_PI 3.1415926535897932384626433832795	//aproximatly.
#endif

typedef int ivec;
typedef float vec;
//typedef vec vec3[3];
typedef vec vec2[2];

class vec3;
class vec4;
class matrix4x4;
class frustum_c;

class matrix4x4
{
public:
	vec data[16];	//so it can easily be passed to opengl

	inline float &operator [] (int i)
	{
		return data[i];
	}
	inline void operator = (const matrix4x4 b)	//copy
	{
		data[0] = b.data[0];
		data[1] = b.data[1];
		data[2] = b.data[2];
		data[3] = b.data[3];
		data[4] = b.data[4];
		data[5] = b.data[5];
		data[6] = b.data[6];
		data[7] = b.data[7];
		data[8] = b.data[8];
		data[9] = b.data[9];
		data[10] = b.data[10];
		data[11] = b.data[11];
		data[12] = b.data[12];
		data[13] = b.data[13];
		data[14] = b.data[14];
		data[15] = b.data[15];
	}

	matrix4x4 operator * (matrix4x4 &b);
	void operator *= (matrix4x4 &b);
	vec3 operator * (vec3 &v);
	vec4 operator * (vec4 &v);

	void FromEularOrigin(vec3 eular, vec3 origin);
	void MakeViewMatrix(vec3 eular, vec3 origin);
	void MakeProjectionMatrix(vec fovx, vec fovy, vec znear);	//3d view (infinate depth)
	void MakeParallelProjection(vec left, vec right, vec top, vec bottom, vec znear, vec zfar);	//2d view
	void ToVectors(vec3 &forward, vec3 &right, vec3 &up);
	void ToOrigin(vec3 &ret);
	
	void MakeInverse(matrix4x4 &b);
	void MakeIdentity();
	void MakeRotation(vec a, vec x, vec y, vec z);
	void MakeTranslation(vec x, vec y, vec z);

	matrix4x4 (vec3 ang, vec3 org);
	matrix4x4 (){}
};

#define MakeVectors(angles, forward, right, up) do {matrix4x4 tmp;tmp.FromEularOrigin(angles, vec3_null);tmp.ToVectors(forward, right, up);} while (0)

class ivec3
{
public:
	ivec v[3];

	inline ivec3 ()
	{
	}
	inline ivec3 (ivec a, ivec b, ivec c)
	{
		v[0] = a;
		v[1] = b;
		v[2] = c;
	}
//	inline ivec &operator [] (int i)
//	{
//		return v[i];
//	}
	inline ivec3 operator / (int b)
	{
		ivec3 ret;
		ret.v[0] = v[0] / b;
		ret.v[1] = v[1] / b;
		ret.v[2] = v[2] / b;
		return ret;
	}
};

class vec3
{
public:
	vec v[3];

	inline vec3 (float a, float b, float c)
	{
		v[0] = a;
		v[1] = b;
		v[2] = c;
	}
	inline vec3 (float *src)
	{
		v[0] = src[0];
		v[1] = src[1];
		v[2] = src[2];
	}
/*	inline vec3 (vec a, vec b, vec c)
	{
		v[0] = a;
		v[1] = b;
		v[2] = c;
	}*/
/*	inline vec3 (int a, int b, int c)
	{
		v[0] = (float)a;
		v[1] = (float)b;
		v[2] = (float)c;
	}*/
	inline vec3 (char *s)
	{
		while(*s == ' ' || *s == '\t')
			s++;
		v[0] = (vec)atof(s);
		while((*s >= '0' && *s <= '9') || *s == '.' || *s == '-')
			s++;

		while(*s == ' ' || *s == '\t')
			s++;
		v[1] = (vec)atof(s);
		while((*s >= '0' && *s <= '9') || *s == '.' || *s == '-')
			s++;

		while(*s == ' ' || *s == '\t')
			s++;
		v[2] = (vec)atof(s);
	}
	inline vec3 ()
	{
	}
	inline float length(void)
	{
		return (float)sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2]);
	}
	inline void normalize(void)
	{
		float f;
		f = v[0]*v[0] + v[1]*v[1] + v[2]*v[2];
		if (!f)
			return;
		f = 1.0f / (float)sqrt(f);
		v[0] *= f;
		v[1] *= f;
		v[2] *= f;
	}
	inline void interpolate(vec3 a, float bness, vec3 b)
	{
		v[0] = a[0] + bness * (b[0]-a[0]);
		v[1] = a[1] + bness * (b[1]-a[1]);
		v[2] = a[2] + bness * (b[2]-a[2]);
	}
	inline void interpolate_angles(vec3 a, float bness, vec3 b, float period)
	{
		int i;
		for (i = 0; i < 3; i++)
		{
			float diff = (b[i]-a[i]);
			while (diff > period/2)
				diff -= period;
			while (diff < -period/2)
				diff += period;
			v[i] = a[i] + bness * diff;
		}
	}
	inline vec3 toeularangles()
	{
		vec3 ret;
		ret[0] = atan2(v[2], v[0]);
		ret[1] = atan2(v[1], v[0]);
		ret[2] = 0;
		return ret;
	}
	inline vec3 operator + (vec3 a)
	{
		vec3 ret;
		ret.v[0] = v[0] + a.v[0];
		ret.v[1] = v[1] + a.v[1];
		ret.v[2] = v[2] + a.v[2];
		return ret;
	}
	inline vec3 operator - (vec3 a)
	{
		vec3 ret;
		ret.v[0] = v[0] - a.v[0];
		ret.v[1] = v[1] - a.v[1];
		ret.v[2] = v[2] - a.v[2];
		return ret;
	}
	inline vec3 operator += (vec3 a)
	{
		v[0] += a.v[0];
		v[1] += a.v[1];
		v[2] += a.v[2];
		return *this;
	}
	inline vec3 operator -= (vec3 a)
	{
		v[0] -= a.v[0];
		v[1] -= a.v[1];
		v[2] -= a.v[2];
		return *this;
	}
	inline vec3 operator *= (vec b)
	{
		v[0] *= b;
		v[1] *= b;
		v[2] *= b;
		return *this;
	}
	inline float &operator [] (int i)
	{
		return v[i];
	}
	inline void operator = (vec b)
	{
		v[0] = b;
		v[1] = b;
		v[2] = b;
	}
	inline void operator = (vec *b)	//copy from float array
	{
		v[0] = b[0];
		v[1] = b[1];
		v[2] = b[2];
	}
	inline void operator = (vec3 b)	//copy
	{
		v[0] = b.v[0];
		v[1] = b.v[1];
		v[2] = b.v[2];
	}
	inline void operator = (vec3 *b)	//copy
	{
		v[0] = b->v[0];
		v[1] = b->v[1];
		v[2] = b->v[2];
	}

	inline bool operator == (vec3 b)	//equality (with tolerance of 1/8th)
	{
		return	(int)(v[0]*8) == (int)(b.v[0]*8) &&
				(int)(v[1]*8) == (int)(b.v[1]*8) &&
				(int)(v[2]*8) == (int)(b.v[2]*8);
	}

	inline bool operator > (vec b)	//comparison of magnitude
	{
		return (v[0]*v[0] + v[1]*v[1] + v[2]*v[2]) > (b*b);
	}
	inline bool operator < (vec b)	//comparison of magnitude
	{
		return (v[0]*v[0] + v[1]*v[1] + v[2]*v[2]) < (b*b);
	}

	inline float operator * (vec3 b)	//dot product
	{
		return v[0]*b.v[0] + v[1]*b.v[1] + v[2]*b.v[2];
	}

	inline float operator * (vec *b)	//alternate dot-product - it's just handy
	{
		return v[0]*b[0] + v[1]*b[1] + v[2]*b[2];
	}
	inline vec3 operator * (vec b)
	{
		return vec3(v[0] * b,
					v[1] * b,
					v[2] * b);
	}
	inline vec3 operator / (vec b)
	{
		vec3 ret;
		ret.v[0] = v[0] / b;
		ret.v[1] = v[1] / b;
		ret.v[2] = v[2] / b;
		return ret;
	}
};
#define LittleVec3(v) vec3(LittleFloat((v).data[0]), LittleFloat(v.data[1]), LittleFloat(v.data[2]))

class vec4
{
public:
	vec v[4];

	inline vec4 (vec a, vec b, vec c, vec d)
	{
		v[0] = a;
		v[1] = b;
		v[2] = c;
		v[3] = d;
	}
	inline vec4 ()
	{
	}
	inline vec3 noncartesian(void)
	{
		return vec3(v[0]/v[3], v[1]/v[3], v[2]/v[3]);
	}
};

class frustum_c
{
private:
	static const int FRUSTUM_PLANES = 4;
	//no near plane because the difference between near and side on the near side is insignificant to warrent the processing power
	//no far plane because that limits max depth.
	vec3 plane[FRUSTUM_PLANES];
	vec dist[FRUSTUM_PLANES];

public:
	void FromMatricies(matrix4x4 modelview, matrix4x4 projection);
	inline bool Contains (vec3 org)
	{
		for (int i = 0; i < FRUSTUM_PLANES; i++)
		{
			if ((plane[i] * org) + dist[i] < 0)
				return false;	//outside
		}

		return true;
	}
	inline bool Contains (vec3 org, vec radius)
	{
		for (int i = 0; i < FRUSTUM_PLANES; i++)
		{
			if ((plane[i] * org) + dist[i] < -radius)
				return false;	//outside
		}

		return true;
	}
	inline bool Contains (vec3 min, vec3 max)
	{
		vec3 org;
		for (int i = 0; i < FRUSTUM_PLANES; i++)
		{
			//fashion org so that it's the nearest point to the plane

			org.v[0] = (plane[i].v[0]<0)?min.v[0]:max.v[0];
			org.v[1] = (plane[i].v[1]<0)?min.v[1]:max.v[1];
			org.v[2] = (plane[i].v[2]<0)?min.v[2]:max.v[2];

			if ((plane[i] * org) + dist[i] < 0)
				return false;	//outside
		}
		return true;
	}
};

extern vec3 vec3_null;

#endif	//__MATHS_H__
