#include "common.h"
#include "maths.h"

vec3 vec3_null;

//This function is GL stylie (glRotate without multiply, use as second operand to multiply).
void matrix4x4::MakeRotation(vec a, vec x, vec y, vec z)
{
	vec c = (vec)cos(a* M_PI / 180.0);
	vec s = (vec)sin(a* M_PI / 180.0);

	data[0]  = x*x*(1-c)+c;
	data[4]  = x*y*(1-c)-z*s;
	data[8]  = x*z*(1-c)+y*s;
	data[12] = 0;

	data[1]  = y*x*(1-c)+z*s;
    data[5]  = y*y*(1-c)+c;
	data[9]  = y*z*(1-c)-x*s;
	data[13] = 0;

	data[2]  = z*x*(1-c)-y*s;
	data[6]  = z*y*(1-c)+x*s;
	data[10] = z*z*(1-c)+c;
	data[14] = 0;

	data[3]  = 0;
	data[7]  = 0;
	data[11] = 0;
	data[15] = 1;
}

static void MakeRotationRoll(float *data, vec a)
{
	vec c = (vec)cos(a* M_PI / 180.0);
	vec s = (vec)sin(a* M_PI / 180.0);

	data[0]  = 1;
	data[4]  = 0;
	data[8]  = 0;
	data[12] = 0;

	data[1]  = 0;
    data[5]  = +c;
	data[9]  = -s;
	data[13] = 0;

	data[2]  = 0;
	data[6]  = +s;
	data[10] = +c;
	data[14] = 0;

	data[3]  = 0;
	data[7]  = 0;
	data[11] = 0;
	data[15] = 1;
}
static void MakeRotationPitch(float *data, vec a)
{
	vec x = 0;
	vec y = 1;
	vec z = 0;

	vec c = (vec)cos(a* M_PI / 180.0);
	vec s = (vec)sin(a* M_PI / 180.0);

	data[0]  = +c;
	data[4]  = 0;
	data[8]  = +s;
	data[12] = 0;

	data[1]  = 0;
    data[5]  = 1;
	data[9]  = 0;
	data[13] = 0;

	data[2]  = -s;
	data[6]  = 0;
	data[10] = +c;
	data[14] = 0;

	data[3]  = 0;
	data[7]  = 0;
	data[11] = 0;
	data[15] = 1;
}
static void MakeRotationYaw(float *data, vec a)
{
	vec c = (vec)cos(a* M_PI / 180.0);
	vec s = (vec)sin(a* M_PI / 180.0);

	data[0]  = c;
	data[4]  = -s;
	data[8]  = 0;
	data[12] = 0;

	data[1]  = s;
    data[5]  = +c;
	data[9]  = 0;
	data[13] = 0;

	data[2]  = 0;
	data[6]  = 0;
	data[10] = 1;
	data[14] = 0;

	data[3]  = 0;
	data[7]  = 0;
	data[11] = 0;
	data[15] = 1;
}

//This function is GL stylie (glTranslate without multiply, use as second operand to multiply).
void matrix4x4::MakeTranslation(vec x, vec y, vec z)
{
	data[0] = 1;
	data[4] = 0;
	data[8] = 0;
	data[12] = x;

	data[1] = 0;
    data[5] = 1;
	data[9] = 0;
	data[13] = y;

	data[2] = 0;
	data[6] = 0;
	data[10] = 1;
	data[14] = z;

	data[3] = 0;
	data[7] = 0;
	data[11] = 0;
	data[15] = 1;
}




matrix4x4 matrix4x4::operator * (matrix4x4 &b)
{
	matrix4x4 out;

#define a data
#define b b.data
	out.data[0]  = a[0] * b[0] + a[4] * b[1] + a[8] * b[2] + a[12] * b[3];
	out.data[1]  = a[1] * b[0] + a[5] * b[1] + a[9] * b[2] + a[13] * b[3];
	out.data[2]  = a[2] * b[0] + a[6] * b[1] + a[10] * b[2] + a[14] * b[3];
	out.data[3]  = a[3] * b[0] + a[7] * b[1] + a[11] * b[2] + a[15] * b[3];

	out.data[4]  = a[0] * b[4] + a[4] * b[5] + a[8] * b[6] + a[12] * b[7];
	out.data[5]  = a[1] * b[4] + a[5] * b[5] + a[9] * b[6] + a[13] * b[7];
	out.data[6]  = a[2] * b[4] + a[6] * b[5] + a[10] * b[6] + a[14] * b[7];
	out.data[7]  = a[3] * b[4] + a[7] * b[5] + a[11] * b[6] + a[15] * b[7];

	out.data[8]  = a[0] * b[8] + a[4] * b[9] + a[8] * b[10] + a[12] * b[11];
	out.data[9]  = a[1] * b[8] + a[5] * b[9] + a[9] * b[10] + a[13] * b[11];
	out.data[10] = a[2] * b[8] + a[6] * b[9] + a[10] * b[10] + a[14] * b[11];
	out.data[11] = a[3] * b[8] + a[7] * b[9] + a[11] * b[10] + a[15] * b[11];

	out.data[12] = a[0] * b[12] + a[4] * b[13] + a[8] * b[14] + a[12] * b[15];
	out.data[13] = a[1] * b[12] + a[5] * b[13] + a[9] * b[14] + a[13] * b[15];
	out.data[14] = a[2] * b[12] + a[6] * b[13] + a[10] * b[14] + a[14] * b[15];
	out.data[15] = a[3] * b[12] + a[7] * b[13] + a[11] * b[14] + a[15] * b[15];
#undef a
#undef b

	return out;
}
void matrix4x4::operator *= (matrix4x4 &b)
{
	vec a[16];
	memcpy(a, data, sizeof(data));
	data[0]  = a[0] * b[0] + a[4] * b[1] + a[8] * b[2] + a[12] * b[3];
	data[1]  = a[1] * b[0] + a[5] * b[1] + a[9] * b[2] + a[13] * b[3];
	data[2]  = a[2] * b[0] + a[6] * b[1] + a[10] * b[2] + a[14] * b[3];
	data[3]  = a[3] * b[0] + a[7] * b[1] + a[11] * b[2] + a[15] * b[3];

	data[4]  = a[0] * b[4] + a[4] * b[5] + a[8] * b[6] + a[12] * b[7];
	data[5]  = a[1] * b[4] + a[5] * b[5] + a[9] * b[6] + a[13] * b[7];
	data[6]  = a[2] * b[4] + a[6] * b[5] + a[10] * b[6] + a[14] * b[7];
	data[7]  = a[3] * b[4] + a[7] * b[5] + a[11] * b[6] + a[15] * b[7];

	data[8]  = a[0] * b[8] + a[4] * b[9] + a[8] * b[10] + a[12] * b[11];
	data[9]  = a[1] * b[8] + a[5] * b[9] + a[9] * b[10] + a[13] * b[11];
	data[10] = a[2] * b[8] + a[6] * b[9] + a[10] * b[10] + a[14] * b[11];
	data[11] = a[3] * b[8] + a[7] * b[9] + a[11] * b[10] + a[15] * b[11];

	data[12] = a[0] * b[12] + a[4] * b[13] + a[8] * b[14] + a[12] * b[15];
	data[13] = a[1] * b[12] + a[5] * b[13] + a[9] * b[14] + a[13] * b[15];
	data[14] = a[2] * b[12] + a[6] * b[13] + a[10] * b[14] + a[14] * b[15];
	data[15] = a[3] * b[12] + a[7] * b[13] + a[11] * b[14] + a[15] * b[15];
}

vec3 matrix4x4::operator *(vec3 &v)
{
	vec3 ret;
	ret.v[0] = v.v[0] * data[0] + v.v[1] * data[4] + v.v[2] * data[8] + 1/*v.data[3]*/ * data[12];
	ret.v[1] = v.v[0] * data[1] + v.v[1] * data[5] + v.v[2] * data[9] + 1/*v.data[3]*/ * data[13];
	ret.v[2] = v.v[0] * data[2] + v.v[1] * data[6] + v.v[2] * data[10] + 1/*v.data[3]*/ * data[14];
//	ret.data[3] = v.data[0] * data[3] + v.data[1] * data[7] + v.data[2] * data[11] + 1/*v.data[3]*/ * data[15];
#if 0
	ret.data[0] = v.data[0] * data[0] + v.data[1] * data[1] + v.data[2] * data[2] + 1/*v.data[3]*/ * data[3];
	ret.data[1] = v.data[0] * data[4] + v.data[1] * data[5] + v.data[2] * data[6] + 1/*v.data[3]*/ * data[7];
	ret.data[2] = v.data[0] * data[8] + v.data[1] * data[9] + v.data[2] * data[10] + 1/*v.data[3]*/ * data[11];
//	ret.data[3] = v.data[0] * data[12] + v.data[1] * data[13] + v.data[2] * data[14] + 1/*v.data[3]*/ * data[15];
#endif
	return ret;
}

vec4 matrix4x4::operator *(vec4 &v)
{
	vec4 ret;
	ret.v[0] = v.v[0] * data[0] + v.v[1] * data[4] + v.v[2] * data[8] + v.v[3] * data[12];
	ret.v[1] = v.v[0] * data[1] + v.v[1] * data[5] + v.v[2] * data[9] + v.v[3] * data[13];
	ret.v[2] = v.v[0] * data[2] + v.v[1] * data[6] + v.v[2] * data[10] + v.v[3] * data[14];
	ret.v[3] = v.v[0] * data[3] + v.v[1] * data[7] + v.v[2] * data[11] + v.v[3] * data[15];
#if 0
	ret.data[0] = v.data[0] * data[0] + v.data[1] * data[1] + v.data[2] * data[2] + 1/*v.data[3]*/ * data[3];
	ret.data[1] = v.data[0] * data[4] + v.data[1] * data[5] + v.data[2] * data[6] + 1/*v.data[3]*/ * data[7];
	ret.data[2] = v.data[0] * data[8] + v.data[1] * data[9] + v.data[2] * data[10] + 1/*v.data[3]*/ * data[11];
//	ret.data[3] = v.data[0] * data[12] + v.data[1] * data[13] + v.data[2] * data[14] + 1/*v.data[3]*/ * data[15];
#endif
	return ret;
}

void matrix4x4::MakeInverse(matrix4x4 &b)
{
#if 1
//this is from GLU

/*
 * Compute inverse of 4x4 transformation matrix.
 * Code contributed by Jacques Leroy jle@star.be
 * Return true for success, false for failure (singular matrix)
 */

/* NB. OpenGL Matrices are COLUMN major. */
#define m b.data
#define out this->data
#define SWAP_ROWS(a, b) { float *_tmp = a; (a)=(b); (b)=_tmp; }
#define MAT(m,r,c) (m)[(c)*4+(r)]

   float wtmp[4][8];
   float m0, m1, m2, m3, s;
   float *r0, *r1, *r2, *r3;

   r0 = wtmp[0], r1 = wtmp[1], r2 = wtmp[2], r3 = wtmp[3];

   r0[0] = MAT(m, 0, 0), r0[1] = MAT(m, 0, 1),
      r0[2] = MAT(m, 0, 2), r0[3] = MAT(m, 0, 3),
      r0[4] = 1.0, r0[5] = r0[6] = r0[7] = 0.0,
      r1[0] = MAT(m, 1, 0), r1[1] = MAT(m, 1, 1),
      r1[2] = MAT(m, 1, 2), r1[3] = MAT(m, 1, 3),
      r1[5] = 1.0, r1[4] = r1[6] = r1[7] = 0.0,
      r2[0] = MAT(m, 2, 0), r2[1] = MAT(m, 2, 1),
      r2[2] = MAT(m, 2, 2), r2[3] = MAT(m, 2, 3),
      r2[6] = 1.0, r2[4] = r2[5] = r2[7] = 0.0,
      r3[0] = MAT(m, 3, 0), r3[1] = MAT(m, 3, 1),
      r3[2] = MAT(m, 3, 2), r3[3] = MAT(m, 3, 3),
      r3[7] = 1.0, r3[4] = r3[5] = r3[6] = 0.0;

   /* choose pivot - or die */
   if (fabs(r3[0]) > fabs(r2[0]))
      SWAP_ROWS(r3, r2);
   if (fabs(r2[0]) > fabs(r1[0]))
      SWAP_ROWS(r2, r1);
   if (fabs(r1[0]) > fabs(r0[0]))
      SWAP_ROWS(r1, r0);
   if (0.0 == r0[0])
      return;

   /* eliminate first variable     */
   m1 = r1[0] / r0[0];
   m2 = r2[0] / r0[0];
   m3 = r3[0] / r0[0];
   s = r0[1];
   r1[1] -= m1 * s;
   r2[1] -= m2 * s;
   r3[1] -= m3 * s;
   s = r0[2];
   r1[2] -= m1 * s;
   r2[2] -= m2 * s;
   r3[2] -= m3 * s;
   s = r0[3];
   r1[3] -= m1 * s;
   r2[3] -= m2 * s;
   r3[3] -= m3 * s;
   s = r0[4];
   if (s != 0.0) {
      r1[4] -= m1 * s;
      r2[4] -= m2 * s;
      r3[4] -= m3 * s;
   }
   s = r0[5];
   if (s != 0.0) {
      r1[5] -= m1 * s;
      r2[5] -= m2 * s;
      r3[5] -= m3 * s;
   }
   s = r0[6];
   if (s != 0.0) {
      r1[6] -= m1 * s;
      r2[6] -= m2 * s;
      r3[6] -= m3 * s;
   }
   s = r0[7];
   if (s != 0.0) {
      r1[7] -= m1 * s;
      r2[7] -= m2 * s;
      r3[7] -= m3 * s;
   }

   /* choose pivot - or die */
   if (fabs(r3[1]) > fabs(r2[1]))
      SWAP_ROWS(r3, r2);
   if (fabs(r2[1]) > fabs(r1[1]))
      SWAP_ROWS(r2, r1);
   if (0.0 == r1[1])
      return;

   /* eliminate second variable */
   m2 = r2[1] / r1[1];
   m3 = r3[1] / r1[1];
   r2[2] -= m2 * r1[2];
   r3[2] -= m3 * r1[2];
   r2[3] -= m2 * r1[3];
   r3[3] -= m3 * r1[3];
   s = r1[4];
   if (0.0 != s) {
      r2[4] -= m2 * s;
      r3[4] -= m3 * s;
   }
   s = r1[5];
   if (0.0 != s) {
      r2[5] -= m2 * s;
      r3[5] -= m3 * s;
   }
   s = r1[6];
   if (0.0 != s) {
      r2[6] -= m2 * s;
      r3[6] -= m3 * s;
   }
   s = r1[7];
   if (0.0 != s) {
      r2[7] -= m2 * s;
      r3[7] -= m3 * s;
   }

   /* choose pivot - or die */
   if (fabs(r3[2]) > fabs(r2[2]))
      SWAP_ROWS(r3, r2);
   if (0.0 == r2[2])
      return;

   /* eliminate third variable */
   m3 = r3[2] / r2[2];
   r3[3] -= m3 * r2[3], r3[4] -= m3 * r2[4],
      r3[5] -= m3 * r2[5], r3[6] -= m3 * r2[6], r3[7] -= m3 * r2[7];

   /* last check */
   if (0.0 == r3[3])
      return;

   s = 1.0 / r3[3];             /* now back substitute row 3 */
   r3[4] *= s;
   r3[5] *= s;
   r3[6] *= s;
   r3[7] *= s;

   m2 = r2[3];                  /* now back substitute row 2 */
   s = 1.0 / r2[2];
   r2[4] = s * (r2[4] - r3[4] * m2), r2[5] = s * (r2[5] - r3[5] * m2),
      r2[6] = s * (r2[6] - r3[6] * m2), r2[7] = s * (r2[7] - r3[7] * m2);
   m1 = r1[3];
   r1[4] -= r3[4] * m1, r1[5] -= r3[5] * m1,
      r1[6] -= r3[6] * m1, r1[7] -= r3[7] * m1;
   m0 = r0[3];
   r0[4] -= r3[4] * m0, r0[5] -= r3[5] * m0,
      r0[6] -= r3[6] * m0, r0[7] -= r3[7] * m0;

   m1 = r1[2];                  /* now back substitute row 1 */
   s = 1.0 / r1[1];
   r1[4] = s * (r1[4] - r2[4] * m1), r1[5] = s * (r1[5] - r2[5] * m1),
      r1[6] = s * (r1[6] - r2[6] * m1), r1[7] = s * (r1[7] - r2[7] * m1);
   m0 = r0[2];
   r0[4] -= r2[4] * m0, r0[5] -= r2[5] * m0,
      r0[6] -= r2[6] * m0, r0[7] -= r2[7] * m0;

   m0 = r0[1];                  /* now back substitute row 0 */
   s = 1.0 / r0[0];
   r0[4] = s * (r0[4] - r1[4] * m0), r0[5] = s * (r0[5] - r1[5] * m0),
      r0[6] = s * (r0[6] - r1[6] * m0), r0[7] = s * (r0[7] - r1[7] * m0);

   MAT(out, 0, 0) = r0[4];
   MAT(out, 0, 1) = r0[5], MAT(out, 0, 2) = r0[6];
   MAT(out, 0, 3) = r0[7], MAT(out, 1, 0) = r1[4];
   MAT(out, 1, 1) = r1[5], MAT(out, 1, 2) = r1[6];
   MAT(out, 1, 3) = r1[7], MAT(out, 2, 0) = r2[4];
   MAT(out, 2, 1) = r2[5], MAT(out, 2, 2) = r2[6];
   MAT(out, 2, 3) = r2[7], MAT(out, 3, 0) = r3[4];
   MAT(out, 3, 1) = r3[5], MAT(out, 3, 2) = r3[6];
   MAT(out, 3, 3) = r3[7];

#undef MAT
#undef SWAP_ROWS

#else

	//http://steve.hollasch.net/cgindex/math/matrix/afforthinv.c


	double Tx, Ty, Tz;   /* Translation Components */
	double L;            /* 1 / Basis Vector Length^2  */
	float *m = b.data;

	/* The inverse of the upper 3x3 is the transpose (since the basis vectors
	** are orthogonal to each other.  We also need to invert out any scales in
	** these basis vectors.  To do this, divide by the square of the magnitude
	** of the vector (once to get a unit vector, and once more to get a vector
	** of inverse length.)  This just amounts to dividing by the vector dotted
	** with itself.  */

	L = 1 / (m[0]*m[0] + m[4]*m[4] + m[8]*m[8]);
	data[0] = L * m[0];
	data[1] = L * m[4];
	data[2] = L * m[8];

	L = 1 / (m[1]*m[1] + m[5]*m[5] + m[9]*m[9]);
	data[4] = L * m[1];
	data[5] = L * m[5];
	data[6] = L * m[9];

	L = 1 / (m[2]*m[2] + m[6]*m[6] + m[10]*m[10]);
	data[8] = L * m[2];
	data[9] = L * m[6];
	data[10] = L * m[10];

	/* The inverse of the translation component is just the negation of the
	** translation after dotting with the new upper3x3 rows. */

	Tx = m[3];
	Ty = m[7];
	Tz = m[11];

	data[3] = - (Tx*data[0] + Ty*data[1] + Tz*data[2]);
	data[7] = - (Tx*data[4] + Ty*data[5] + Tz*data[6]);
	data[11] = - (Tx*data[8] + Ty*data[9] + Tz*data[10]);

	/* We assume a bottom (affine) row of [0 0 0 1]. */

	data[12] = 0;
	data[13] = 0;
	data[14] = 0;
	data[15] = 1;
#endif
}

void matrix4x4::MakeIdentity()
{
	data[0] = 1;
	data[4] = 0;
	data[8] = 0;
	data[12] = 0;

	data[1] = 0;
	data[5] = 1;
	data[9] = 0;
	data[13] = 0;

	data[2] = 0;
	data[6] = 0;
	data[10] = 1;
	data[14] = 0;
	
	data[3] = 0;
	data[7] = 0;
	data[11] = 0;
	data[15] = 1;
}

void matrix4x4::MakeViewMatrix(vec3 viewangles, vec3 vieworg)
{
	matrix4x4 temp;

	//load identity.
	memset(&data, 0, sizeof(data));
	//make z face up
	data[2] = -1;
	data[4] = 1;
	data[9] = 1;
	data[15] = 1;

	temp.MakeRotation(-viewangles.v[2],  1, 0, 0);
	(*this) *= temp;
	temp.MakeRotation(-viewangles.v[0],  0, 1, 0);
	(*this) *= temp;
	temp.MakeRotation(-viewangles.v[1],  0, 0, 1);
	(*this) *= temp;

	temp.MakeTranslation(-vieworg.v[0],  -vieworg.v[1],  -vieworg.v[2]);
	(*this) *= temp;
}

void matrix4x4::FromEularOrigin(vec3 angles, vec3 org)
{
	vec cy = (vec)cos(angles.v[1]* M_PI / 180.0);
	vec sy = (vec)sin(angles.v[1]* M_PI / 180.0);
	vec cp = (vec)cos(angles.v[0]* M_PI / 180.0);
	vec sp = (vec)sin(angles.v[0]* M_PI / 180.0);
	vec cr = (vec)cos(angles.v[2]* M_PI / 180.0);
	vec sr = (vec)sin(angles.v[2]* M_PI / 180.0);

	data[0]  = cy * cp;
	data[1]  = sy * cp;
	data[2]  = -sp;
	data[3]  = 0;

	data[4]  = -sy * cr + cy * sp * sr;
	data[5]  = cy * cr + sy * sp * sr;
	data[6]  = cp * sr;
	data[7]  = cp * sr;

	data[8]  = -sy * -sr + cy * sp * cr;
	data[9]  = cy * -sr + sy * sp * cr;
	data[10] = cp * cr;
	data[11] = cp * cr;

	data[12] = org[0];
	data[13] = org[1];
	data[14] = org[2];
	data[15] = 1;
}
matrix4x4::matrix4x4(vec3 angles, vec3 org)
{
	FromEularOrigin(angles, org);
}

void matrix4x4::MakeProjectionMatrix(vec fovx, vec fovy, vec znear)
{	//an infinate perspective matrix. How useful.

	// nudge infinity in just slightly for lsb slop
    vec nudge = 1;// - 1.0 / (1<<23);

	double xmin, xmax, ymin, ymax;

	ymax = znear * tan( fovy * M_PI / 360.0 );
	ymin = -ymax;

	xmin = znear * tan( fovx * M_PI / 360.0 );
	xmax = -xmin;

	data[0] = (vec)((2*znear) / (xmax - xmin));
	data[4] = 0;
	data[8] = (vec)((xmax + xmin) / (xmax - xmin));
	data[12] = 0;

	data[1] = 0;
	data[5] = (vec)((2*znear) / (ymax - ymin));
	data[9] = (vec)((ymax + ymin) / (ymax - ymin));
	data[13] = 0;

	data[2] = 0;
	data[6] = 0;
	data[10] = (vec)(-1  * nudge);
	data[14] = (vec)(-2*znear * nudge);
	
	data[3] = 0;
	data[7] = 0;
	data[11] = -1;
	data[15] = 0;
}

//no perspective distortions
void matrix4x4::MakeParallelProjection(vec left, vec right, vec top, vec bottom, vec znear, vec zfar)
{
	data[0] = 2/(right-left);
	data[4] = 0;
	data[8] = 0;
	data[12] = -(right+left)/(right-left);

	data[1] = 0;
	data[5] = 2/(top-bottom);
	data[9] = 0;
	data[13] = -(top+bottom)/(top-bottom);

	data[2] = 0;
	data[6] = 0;
	data[10] = -2/(zfar-znear);
	data[14] = (zfar+znear)/(zfar-znear);
	
	data[3] = 0;
	data[7] = 0;
	data[11] = 0;
	data[15] = 1;
}

void matrix4x4::ToOrigin(vec3 &ret)
{
	ret.v[0] = data[12+0];
	ret.v[1] = data[12+1];
	ret.v[2] = data[12+2];
}
void matrix4x4::ToVectors(vec3 &forward, vec3 &right, vec3 &up)
{
	forward.v[0]	= data[0+0];
	right.v[0]	= -data[4+0];
	up.v[0]		= data[8+0];

	forward.v[1]	= data[0+1];
	right.v[1]	= -data[4+1];
	up.v[1]		= data[8+1];

	forward.v[2]	= data[0+2];
	right.v[2]	= -data[4+2];
	up.v[2]		= data[8+2];
}


void frustum_c::FromMatricies(matrix4x4 modelview, matrix4x4 projection)
{
	vec scale;
	int i;
	matrix4x4 mvp;
	mvp = projection * modelview;

	for (i = 0; i < FRUSTUM_PLANES; i++)
	{
		if (i & 1)
		{
			plane[i].v[0]	= mvp[3] + mvp[0+i/2];
			plane[i].v[1]	= mvp[7] + mvp[4+i/2];
			plane[i].v[2]	= mvp[11] + mvp[8+i/2];
			dist[i]		= mvp[15] + mvp[12+i/2];
		}
		else
		{
			plane[i].v[0]	= mvp[3] - mvp[0+i/2];
			plane[i].v[1]	= mvp[7] - mvp[4+i/2];
			plane[i].v[2]	= mvp[11] - mvp[8+i/2];
			dist[i]		= mvp[15] - mvp[12+i/2];
		}

		scale = 1/(vec)sqrt(plane[i] * plane[i]);
		plane[i].v[0] *= scale;
		plane[i].v[1] *= scale;
		plane[i].v[2] *= scale;
		dist[i] *= scale;
	}
}
