#version 450 core
#define VULKAN

layout(std140, set=0, binding=0) uniform MatrixBlock
{
	mat4 mvp;
};

struct vert_s
{
	vec4 pos;
};
readonly layout(std140, set=0, binding=2) buffer vertexinfo
{
	vert_s vert[];
};


struct ent_s
{
	mat4	model;
	float	texlayer;
	uint	basevert;
	vec2	pad2;
	uvec2	firstvert;
	vec2	frameweight;
};

layout(std140, set=1, binding=0) uniform EntityBuffer
{
	ent_s ent[512];
};


in vec2 v_texcoord;
#ifdef VULKAN
#define v_drawid gl_InstanceIndex	//vulkan's gl_InstanceIndex does include the base instance, so its actually useful.
#else
in uint v_drawid; //gl's gl_InstanceID does NOT include the base instance, which means it can't be used to look things up.
#endif
layout(location = 0) out vec3 tc;
void main()
{
	uint vertid = uint(gl_VertexIndex) - ent[v_drawid].basevert;
	uvec2 fvert = ent[v_drawid].firstvert + vertid;
	vec2 fweight = ent[v_drawid].frameweight;
	vec3 pos = vert[fvert.x].pos.xyz*fweight.x + vert[fvert.y].pos.xyz*fweight.y;

	gl_Position = mvp * (ent[v_drawid].model * vec4(pos.xyz, 1.0));

#ifdef VULKAN
	gl_Position.y *= -1;
#endif

	tc = vec3(v_texcoord, ent[v_drawid].texlayer);
}