class netpeer
{
	friend class netcon;
	friend class netcon_udp;

	unsigned char storage[128];	//sockaddr_storage
	unsigned int addrlen;

public:
	bool demofile;
	bool Resolve(const char *peername, int defaultport);
	bool ForcePort(int newport);
};

class netbuf
{
	friend class netcon;
	friend class netcon_udp;

public:
	unsigned char	*data;
	unsigned int	maxlen;
	unsigned int	writepos;	//may not exceed maxlen
	unsigned int	readpos;	//max not exceed writepos
	bool			badread;

	void Reset(void)
	{
		readpos = 0;
		writepos = 0;
		badread = false;
	}
	netbuf(unsigned char *buf, unsigned int bufsize)
	{
		data = buf;
		maxlen = bufsize;
		Reset();
	}

	unsigned int ReadByte(void)
	{
		if (readpos >= writepos)
		{
			badread = true;
			return 0;
		}
		return data[readpos++];
	}
	unsigned short ReadUShort(void)
	{
		unsigned short r;
		r = ReadByte();
		r |= ReadByte()<<8;
		return r;
	};
	signed short ReadSShort(void)
	{
		short r;
		r = ReadByte();
		r |= ReadByte()<<8;
		return r;
	};
	unsigned int ReadULong(void)
	{
		unsigned int r;
		r = ReadByte();
		r |= ReadByte()<<8;
		r |= ReadByte()<<16;
		r |= ReadByte()<<24;
		return r;
	};
	signed int ReadSLong(void)
	{
		signed int r;
		r = ReadByte();
		r |= ReadByte()<<8;
		r |= ReadByte()<<16;
		r |= ReadByte()<<24;
		return r;
	};
	float ReadFloat(void)
	{
		union 
		{
			unsigned int i;
			float f;
		} u;
		u.i = ReadULong();
		return u.f;
	};
	unsigned char *ReadString(unsigned char *string, size_t maxlen)
	{
		unsigned char *ret = string;
		if (!maxlen)
			Sys_Error("ReadString given no buffer size ");

		while (--maxlen > 0)
		{
			unsigned char b = ReadByte();
			*string++ = b;
			if (!b)
				return ret;
		}
		badread = true;		//bad read
		readpos = writepos;	//make the rest of it an error
		*string = 0;
		return ret;
	}
	char *ReadString(char *string, size_t maxlen)
	{
		char *ret = string;
		if (!maxlen)
			Sys_Error("ReadString given no buffer size ");

		while (--maxlen > 0)
		{
			unsigned char b = ReadByte();
			*string++ = b;
			if (!b)
				return ret;
		}
		badread = true;		//bad read
		readpos = writepos;	//make the rest of it an error
		*string = 0;
		return ret;
	}

	unsigned int ReadData(unsigned char *buf, unsigned int len)
	{
		if (len > writepos - readpos)
		{
			len = writepos - readpos;
			badread = true;
		}
		memcpy(buf, data + readpos, len);
		readpos += len;
		return len;
	}

	void WriteByte(unsigned char val)
	{
		if (writepos >= maxlen)
		{
			badread = true;
			return;
		}
		data[writepos++] = val;
	}

	void WriteUShort(unsigned short v)
	{
		WriteByte(v>>0);
		WriteByte(v>>8);
	};
	void WriteSShort(signed short v)
	{
		WriteByte(v>>0);
		WriteByte(v>>8);
	};
	void WriteULong(unsigned int v)
	{
		WriteByte(v>>0);
		WriteByte(v>>8);
		WriteByte(v>>16);
		WriteByte(v>>24);
	};
	void WriteSLong(signed int v)
	{
		WriteByte(v>>0);
		WriteByte(v>>8);
		WriteByte(v>>16);
		WriteByte(v>>24);
	};
	void WriteFloat(float v)
	{
		union 
		{
			unsigned int i;
			float f;
		} u;
		u.f = v;
		WriteULong(u.i);
	};

	void WriteString(const char *string)
	{
		while(*string)
			WriteByte(*string++);
		WriteByte(0);
	}

	void WriteData(unsigned char *buf, unsigned int len)
	{
		unsigned int catlen = len;
		if (writepos + catlen > maxlen)
		{
			catlen = maxlen - writepos;
			badread = true;
		}
		memcpy(data+writepos, buf, catlen);
		writepos += catlen;
	}
	void WriteBuf(netbuf *other)
	{
		WriteData(other->data + other->readpos, other->writepos - other->readpos);
	}
};

class netcon
{
public:
	virtual void Send(const netbuf *buf, const netpeer *dest) = NULL;
	virtual bool Recv(netbuf *buf, netpeer *from) = NULL;

	static class netcon *Net_Establish(class netpeer *peer);
};
