#include "common.h"
#include "net.h"

#include <winsock2.h>
#include <ws2tcpip.h>

#ifndef IPV6_V6ONLY
# define IPV6_V6ONLY 27
#endif

class netcon_udp : public netcon
{
	void Send(const netbuf *buf, const netpeer *dest)
	{
		sendto(sock, (char*)buf->data, buf->writepos, 0, (sockaddr*)&dest->storage, dest->addrlen);
	}
	bool Recv(netbuf *buf, netpeer *from)
	{
		from->addrlen = sizeof(from->storage);
		int len = recvfrom(sock, (char*)buf->data, buf->maxlen, 0, (sockaddr*)&from->storage, (int*)&from->addrlen);
		if (len == -1)
			return false;

		buf->Reset();
		buf->writepos = len;
		from->demofile = false;
		return true;
	}

	SOCKET sock;
public:
	netcon_udp(int af)
	{
		int v6only = true;
		u_long nonblock = true;
		sock = socket(af, SOCK_DGRAM, IPPROTO_UDP);
		ioctlsocket(sock,FIONBIO,&nonblock);
		if (af == AF_INET6)
			setsockopt(sock, IPPROTO_IPV6, IPV6_V6ONLY, (char*)&v6only, sizeof(v6only));
//		bind(sock, (struct sockaddr*)&addr->storage, sizeof(sockaddr_in6));
	}
};

/*
class netcon *UDP_Create(const char *localip, short port)
{
	return new netcon_udp(localip, port);
}
*/

#ifdef _WIN32
class omgwtfbbq
{
public: omgwtfbbq(void)
	{
		WSADATA barf;
		WSAStartup(1 | (1<<8), &barf);
	}
} cheezburgerz;
#endif

bool netpeer::Resolve(const char *peername, int defaultport)
{
	addrinfo hints;
	if (!strncmp(peername, "demo:", 5))
	{
		demofile = true;
		memcpy(storage, peername+5, sizeof(storage)-1);
		return true;
	}
	demofile = false;
	memset(&hints, 0, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_flags = AI_PASSIVE;
	hints.ai_protocol = IPPROTO_UDP;

	addrinfo *res;

	int status;
	if (*peername == '[')
	{	//yay! ipv6 addresses
		char *end = strrchr((char*)peername, ']');
		if (!end)
			status = -1;
		else
		{
			*end = 0;
			if (end[1] == ':')
				status = getaddrinfo(peername+1, end+2, &hints, &res);
			else
				status = getaddrinfo(peername+1, "26000", &hints, &res);
			*end = ']';
		}
	}
	else
	{
		char *end = strrchr((char*)peername, ':');
		if (end)
		{
			*end = 0;
			status = getaddrinfo(peername, end+1, &hints, &res);
			*end = ':';
		}
		else
			status = getaddrinfo(peername, "26000", &hints, &res);
	}
	if (status)
	{
		Com_Printf(PRINT_WARNING, "Unable to resolve %s: %s\n", peername, gai_strerror(status));
		return false;
	}
	memcpy(storage, res->ai_addr, res->ai_addrlen);
	addrlen = (unsigned int)res->ai_addrlen;

	return true;
}
bool netpeer::ForcePort(int newport)
{
	newport = htons(newport);
	if (((sockaddr*)storage)->sa_family == AF_INET6)
		((sockaddr_in6*)storage)->sin6_port = newport;
	else if (((sockaddr*)storage)->sa_family == AF_INET)
		((sockaddr_in*)storage)->sin_port = newport;
	else
		return false;
	return true;
}


#include "filesystem.h"
class netcon_demo : public netcon
{
	file *file;

	void Send(const netbuf *buf, const netpeer *dest)
	{
	}
	bool Recv(netbuf *buf, netpeer *from)
	{
		unsigned int packetsize;
		from->demofile = false;

		if (!file)	//failed to open?
			return false;
		if (sizeof(packetsize) != file->read(&packetsize, sizeof(packetsize)))
			return false;	//fatal

		packetsize += 12;	//nq demos are messed up...

		from->demofile = true;
		file->read(buf->data, packetsize);

		buf->Reset();
		buf->writepos = packetsize;
		return true;
	}

public:
	netcon_demo(const char *filename)
	{
		char nl;
		file = FS_OpenRFile(filename);
		if (file)
		{
			//nq demos have a shitty text track name prefix that we need to ignore.
			while (file->read(&nl, sizeof(nl)))
			{
				if (nl == '\n')
					break;
			}
		}
	}
};



class netcon *netcon::Net_Establish(class netpeer *peer)
{
	if (peer->demofile)
		return new netcon_demo((const char*)peer->storage);
	else
		return new netcon_udp(((sockaddr*)peer->storage)->sa_family);
}