#ifndef __RENDERER_H__
#define __RENDERER_H__

//#include "../client/client.h"
//#include "cvar.h"

//extern cvar vid_width;
//extern cvar vid_height;
//extern cvar vid_bpp;
//extern cvar vid_fullscreen;

//typedef struct 

typedef void *texture_t;

struct rentity_t
{
	matrix4x4 matrix;

	unsigned int skinnum;
	float skintime;

	int anim[2];
	float animtime[2];
	float animweight[2];
};
#define MAX_LIGHTSTYLES 256
struct rstate_t
{
	int mode;
	matrix4x4 viewmatrix;	//angles and view origin
	matrix4x4 projectionmatrix;
	matrix4x4 viewproj;
	float time;

	float lmscale[256];

	frustum_c frustum;

	vec fovx, fovy;	//field of view, for frustrum culling
//	int rectwidth, rectheight, rectx, recty;	//view positions

//	rentity_t *rents;
//	unsigned int numrents;
	vec3 vieworigin;
};

const char *GetBSPModeDesc(int modenum);

struct gmaterials_s;

class model_c
{
public:
	virtual ~model_c() {};
	virtual void DrawEntity(rentity_t *entity, rstate_t *scene) = NULL;
	virtual model_c *GetSubmodel(unsigned int idx) {return NULL;}
	float cullradius;	//should be 64 or something.

	const char *name;
	model_c *next;
};

typedef struct {
	int *indicies;
	unsigned int numindicies;
	unsigned int numverts;
	vec3 *verts;
	vec2 *texcoords;
	vec2 *lmtexcoords;

	texture_t lm_gltexnum;
} mesh_t;

typedef struct {
	char name[256];
	int age;

	int numtextmus;
	int numsurftmus;
	texture_t textmu[4];

	void *surfchain;
} shader_t;

class modeltype;
extern modeltype *modeltypes;
class modeltype
{
public:
	modeltype *next;
	unsigned int ident;
	const char *identwords;
	model_c *(*LoadFunc)(const char *name, unsigned char *baseptr, unsigned int len);
	const char *description;
	modeltype(unsigned int ident, model_c *(*LoadFunc)(const char *name, unsigned char *baseptr, unsigned int len), const char *description)
	{
		this->ident = ident;
		this->identwords = NULL;
		this->LoadFunc = LoadFunc;
		this->description = description;
		this->next = modeltypes;
		modeltypes = this;
	}
	modeltype(const char *identwords, model_c *(*LoadFunc)(const char *name, unsigned char *baseptr, unsigned int len), const char *description)
	{
		this->ident = 0;
		this->identwords = identwords;
		this->LoadFunc = LoadFunc;
		this->description = description;
		this->next = modeltypes;
		modeltypes = this;
	}
};

model_c *R_Model_Get(const char *name);

void GL_FlushModels(void);
void GL_PurgeModels(void);

#endif

