#define VK_USE_PLATFORM_WIN32_KHR
#define VK_NO_PROTOTYPES
#include <vulkan/vulkan.h>

extern VkInstance vkinstance;

//funcs needed for creating an instance
#define VKInstFuncs \
	VKFunc(EnumerateInstanceLayerProperties)		\
	VKFunc(EnumerateInstanceExtensionProperties)	\
	VKFunc(CreateInstance)	

//funcs specific to an instance
#define VKInst2Funcs \
	VKFunc(EnumeratePhysicalDevices)				\
	VKFunc(GetPhysicalDeviceProperties)				\
	VKFunc(GetPhysicalDeviceQueueFamilyProperties)	\
	VKFunc(GetPhysicalDeviceSurfaceSupportKHR)		\
	VKFunc(GetPhysicalDeviceSurfaceFormatsKHR)		\
	VKFunc(GetPhysicalDeviceSurfacePresentModesKHR)	\
	VKFunc(GetPhysicalDeviceSurfaceCapabilitiesKHR)	\
	VKFunc(GetPhysicalDeviceMemoryProperties)		\
	VKFunc(CreateWin32SurfaceKHR)					\
	VKFunc(DestroySurfaceKHR)						\
	VKFunc(CreateDevice)							\
	VKFunc(DestroyInstance)

//funcs specific to a device
#define VKDevFuncs \
	VKFunc(AcquireNextImageKHR)			\
	VKFunc(QueuePresentKHR)				\
	VKFunc(CreateSwapchainKHR)			\
	VKFunc(GetSwapchainImagesKHR)		\
	VKFunc(DestroySwapchainKHR)			\
	VKFunc(CmdBeginRenderPass)			\
	VKFunc(CmdEndRenderPass)			\
	VKFunc(CmdBindPipeline)				\
	VKFunc(CmdDrawIndexedIndirect)		\
	VKFunc(CmdDraw)						\
	VKFunc(CmdDrawIndexed)				\
	VKFunc(CmdSetViewport)				\
	VKFunc(CmdSetScissor)				\
	VKFunc(CmdBindDescriptorSets)		\
	VKFunc(CmdBindIndexBuffer)			\
	VKFunc(CmdBindVertexBuffers)		\
	VKFunc(CmdPushConstants)			\
	VKFunc(CmdClearColorImage)			\
	VKFunc(CmdCopyImage)				\
	VKFunc(CmdCopyBuffer)				\
	VKFunc(CmdBlitImage)				\
	VKFunc(CmdPipelineBarrier)			\
	VKFunc(CreateDescriptorSetLayout)	\
	VKFunc(DestroyDescriptorSetLayout)	\
	VKFunc(CreatePipelineLayout)		\
	VKFunc(DestroyPipelineLayout)		\
	VKFunc(CreateShaderModule)			\
	VKFunc(DestroyShaderModule)			\
	VKFunc(CreateGraphicsPipelines)		\
	VKFunc(DestroyPipeline)				\
	VKFunc(QueueSubmit)					\
	VKFunc(QueueWaitIdle)				\
	VKFunc(DeviceWaitIdle)				\
	VKFunc(BeginCommandBuffer)			\
	VKFunc(EndCommandBuffer)			\
	VKFunc(DestroyDevice)				\
	VKFunc(GetDeviceQueue)				\
	VKFunc(GetBufferMemoryRequirements)	\
	VKFunc(GetImageMemoryRequirements)	\
	VKFunc(GetImageSubresourceLayout)	\
	VKFunc(CreateFramebuffer)			\
	VKFunc(DestroyFramebuffer)			\
	VKFunc(CreateCommandPool)			\
	VKFunc(ResetCommandPool)			\
	VKFunc(DestroyCommandPool)			\
	VKFunc(CreateDescriptorPool)		\
	VKFunc(ResetDescriptorPool)			\
	VKFunc(DestroyDescriptorPool)		\
	VKFunc(AllocateDescriptorSets)		\
	VKFunc(CreateSampler)				\
	VKFunc(DestroySampler)				\
	VKFunc(CreateImage)					\
	VKFunc(DestroyImage)				\
	VKFunc(CreateBuffer)				\
	VKFunc(DestroyBuffer)				\
	VKFunc(AllocateMemory)				\
	VKFunc(FreeMemory)					\
	VKFunc(BindBufferMemory)			\
	VKFunc(BindImageMemory)				\
	VKFunc(MapMemory)					\
	VKFunc(UnmapMemory)					\
	VKFunc(UpdateDescriptorSets)		\
	VKFunc(AllocateCommandBuffers)		\
	VKFunc(FreeCommandBuffers)			\
	VKFunc(CreateRenderPass)			\
	VKFunc(DestroyRenderPass)			\
	VKFunc(CreateSemaphore)				\
	VKFunc(DestroySemaphore)			\
	VKFunc(CreateFence)					\
	VKFunc(ResetFences)					\
	VKFunc(GetFenceStatus)				\
	VKFunc(WaitForFences)				\
	VKFunc(CreateImageView)				\
	VKFunc(DestroyImageView)			\
	VKFunc(DestroyFence)				\


//all vulkan funcs
#define VKFuncs \
	VKInstFuncs		\
	VKInst2Funcs	\
	VKDevFuncs		\
	VKFunc(GetInstanceProcAddr)\
	VKFunc(GetDeviceProcAddr)


#ifdef VK_NO_PROTOTYPES
	#define VKFunc(n) extern PFN_vk##n pvk##n;
	VKFuncs
	#undef VKFunc
#else
	#define VKFunc(n) static const PFN_vk##n pvk##n = vk##n;
	VKFuncs
	#undef VKFunc
#endif

extern VkCommandBuffer vkmaincmd;
extern VkDevice vkdevice;
extern VkRenderPass vkrenderpass;
extern uint32_t vkqueueidx[2];
extern VkPhysicalDeviceMemoryProperties vk_memory_properties;
typedef struct
{
	VkImage image;
	VkImageView imageView;
	VkSampler sampler;
	VkDeviceMemory memory;
	uint32_t width;
	uint32_t height;
	uint32_t mips;
} vk_image_t;
typedef struct
{
	VkBuffer buffer;
	VkDeviceMemory memory;
	size_t size;
	size_t alignment;
	bool hostvisible;

} vk_buffer_t;
vk_image_t CreateTexture2DArray(uint32_t width, uint32_t height, uint32_t layers, uint32_t mips);						//create a new texture. woot.
void CreateTextureSampler(vk_image_t *image, bool linear, bool repeat);
void FillTextureSync(vk_image_t target, uint32_t width, uint32_t height, uint32_t layer, uint32_t mip, void *data);	//inefficiently fill a texture.
void DestroyTexture(vk_image_t *image);

vk_buffer_t CreateBuffer(size_t length, uint32_t usage, bool dynamic);
void FillBufferSync(vk_buffer_t *target, size_t offset, size_t length, void *data);
void DestroyBuffer(vk_buffer_t *image);

extern unsigned char spv_world_vert[];
extern unsigned char spv_world_frag[];
extern unsigned char spv_model_vert[];
extern unsigned char spv_model_frag[];
VkShaderModule LoadShaderCode(const char *filename, const unsigned char *blob);
#define VkAssert(f) do {VkResult err = f; if (err) Sys_Error("%s == %i", #f, err); } while(0)

#define vkallocationcb ((VkAllocationCallbacks *)NULL)
