#version 450

//specialisations (aka: ubershaders)
layout(constant_id = 0) const int surfacetype = 0;

//uniforms
layout(std140, location = 0) uniform foobar
{
	mat4 mat_vp;
	vec4 style[256];
	vec3 eyepos;
	float time;
};

//input varyings
layout(location = 0) in vec4 tc;
layout(location = 1) flat in ivec3 mat;
layout(location = 2) flat in vec4 styles;

//samplers
layout (set=0, binding=1) uniform sampler2DArray lightmaps;
layout (set=1, binding=0) uniform sampler2DArray worldtex;

//outputs
layout(location = 0) out vec4 result;

//the actual code
void main()
{
	if (surfacetype == 2)
	{	//sky
		vec3 dir = tc.xyz - eyepos.xyz;
		dir.z *= 3.0;
		dir.xy /= 0.5*length(dir);
		vec3 btc = vec3(dir.xy + time*0.03125, mat.y);
		result = texture(worldtex, btc);
		vec3 ctc = vec3(dir.xy + time*0.0625, mat.y+1);
		vec4 clouds = texture(worldtex, ctc);
		result.rgb = (result.rgb*(1.0-clouds.a)) + clouds.rgb;
	}
	else if (surfacetype == 1)
	{	//turb
		vec3 ntc;
		ntc.s = tc.s + sin(tc.t+time)*0.125;
		ntc.t = tc.t + sin(tc.s+time)*0.125;
		ntc.p = mat.y;
		result = texture(worldtex, ntc);
	}
	else
	{	//regular wall
		result = vec4(dot(styles, texture(lightmaps, vec3(tc.ba, mat.x))).rrr, 1.0);
		result *= texture(worldtex, vec3(tc.rg, mat.y));
	}
}