#version 450

//specialisations (aka: ubershaders)
layout(constant_id = 0) const int surfacetype = 0;

//uniforms
layout(push_constant) uniform pushintf
{	//push constants ease streaming issues.
	mat4 mat_m;	
} push;
layout(std140, location = 0) uniform foobar
{
	mat4 mat_vp;
	vec4 style[256];
	vec3 eyepos;
	float time;
};

//attributes
layout(location = 0) in vec3 v_position;
layout(location = 1) in ivec3 v_material;
layout(location = 2) in vec4 v_texcoords;
layout(location = 3) in uvec4 v_lightstyle;

//varyings
layout(location = 0) out vec4 tc;
layout(location = 1) flat out ivec3 mat;
layout(location = 2) flat out vec4 styles;

void main()
{
//	int id = gl_VertexIndex;
	gl_Position = mat_vp * (push.mat_m * vec4(v_position,1.0));
	mat = v_material;

	if (surfacetype == 2)
	{
		tc = vec4(v_position, 1.0);
		styles = vec4(0.0);
	}
	else if (surfacetype == 1)
	{
		tc = v_texcoords;
		styles = vec4(0.0);
	}
	else
	{
		tc = v_texcoords;	
		styles.r = style[v_lightstyle.r].r;
		styles.g = style[v_lightstyle.g].r;
		styles.b = style[v_lightstyle.b].r;
		styles.a = style[v_lightstyle.a].r;
	}

	gl_Position.y *= -1;
}
