# QuakeEd for MacOS
### v 1.0.2

## Setup instructions

While QuakeEd is a standalone MacOS application, it still requires that some directories are in place in your system to operate correctly. Also, the tools that are required to generate BSP files from your maps are expected to be present at a convenient location for the operating system to find. Lastly, while you are free to open map files from anywhere in your machine, in order to generate BSP files properly, there is a strict file and directory structure that your map and asset files are expected to follow so the tools can do their job properly.

Before opening the application for the first time, go to Terminal and run:

        cd /
        mkdir /qcache
        chmod 777 /qcache

to ensure that there is a /qcache directory in your system ready for the tool to use.

After that, locate the following files in the package you just downloaded:

        qbsp
        light
        vis
        fakewad
        leechwad

These are the command-line tools needed by QuakeEd to generate BSP files (save for one, see below). Go to Terminal and run:

        cd /usr/local/bin
        cp /path/to/your/quakeed/package/directory/qbsp .
        cp /path/to/your/quakeed/package/directory/light .
        cp /path/to/your/quakeed/package/directory/vis .
        cp /path/to/your/quakeed/package/directory/fakewad .
        cp /path/to/your/quakeed/package/directory/leechwad .

Ensure that the command-line tools you just copied have execute permissions (if needed, use the chmod command above to do so).

You are free to place these files anywhere else in your system. If you do so, however, make a note of the path, since you'll need to modify your project file to make use of that path (see below.)

Now, double click on QuakeEd. The first time you run QuakeEd, it will ask you for the location of a .qpr file (the aforementioned project file). Locate the *test_maps* directory in the package you downloaded, place it somewhere nice in your system, and specify the quake.qpr file in that directory to QuakeEd at the prompt.

If this is indeed your first time, then before doing anything else, please go to Preferences in QuakeEd (either by choosing Preferences in the menu, or selecting Preferences in the pop up list at the top left corner of the application) and press the button labeled "current" next to "Startup project". It is also recommended checking the "Show BSP Output while BSPing" box below it. After that (and this is very important), *close the app* then *open it again*. This works around a bug in the original application that doesn't allow you to open maps in the project if you just set up the project location for the first time ever.

QuakeEd will remember the project location path, so next time you open the application, you don't have to specify the path again. At this point, you should be able to open the single "jrbase1" map file in the list of Maps (accessible from the Maps option in the pop up list) by selecting it directly from the file. You should also be able to open maps anywhere in your system ("Open" in the Menu), and even open other projects if required ("Open Project" in the Menu). 

Please notice that, if you open a .map file from anywhere else in your system, QuakeEd will expect that any .wad files referenced by it can be opened. If they can´t be found, a message will appear telling you exactly where the .wad file was expected to be in your system, and will close immediately.

## BSP generation

QuakeEd can generate BSP files from your maps, provided that the following directory structure is present for them:

        your_project_directory
        |-- "quake"
        |----- your_game_directory
        |-------- "gfx"
        |----------- all_your_wad_files.wad
        |-------- "maps"
        |----------- all_your_map_files.map
        |-------- "progs"
        |----------- all_your_programs.qc
        |----------- all_your_models.mdl
        |-------- your_project_file.qpr

The project file, itself a text file, contains the exact commands that are sent to your system when generating the various types of BSPs using QuakeEd. If you placed the command-line tools *qbsp*, *light* and *vis* in a directory other than /usr/local/bin, then you will need to edit manually the project file in your favorite text editor to specify the new path to the tools.

After that, you should be ready to generate the BSP files. The available options are in the BSP menu in the application: Entities only, Relight, Full / Fast / No visibility. If you checked the "Show BSP Output while BSPing" option in Preferences, the output of the tools will be shown automatically in the panel at the right side of the application.

You might find that the BSP generation process starts, but then doesn´t seem to stop - or report anything after a few seconds after it starts. If that happens, please check that the bsp, light and vis tools are running correctly, by opening Terminal and attempt to run them without any arguments. You should be able to see a descriptive message explaining the arguments that must be passed for each upon doing it. Any other message might mean that the tools cannot be run in your system, possibly because of security restrictions or an expired distribution certificate - in that case, look up for the latest version of the tools and install them again.

Due to what can be considered a bug in the original source code of QuakeEd, if your .map file contains entities whose classnames reference programs that are not actually present in the /progs folder in the directory structure above, those entities will instead be generated as static brushes with no special behavior - and if there are more than 256 of them, BSP generation will inevitably fail.

## Running generated maps

Included with the package is a copy of Quake_OSX, a software-rendered, Metal-presented version of Quake you can fully play - provided you specify the required game files to it. In order to test your newly generated BSP file, open Terminal and run:

        cd /path/to/your/Quake_OSX/application/executable
        open Quake_OSX.app --args -basedir "/path/to/your_project_directory/quake" -game your_game_directory

Be sure to have a copy of the ID1 folder containing the shareware / registered pakfiles in that path, right next to your_game_directory. The directory structure should look like this:

        your_project_directory
        |-- "quake"
        |----- "ID1"
        |-------- "PAK0.PAK"
        |-------- PAK{other_pak_files}.PAK
        |-------- "config.cfg"
        |----- your_game_directory
        |-------- "gfx"
        |----------- all_your_wad_files.wad
        |-------- "maps"
        |----------- all_your_map_files.bsp
        |-------- "progs"
        |----------- all_your_programs.qc
        |----------- all_your_models.mdl

Once you're in the game, go to the console (press the ~ key), then write:

        map your_map_file

And watch your map come to life. The test_maps directory in the package you just downloaded contains a suitable project for you to test this functionality.

### fakewad and leechwad

When QuakeEd opens a map file, it searches for any .wad files specified in it, according to the directory structure shown above; if the file(s) are not present, an error will be displayed on screen and the application will close. That's expected behavior from the original source code of QuakeEd. 

In order to ease the process of opening map files from other sources, two new command-line tools, *fakewad* and *leechwad*, were created. 

*fakewad* accepts an input .map file and creates an output .wad file containing the palette and miptex lumps required for QuakeEd to display and modify the .map file correctly. The palette lump is essentially a copy of the original Quake palette, and the miptex lumps are textures with a simple design with squares, colored from specific 16-value rows from the generated palette, selected entirely at random.

*leechwad*, in the other hand, can be used if you have a copy of the PAK0/1/2.PAK files available from the original engine, and your .map file references one or more miptex lumps present in any of the game levels in it. The utility will extract the miptex lumps from the pakfile and add them to the newly generated .wad file.

To run the tools, open Terminal and run either:

        fakewad input_map_file.map output_wad_file.wad

or

        leechwad input_map_file.map /path/to/your/ID1/PAKwhatever.PAK output_wad_file.wad
        
Then, copy the newly generated .wad file under the "gfx" directory in the structure above, ensuring also that the map file is below "maps". QuakeEd should now be able to open the map file correctly.
