
#include "cmdlib.h"
#include "mathlib.h"
#include "bspfile.h"
#include "heapmem.h"
#include "winui.h"

typedef struct surfinfo_s
{
	// offset into lightdata
	int lightofs;

	// size of light data for this surf
	int size;

	// stored at generation time
	byte *light1;
	byte *light3;
} surfinfo_t;

surfinfo_t *surfinfo = NULL;

void BuildSurfInfo (void)
{
}


void SetupSurfLightInfo (int surfnum, int offset, int size)
{
}


byte *SurfGetLight1 (int surfnum)
{
	return NULL;
}


byte *SurfGetLight3 (int surfnum)
{
	return NULL;
}


void WriteLight1 (byte *buf)
{
}


void WriteLight3 (byte *buf)
{
}


int compiledlightsize = 0;

int GetLightOffset (int size)
{
	return 0;
}


int GetCachedLightOffset (int surfnum)
{
	return 0;
}


//=============================================================================

int			nummodels;
dmodel_t	*dmodels;

int			visdatasize;
byte		*dvisdata;

int			lightdatasize;
byte		*dlightdata;

int			lightdatasize3;
byte		*dlightdata3;

int			texdatasize;
byte		*dtexdata; // (dmiptexlump_t)

int			entdatasize;
char		*dentdata;

int			numleafs;
dleaf_t		*dleafs;

int			numplanes;
dplane_t	*dplanes;

int			numvertexes;
dvertex_t	*dvertexes;

int			numnodes;
dnode_t		*dnodes;

int			numtexinfo;
texinfo_t	*texinfo;

int			numfaces;
dface_t		*dfaces;

int			numclipnodes;
dclipnode_t	*dclipnodes;

int			numedges;
dedge_t		*dedges;

int			nummarksurfaces;
unsigned short		*dmarksurfaces;

int			numsurfedges;
int			*dsurfedges;

//=============================================================================

/*
=============
SwapBSPFile

Byte swaps all data in a bsp file.
=============
*/
void SwapBSPFile (qboolean todisk)
{
	int				i, j, c;
	dmodel_t		*d;
	dmiptexlump_t	*mtl;

	
// models	
	for (i=0 ; i<nummodels ; i++)
	{
		d = &dmodels[i];

		for (j=0 ; j<MAX_MAP_HULLS ; j++)
			d->headnode[j] = LittleLong (d->headnode[j]);

		d->visleafs = LittleLong (d->visleafs);
		d->firstface = LittleLong (d->firstface);
		d->numfaces = LittleLong (d->numfaces);
		
		for (j=0 ; j<3 ; j++)
		{
			d->mins[j] = LittleFloat(d->mins[j]);
			d->maxs[j] = LittleFloat(d->maxs[j]);
			d->origin[j] = LittleFloat(d->origin[j]);
		}
	}

//
// vertexes
//
	for (i=0 ; i<numvertexes ; i++)
	{
		for (j=0 ; j<3 ; j++)
			dvertexes[i].point[j] = LittleFloat (dvertexes[i].point[j]);
	}
		
//
// planes
//	
	for (i=0 ; i<numplanes ; i++)
	{
		for (j=0 ; j<3 ; j++)
			dplanes[i].normal[j] = LittleFloat (dplanes[i].normal[j]);
		dplanes[i].dist = LittleFloat (dplanes[i].dist);
		dplanes[i].type = LittleLong (dplanes[i].type);
	}
	
//
// texinfos
//	
	for (i=0 ; i<numtexinfo ; i++)
	{
		for (j=0 ; j<8 ; j++)
			texinfo[i].vecs[0][j] = LittleFloat (texinfo[i].vecs[0][j]);
		texinfo[i].miptex = LittleLong (texinfo[i].miptex);
		texinfo[i].flags = LittleLong (texinfo[i].flags);
	}
	
//
// faces
//
	for (i=0 ; i<numfaces ; i++)
	{
		dfaces[i].texinfo = LittleShort (dfaces[i].texinfo);
		dfaces[i].planenum = LittleShort (dfaces[i].planenum);
		dfaces[i].side = LittleShort (dfaces[i].side);
		dfaces[i].lightofs = LittleLong (dfaces[i].lightofs);
		dfaces[i].firstedge = LittleLong (dfaces[i].firstedge);
		dfaces[i].numedges = LittleShort (dfaces[i].numedges);
	}

//
// nodes
//
	for (i=0 ; i<numnodes ; i++)
	{
		dnodes[i].planenum = LittleLong (dnodes[i].planenum);
		for (j=0 ; j<3 ; j++)
		{
			dnodes[i].mins[j] = LittleShort (dnodes[i].mins[j]);
			dnodes[i].maxs[j] = LittleShort (dnodes[i].maxs[j]);
		}
		dnodes[i].children[0] = LittleShort (dnodes[i].children[0]);
		dnodes[i].children[1] = LittleShort (dnodes[i].children[1]);
		dnodes[i].firstface = LittleShort (dnodes[i].firstface);
		dnodes[i].numfaces = LittleShort (dnodes[i].numfaces);
	}

//
// leafs
//
	for (i=0 ; i<numleafs ; i++)
	{
		dleafs[i].contents = LittleLong (dleafs[i].contents);
		for (j=0 ; j<3 ; j++)
		{
			dleafs[i].mins[j] = LittleShort (dleafs[i].mins[j]);
			dleafs[i].maxs[j] = LittleShort (dleafs[i].maxs[j]);
		}

		dleafs[i].firstmarksurface = LittleShort (dleafs[i].firstmarksurface);
		dleafs[i].nummarksurfaces = LittleShort (dleafs[i].nummarksurfaces);
		dleafs[i].visofs = LittleLong (dleafs[i].visofs);
	}

//
// clipnodes
//
	for (i=0 ; i<numclipnodes ; i++)
	{
		dclipnodes[i].planenum = LittleLong (dclipnodes[i].planenum);
		dclipnodes[i].children[0] = LittleShort (dclipnodes[i].children[0]);
		dclipnodes[i].children[1] = LittleShort (dclipnodes[i].children[1]);
	}

//
// miptex
//
	if (texdatasize)
	{
		mtl = (dmiptexlump_t *)dtexdata;
		if (todisk)
			c = mtl->nummiptex;
		else
			c = LittleLong(mtl->nummiptex);
		mtl->nummiptex = LittleLong (mtl->nummiptex);
		for (i=0 ; i<c ; i++)
			mtl->dataofs[i] = LittleLong(mtl->dataofs[i]);
	}
	
//
// marksurfaces
//
	for (i=0 ; i<nummarksurfaces ; i++)
		dmarksurfaces[i] = LittleShort (dmarksurfaces[i]);

//
// surfedges
//
	for (i=0 ; i<numsurfedges ; i++)
		dsurfedges[i] = LittleLong (dsurfedges[i]);

//
// edges
//
	for (i=0 ; i<numedges ; i++)
	{
		dedges[i].v[0] = LittleShort (dedges[i].v[0]);
		dedges[i].v[1] = LittleShort (dedges[i].v[1]);
	}
}


dheader_t	*header;

int LoadLump (int lump, void **dest, int size)
{
	int	length;
	int ofs;

	length = header->lumps[lump].filelen;
	ofs = header->lumps[lump].fileofs;

	if (length % size)
		Error ("LoadBSPFile: funny lump size");

	if (!length)
	{
		// no data
		*dest = NULL;
		return 0;
	}

	// alloc dynamically
	*dest = QHeap_Alloc (length);

	memcpy (*dest, (byte *) header + ofs, length);
	StepProgressBar ();

	return length / size;
}


/*
=============
LoadBSPFile
=============
*/
void LoadSpecificFileFromSpecificPAK (char *pakname, char *filename, void **buffer);

void LoadBSPFile (char *filename)
{
	int i;

	// hack - identify files we couldn't load
	numfaces = -1;

	// load the file header
	if (LoadFile (filename, (void **) &header) == -1)
	{
		header = NULL;

		// assume a PAK file - try to find the name of it
		for (i = 0; ; i++)
		{
			// out of space!
			if (!filename[i]) return;

			// look for '.PAK' delimiter
			if (!strnicmp (&filename[i], ".PAK\\", 5))
			{
				char pakname[256];

				// make the name of the PAK
				strcpy (pakname, filename);
				pakname[i + 4] = 0;

				// validate that this is a pak file
				if (!ValidatePack (pakname)) continue;

				// attempt to load it
				LoadSpecificFileFromSpecificPAK (pakname, &filename[i + 5], (void **) &header);

				break;
			}
		}

		if (!header) return;
	}

	// swap the header
	for (i = 0; i < sizeof (dheader_t) / 4; i++)
		((int *) header)[i] = LittleLong (((int *) header)[i]);

	if (header->version != BSPVERSION)
		Error ("%s is version %i, not %i", filename, i, BSPVERSION);

	SetupProgressBar (0, HEADER_LUMPS);
	UpdateProgressNotify ("\r\nLoading BSP...\r\n");

	// only use as much memory as we need (also removes restrictions)
	nummodels = LoadLump (LUMP_MODELS, &dmodels, sizeof (dmodel_t));
	numvertexes = LoadLump (LUMP_VERTEXES, &dvertexes, sizeof (dvertex_t));
	numplanes = LoadLump (LUMP_PLANES, &dplanes, sizeof (dplane_t));
	numleafs = LoadLump (LUMP_LEAFS, &dleafs, sizeof (dleaf_t));
	numnodes = LoadLump (LUMP_NODES, &dnodes, sizeof (dnode_t));
	numtexinfo = LoadLump (LUMP_TEXINFO, &texinfo, sizeof (texinfo_t));
	numclipnodes = LoadLump (LUMP_CLIPNODES, &dclipnodes, sizeof (dclipnode_t));
	numfaces = LoadLump (LUMP_FACES, &dfaces, sizeof (dface_t));
	nummarksurfaces = LoadLump (LUMP_MARKSURFACES, &dmarksurfaces, sizeof (dmarksurfaces[0]));
	numsurfedges = LoadLump (LUMP_SURFEDGES, &dsurfedges, sizeof (dsurfedges[0]));
	numedges = LoadLump (LUMP_EDGES, &dedges, sizeof (dedge_t));

	texdatasize = LoadLump (LUMP_TEXTURES, &dtexdata, 1);
	visdatasize = LoadLump (LUMP_VISIBILITY, &dvisdata, 1);
	entdatasize = LoadLump (LUMP_ENTITIES, &dentdata, 1);
	lightdatasize = LoadLump (LUMP_LIGHTING, &dlightdata, 1);

	if (!lightdatasize)
	{
		// lightdata is required to be present
		Error ("%s has no light data", filename);
		return;
	}

	// expand to 3 component
	lightdatasize3 = 3 * lightdatasize;
	dlightdata3 = (byte *) QHeap_Alloc (lightdatasize3);

	for (i = 0; i < lightdatasize; i++)
	{
		dlightdata3[i * 3 + 0] = dlightdata[i];
		dlightdata3[i * 3 + 1] = dlightdata[i];
		dlightdata3[i * 3 + 2] = dlightdata[i];
	}

	// swap everything
	SwapBSPFile (false);

	// cache the surface info for use and/or comparison during generation of a LIT
	BuildSurfInfo ();

	// size of new compiled lightmap
	compiledlightsize = 0;
}

//============================================================================

FILE		*wadfile;
dheader_t	outheader;

void AddLump (int lumpnum, void *data, int len)
{
	lump_t *lump;

	lump = &header->lumps[lumpnum];

	lump->fileofs = LittleLong( ftell(wadfile) );
	lump->filelen = LittleLong(len);
	SafeWrite (wadfile, data, (len+3)&~3);
}

/*
=============
WriteBSPFile

Swaps the bsp file in place, so it should not be referenced again
=============
*/
void WriteBSPFile (char *filename)
{
	// does nothing as we no longer write the BSP out
}


//============================================================================

/*
=============
PrintBSPFileSizes

Dumps info about current file
=============
*/
void PrintBSPFileSizes (void)
{
	UpdateProgressNotify ("%5i planes       %6i\r\n"
		,numplanes, (int)(numplanes*sizeof(dplane_t)));
	UpdateProgressNotify ("%5i vertexes     %6i\r\n"
		,numvertexes, (int)(numvertexes*sizeof(dvertex_t)));
	UpdateProgressNotify ("%5i nodes        %6i\r\n"
		,numnodes, (int)(numnodes*sizeof(dnode_t)));
	UpdateProgressNotify ("%5i texinfo      %6i\r\n"
		,numtexinfo, (int)(numtexinfo*sizeof(texinfo_t)));
	UpdateProgressNotify ("%5i faces        %6i\r\n"
		,numfaces, (int)(numfaces*sizeof(dface_t)));
	UpdateProgressNotify ("%5i clipnodes    %6i\r\n"
		,numclipnodes, (int)(numclipnodes*sizeof(dclipnode_t)));
	UpdateProgressNotify ("%5i leafs        %6i\r\n"
		,numleafs, (int)(numleafs*sizeof(dleaf_t)));
	UpdateProgressNotify ("%5i marksurfaces %6i\r\n"
		,nummarksurfaces, (int)(nummarksurfaces*sizeof(dmarksurfaces[0])));
	UpdateProgressNotify ("%5i surfedges    %6i\r\n"
		,numsurfedges, (int)(numsurfedges*sizeof(dmarksurfaces[0])));
	UpdateProgressNotify ("%5i edges        %6i\r\n"
		,numedges, (int)(numedges*sizeof(dedge_t)));
	if (!texdatasize)
		UpdateProgressNotify ("    0 textures          0\r\n");
	else
		UpdateProgressNotify ("%5i textures     %6i\r\n",((dmiptexlump_t*)dtexdata)->nummiptex, texdatasize);
	UpdateProgressNotify ("      lightdata    %6i\r\n", lightdatasize);
	UpdateProgressNotify ("      visdata      %6i\r\n", visdatasize);
	UpdateProgressNotify ("      entdata      %6i\r\n", entdatasize);
}


FILE *FindFileInSpecificPak (char *pakpath, char *pakname, char *filename);

void GetBSPFileSizes (char *filename, int *sizes)
{
	int i;
	FILE *f;
	dheader_t header;

	if (!(f = fopen (filename, "rb")))
	{
		// assume it's in a PAK and try to get that
		char pakpath[256];
		char *pakname = NULL;
		char *findname = NULL;

		strcpy (pakpath, filename);

		for (i = 0; ; i++)
		{
			// end of string
			if (!pakpath[i]) break;

			// ensure valid comparison
			pakname = NULL;
			findname = NULL;

			// look for '.PAK' delimiter
			if (!strnicmp (&pakpath[i], ".PAK\\", 5))
			{
				int j;
				pakpath[i + 4] = 0;

				// ensure it's a pak
				if (!ValidatePack (pakpath))
				{
					pakpath[i + 4] = '\\';
					continue;
				}

				findname = &pakpath[i + 5];

				for (j = i; j; j--)
				{
					if (pakpath[j] == '\\' || pakpath[j] == '/')
					{
						pakpath[j] = 0;
						pakname = &pakpath[j + 1];
						break;
					}
				}
			}

			// what have we found?
			if (pakname && findname) break;
		}

		// nothing was found
		if (!pakname || !findname) return;

		// try to open it
		if (!(f = FindFileInSpecificPak (pakpath, pakname, findname))) return;

		// flag invalid BSP size as we must construct it ourselves
		sizes[0] = -1;
	}
	else
	{
		// open directly - fill in the size (round to nearest KB)
		fseek (f, 0, SEEK_END);
		sizes[0] = (ftell (f) + 512) / 1024;
		fseek (f, 0, SEEK_SET);
	}

	// get the header
	fread (&header, sizeof (dheader_t), 1, f);

	// validate
	if (header.version != BSPVERSION)
	{
		fclose (f);
		return;
	}

	if (sizes[0] < 0)
	{
		// we read from a PAK so we must construct the size by hand.  NOTE - this may not be 100% accurate,
		// as the BSP spec is accomodating of whitespace in the file... init to the header size
		sizes[0] = sizeof (dheader_t);

		// add the lump sizes
		for (i = 0; i < HEADER_LUMPS; i++)
			sizes[0] += header.lumps[i].filelen;

		// get it to the nearest KB
		sizes[0] = (sizes[0] + 512) / 1024;
	}

	// no entities at the start
	sizes[LUMP_ENTITIES + 1] = 0;

	// read the entities lump (do it this way as we could be reading from a PAK, making SEEK_SET invalid)
	fseek (f, sizeof (dheader_t) * -1, SEEK_CUR);
	fseek (f, header.lumps[LUMP_ENTITIES].fileofs, SEEK_CUR);

	// count of entities
	for (i = 0; i < header.lumps[LUMP_ENTITIES].filelen; i++)
		if (fgetc (f) == '{') sizes[LUMP_ENTITIES + 1]++;

	// done with the file now
	fclose (f);

	// fill in rest of the lump sizes (round to the nearest KB where appropriate)
	// add 1 because index 0 is reserved for the BSP size
	sizes[LUMP_PLANES + 1] = header.lumps[LUMP_PLANES].filelen / sizeof (dplane_t);
	sizes[LUMP_TEXTURES + 1] = (header.lumps[LUMP_TEXTURES].filelen + 512) / 1024;
	sizes[LUMP_VERTEXES + 1] = header.lumps[LUMP_VERTEXES].filelen / sizeof (dvertex_t);
	sizes[LUMP_VISIBILITY + 1] = (header.lumps[LUMP_VISIBILITY].filelen + 512) / 1024;
	sizes[LUMP_NODES + 1] = header.lumps[LUMP_NODES].filelen / sizeof (dnode_t);
	sizes[LUMP_TEXINFO + 1] = header.lumps[LUMP_TEXINFO].filelen / sizeof (texinfo_t);
	sizes[LUMP_FACES + 1] = header.lumps[LUMP_FACES].filelen / sizeof (dface_t);
	sizes[LUMP_LIGHTING + 1] = (header.lumps[LUMP_LIGHTING].filelen + 512) / 1024;
	sizes[LUMP_CLIPNODES + 1] = header.lumps[LUMP_CLIPNODES].filelen / sizeof (dclipnode_t);
	sizes[LUMP_LEAFS + 1] = header.lumps[LUMP_LEAFS].filelen / sizeof (dleaf_t);
	sizes[LUMP_MARKSURFACES + 1] = header.lumps[LUMP_MARKSURFACES].filelen / sizeof (unsigned short);
	sizes[LUMP_EDGES + 1] = header.lumps[LUMP_EDGES].filelen / sizeof (dedge_t);
	sizes[LUMP_SURFEDGES + 1] = header.lumps[LUMP_SURFEDGES].filelen / sizeof (int);
	sizes[LUMP_MODELS + 1] = header.lumps[LUMP_MODELS].filelen / sizeof (dmodel_t);
}

