

#include <windows.h>
#include <stdlib.h>
#include <memory.h>

#define HEAP_BLOCK_STANDARD_SIZE 0x100000

typedef struct heapblock_s
{
	void *mem;
	int size;
	int lowmark;
	struct heapblock_s *next;
} heapblock_t;


heapblock_t *heapblocks = NULL;

int totalheap = 0;

void *QHeap_Alloc (int size)
{
	heapblock_t *hb = NULL;
	int blocksize;

	// allocate on DWORD boundaries
	size = ((size + 3) & ~3);

	if (size < HEAP_BLOCK_STANDARD_SIZE)
	{
		// find a block with space in it
		for (hb = heapblocks; hb; hb = hb->next)
		{
			if (size + hb->lowmark < hb->size)
			{
				// room to fit the memory in here...
				byte *data = ((byte *) hb->mem) + hb->lowmark;
				hb->lowmark += size;
				memset (data, 0, size);

				// gotcha
				return data;
			}
		}
	}

	// not found - alloc a new one
	hb = (heapblock_t *) malloc (sizeof (heapblock_t));

	if (!hb)
	{
		MessageBox (NULL, "Heap_Alloc: Failed", "Error", 0);
		exit (0);
	}

	// link it in
	hb->next = heapblocks;
	heapblocks = hb;

	// always leave soom room in allocated blocks
	blocksize = HEAP_BLOCK_STANDARD_SIZE;

	// ensure that the block is big enough for the requested allocation (with some space left over)
	while (size >= blocksize) blocksize += HEAP_BLOCK_STANDARD_SIZE;

	// track total size
	totalheap += blocksize;

	// fill it in
	hb->mem = malloc (blocksize);
	memset (hb->mem, 0, size);
	hb->size = blocksize;
	hb->lowmark = size;

	// return the memory
	return hb->mem;
}


void *QHeap_666Alloc (int size)
{
	heapblock_t *hb = NULL;

	// allocate on DWORD boundaries
	size = ((size + 3) & ~3);

	// track total size
	totalheap += size;

	// find a free block (this is redundant as there are no free blocks any more)
	/*
	for (hb = heapblocks; hb; hb = hb->next)
	{
		if (!hb->mem)
		{
			// free block, use it (this should never happen???)
			hb->mem = malloc (size);
			memset (hb->mem, 0, size);
			hb->size = size;
			return hb->mem;
		}
	}
	*/

	// not found so create a new one
	hb = (heapblock_t *) malloc (sizeof (heapblock_t));

	if (!hb)
	{
		MessageBox (NULL, "Heap_Alloc: Failed", "Error", 0);
		exit (0);
	}

	// link it in
	hb->next = heapblocks;
	heapblocks = hb;

	// fill it in
	hb->mem = malloc (size);
	memset (hb->mem, 0, size);
	hb->size = size;
	hb->lowmark = size;

	// return the memory
	return hb->mem;
}


void Heap_Free (void)
{
	heapblock_t *hb;
	heapblock_t *hb2;
	int numblocks;

	UpdateProgressNotify ("Total Heap Memory Used %i KB\r\n", totalheap / 1024);

	// free all allocated memory
	for (numblocks = 0;;)
	{
		if (!heapblocks) break;
		hb = heapblocks->next;

		if (heapblocks->mem)
		{
			free (heapblocks->mem);
			heapblocks->mem = NULL;
			heapblocks->size = 0;
			numblocks++;
		}

		free (heapblocks);
		heapblocks = hb;
	}

	heapblocks = NULL;
	totalheap = 0;
	UpdateProgressNotify ("Total Heap Blocks Used %i\r\n", numblocks);
}


