// lighting.c

#include "light.h"
#include "winui.h"
#include <setjmp.h>

void GenerateLITFile (char *source);
void ProcessColour (void);
void LoadPalette (char *bspname);
void InitSingleMap (void);
void LightColourFace (int surfnum);
void CreateColourPointsForFaces (void);
void LoadProgs (char *bspname);
void InitFileSystem (char *bspname);
void FixupColourPoints (void);

int oversample = 1;

jmp_buf TheErrorJump;

float		scaledist = 1.0;
float		scalecos = 0.5;
float		rangescale = 0.5;

colourpoint_t *colourpoints;

byte		*filebase, *file_p, *file_end;

dmodel_t	*bspmodel;
int			bspfileface;	// next surface to dispatch

vec3_t	bsp_origin;

float		*minlights;


void RunLightPass (void)
{
	int	i = 0;

	bspfileface = 0;
	UpdateProgressNotify ("Lighting World...\r\n");

	while (1)
	{
		i = bspfileface++;

		if (i >= numfaces) return;

		LightColourFace (i);
		StepProgressBar ();
	}
}


/*
=============
LightWorld
=============
*/
void LightWorld (void)
{
	RunLightPass ();

	UpdateProgressNotify ("Light Data Size: %i\r\n\r\n", lightdatasize);
}


void MakeColourPoint (entity_t *e, float *colour)
{
	colourpoint_t *cp;

	// create the colour point for this entity
	cp = (colourpoint_t *) QHeap_Alloc (sizeof (colourpoint_t));

	// copy in relevant stuff from the entity
	cp->origin[0] = e->origin[0];
	cp->origin[1] = e->origin[1];
	cp->origin[2] = e->origin[2];
	cp->light = e->light;
	cp->targetent = e->targetent;
	cp->angle = e->angle;
	cp->colour[0] = colour[0];
	cp->colour[1] = colour[1];
	cp->colour[2] = colour[2];

	// link it in
	cp->next = colourpoints;
	colourpoints = cp;
}


void DoLighting (char *bspname)
{
	double start, end;
	char source[1024];
	int jumpret;

	Heap_Free ();

	jumpret = setjmp (TheErrorJump);

	if (jumpret != 0)
	{
		// notify, clean up and get out
		UpdateProgressNotify ("Processing Aborted\r\n");
		return;
	}

	// the filesystem needs to come up before anything else
	InitFileSystem (bspname);

	// load the palette from the same game directory (or falling back on ID1) as the BSP is in.
	// this needs to be loaded before anything else as entity models and the world both use it.
	LoadPalette	(bspname);

	start = I_FloatTime ();

	strcpy (source, bspname);
	StripExtension (source);
	DefaultExtension (source, ".bsp");

	LoadBSPFile (source);

	// hack to determine if the BSP is unloadable (is this obsolete now?)
	if (numfaces < 0) Error ("ERROR - couldn't load %s\r\n", source);

	UpdateProgressNotify ("Light Data Size: %i", lightdatasize);

	// set up minlights
	minlights = (float *) QHeap_Alloc (numfaces * sizeof (float));

	// set up progress bar
	SetupProgressBar (0, numfaces);

	// now do it
	colourpoints = NULL;
	LoadEntities ();
	MakeTnodes (&dmodels[0]);
	CreateColourPointsForFaces ();
	LoadProgs (source);	// always load after the entities
	FixupColourPoints ();
	LightWorld ();
	GenerateLITFile (source);

	end = I_FloatTime ();
	UpdateProgressNotify ("%0.2f Seconds Elapsed\r\n", end - start);

	// free heap memory
	Heap_Free ();
}

