
#include "cmdlib.h"
#include "mathlib.h"
#include "bspfile.h"
#include "entities.h"

#define	ON_EPSILON	0.1

#define	MAXLIGHTS			1024

void LoadNodes (char *file);
qboolean TestLine (vec3_t start, vec3_t stop);

void LightFace (int surfnum, qboolean test);
void LightLeaf (dleaf_t *leaf);

void MakeTnodes (dmodel_t *bm);

extern	float		scaledist;
extern	float		scalecos;
extern	float		rangescale;

extern	int		c_culldistplane, c_proper;

extern	byte		*filebase;

extern	vec3_t	bsp_origin;
extern	vec3_t	bsp_xvector;
extern	vec3_t	bsp_yvector;

void TransformSample (vec3_t in, vec3_t out);
void RotateSample (vec3_t in, vec3_t out);

extern	float		*minlights;

#define SINGLEMAPSIZE	324		// 18 * 18

void MakeColourPoint (entity_t *e, float *colour);
vec_t CastRay (vec3_t p1, vec3_t p2);
int LeafContentsForPoint (vec3_t p);

// filesystem
FILE *OpenQuakeFile (char *filename);
int LoadQuakeFile (char *filename, void **buffer);

#define Q_SafeFree(blah) {if (blah) {free (blah); blah = NULL;}}

void RGB2HSL (float *rgb);
void HSL2RGB (float *hsl);
void WhiteBias (float *colour, float bias);
