#include "light.h"
#include "heapmem.h"
#include "winui.h"


#define LIT_IDENT 0x54494c51
#define LIT_VERSION 1

void GenerateLITFile (char *source)
{
	int i;
	FILE *f;
	colourpoint_t *cp;
	char litfilename[256];

	UpdateProgressNotify ("Generating LIT file... ");

	sprintf (litfilename, "%s", source);

	for (i = strlen (litfilename); i; i--)
	{
		// note : these will always happen
		if (litfilename[i] == '.' && 
			litfilename[i + 1] == 'b' && 
			litfilename[i + 2] == 's' && 
			litfilename[i + 3] == 'p')
		{
			litfilename[i + 1] = 'l';
			litfilename[i + 2] = 'i';
			litfilename[i + 3] = 't';

			break;
		}
	}

	CollapsePAKFileName (litfilename);

	f = fopen (litfilename, "wb");

	// write the header
	i = LIT_IDENT;
	fwrite (&i, sizeof (int), 1, f);

	i = LIT_VERSION;
	fwrite (&i, sizeof (int), 1, f);

	// write the 3 component light
	fwrite (dlightdata3, lightdatasize3, 1, f);

	fclose (f);

	UpdateProgressNotify ("Done\r\n");
}

