
#include "light.h"

extern int *qpal[];

typedef enum {ST_SYNC = 0, ST_RAND} synctype_t;
typedef enum {ALIAS_SKIN_SINGLE = 0, ALIAS_SKIN_GROUP} aliasskintype_t;

typedef struct mdl_s
{
	int			ident;
	int			version;
	vec3_t		scale;
	vec3_t		scale_origin;
	float		boundingradius;
	vec3_t		eyeposition;
	int			numskins;
	int			skinwidth;
	int			skinheight;
	int			numverts;
	int			numtris;
	int			numframes;
	synctype_t	synctype;
	int			flags;
	float		size;
} mdl_t;

typedef struct daliasskintype_s
{
	aliasskintype_t	type;
} daliasskintype_t;


void BalanceColour (float *c, float target)
{
	// don't use rgb2hsl or hsl2rgb as colours can come in here hugely > 255...
	int i;
	int highest = 0;
	int lowest = 2147483647;
	int lowindex = 0;

	for (i = 0; i < 3; i++)
	{
		if (c[i] < lowest)
		{
			lowest = c[i];
			lowindex = i;
		}
	}

	// prevent the lowest from contributing as much
	// (already done at palette load time)
	//c[lowindex] /= 2;

	for (i = 0; i < 3; i++)
		if (c[i] > highest)
			highest = c[i];

	if (highest)
	{
		c[0] = (c[0] * target) / highest;
		c[1] = (c[1] * target) / highest;
		c[2] = (c[2] * target) / highest;
	}
	else
	{
		c[0] = target;
		c[1] = target;
		c[2] = target;
	}
}


void LoadAliasModel (entity_t *ent, byte *modelbuf)
{
	int i;
	mdl_t *mdl = (mdl_t *) modelbuf;
	int numcolour = 0;
	daliasskintype_t *pskintype = (daliasskintype_t *) (mdl + 1);
	byte *skin = (byte *) (pskintype + 1);
	byte flood = skin[0];

	// initial colours
	ent->colour[0] = 0;
	ent->colour[1] = 0;
	ent->colour[2] = 0;

	for (i = 0; i < mdl->skinwidth * mdl->skinheight; i++)
	{
		if (skin[i] == 255) continue;
		if (skin[i] == flood) continue;

		if (skin[i] > 223)
		{
			// square it for better intensity of brighter colours
			ent->colour[0] += ((int) qpal[skin[i]][0] * (int) qpal[skin[i]][0]) / 128;
			ent->colour[1] += ((int) qpal[skin[i]][1] * (int) qpal[skin[i]][1]) / 128;
			ent->colour[2] += ((int) qpal[skin[i]][2] * (int) qpal[skin[i]][2]) / 128;
			numcolour++;
		}
	}

	if (numcolour)
	{
		ent->colour[0] /= numcolour;
		ent->colour[1] /= numcolour;
		ent->colour[2] /= numcolour;
		BalanceColour (ent->colour, 255);
		return;
	}

	// no fullbrights so add the full texture
	for (i = 0; i < mdl->skinwidth * mdl->skinheight; i++)
	{
		if (skin[i] == 255) continue;
		if (skin[i] == flood) continue;

		// square it for better intensity of brighter colours
		ent->colour[0] += ((int) qpal[skin[i]][0] * (int) qpal[skin[i]][0]) / 128;
		ent->colour[1] += ((int) qpal[skin[i]][1] * (int) qpal[skin[i]][1]) / 128;
		ent->colour[2] += ((int) qpal[skin[i]][2] * (int) qpal[skin[i]][2]) / 128;
		numcolour++;
	}

	if (numcolour)
	{
		ent->colour[0] /= numcolour;
		ent->colour[1] /= numcolour;
		ent->colour[2] /= numcolour;
		BalanceColour (ent->colour, 255);
		return;
	}

	// no colours at all!!!
	ent->colour[0] = 255;
	ent->colour[1] = 255;
	ent->colour[2] = 255;
}


#define SPRITE_VERSION	1

// TODO: shorten these?
typedef struct {
	int			ident;
	int			version;
	int			type;
	float		boundingradius;
	int			width;
	int			height;
	int			numframes;
	float		beamlength;
	synctype_t	synctype;
} dsprite_t;

#define SPR_VP_PARALLEL_UPRIGHT		0
#define SPR_FACING_UPRIGHT			1
#define SPR_VP_PARALLEL				2
#define SPR_ORIENTED				3
#define SPR_VP_PARALLEL_ORIENTED	4

typedef struct {
	int			origin[2];
	int			width;
	int			height;
} dspriteframe_t;

typedef struct {
	int			numframes;
} dspritegroup_t;

typedef struct {
	float	interval;
} dspriteinterval_t;

typedef enum { SPR_SINGLE=0, SPR_GROUP } spriteframetype_t;

typedef struct {
	spriteframetype_t	type;
} dspriteframetype_t;


// FIXME: shorten these?
typedef struct mspriteframe_s
{
	int		width;
	int		height;
	float	up, down, left, right;
	void	*texture;
} mspriteframe_t;

typedef struct
{
	int				numframes;
	float			*intervals;
	mspriteframe_t	*frames[1];
} mspritegroup_t;

typedef struct
{
	spriteframetype_t	type;
	mspriteframe_t		*frameptr;
} mspriteframedesc_t;

typedef struct
{
	int					type;
	int					maxwidth;
	int					maxheight;
	int					numframes;
	float				beamlength;		// remove?
	void				*cachespot;		// remove?
	mspriteframedesc_t	frames[1];
} msprite_t;


int numspritecolour;

/*
=================
Mod_LoadSpriteFrame
=================
*/
void *Mod_LoadSpriteFrame (entity_t *ent, void * pin, mspriteframe_t **ppframe, int framenum)
{
	dspriteframe_t		*pinframe;
	mspriteframe_t		*pspriteframe;
	int					width, height, size, origin[2];
	char				name[64];
	int					i;
	byte				*data;

	pinframe = (dspriteframe_t *)pin;

	width = LittleLong (pinframe->width);
	height = LittleLong (pinframe->height);
	size = width * height;

	pspriteframe = (mspriteframe_t *) QHeap_Alloc (sizeof (mspriteframe_t));
	memset (pspriteframe, 0, sizeof (mspriteframe_t));

	*ppframe = pspriteframe;

	pspriteframe->width = width;
	pspriteframe->height = height;
	origin[0] = LittleLong (pinframe->origin[0]);
	origin[1] = LittleLong (pinframe->origin[1]);

	pspriteframe->up = origin[1];
	pspriteframe->down = origin[1] - height;
	pspriteframe->left = origin[0];
	pspriteframe->right = width + origin[0];

	// (byte *) (pinframe + 1) contains the texture
	data = (byte *) (pinframe + 1);

	for (i = 0; i < (width * height); i++)
	{
		if (data[i] == 255) continue;

		// square it for better intensity of brighter colours
		ent->colour[0] += ((int) qpal[data[i]][0] * (int) qpal[data[i]][0]) / 128;
		ent->colour[1] += ((int) qpal[data[i]][1] * (int) qpal[data[i]][1]) / 128;
		ent->colour[2] += ((int) qpal[data[i]][2] * (int) qpal[data[i]][2]) / 128;
		numspritecolour++;
	}

	return (void *) ((byte *) pinframe + sizeof (dspriteframe_t) + size);
}


/*
=================
Mod_LoadSpriteGroup
=================
*/
void *Mod_LoadSpriteGroup (entity_t *ent, void * pin, mspriteframe_t **ppframe, int framenum)
{
	dspritegroup_t		*pingroup;
	mspritegroup_t		*pspritegroup;
	int					i, numframes;
	dspriteinterval_t	*pin_intervals;
	float				*poutintervals;
	void				*ptemp;

	pingroup = (dspritegroup_t *)pin;

	numframes = LittleLong (pingroup->numframes);

	pspritegroup = (mspritegroup_t *) QHeap_Alloc (sizeof (mspritegroup_t) +
				(numframes - 1) * sizeof (pspritegroup->frames[0]));

	pspritegroup->numframes = numframes;

	*ppframe = (mspriteframe_t *)pspritegroup;

	pin_intervals = (dspriteinterval_t *)(pingroup + 1);

	poutintervals = (float *) QHeap_Alloc (numframes * sizeof (float));

	pspritegroup->intervals = poutintervals;

	for (i = 0; i < numframes; i++)
	{
		*poutintervals = LittleFloat (pin_intervals->interval);
		if (*poutintervals <= 0.0)
			Error ("Mod_LoadSpriteGroup: interval<=0");

		poutintervals++;
		pin_intervals++;
	}

	ptemp = (void *)pin_intervals;

	for (i = 0; i < numframes; i++)
	{
		ptemp = Mod_LoadSpriteFrame (ent, ptemp, &pspritegroup->frames[i], framenum * 100 + i);
	}

	return ptemp;
}


/*
=================
Mod_LoadSpriteModel
=================
*/
void Mod_LoadSpriteModel (entity_t *ent, void *buffer)
{
	int					i;
	int					version;
	dsprite_t			*pin;
	msprite_t			*psprite;
	int					numframes;
	int					size;
	dspriteframetype_t	*pframetype;

	pin = (dsprite_t *) buffer;

	version = LittleLong (pin->version);

	if (version != SPRITE_VERSION) Error ("sprite has wrong version number (%i should be %i)", version, SPRITE_VERSION);

	numframes = LittleLong (pin->numframes);

	size = sizeof (msprite_t) +	(numframes - 1) * sizeof (psprite->frames);

	psprite = (msprite_t *) QHeap_Alloc (size);

	psprite->type = LittleLong (pin->type);
	psprite->maxwidth = LittleLong (pin->width);
	psprite->maxheight = LittleLong (pin->height);
	psprite->beamlength = LittleFloat (pin->beamlength);
	psprite->numframes = numframes;

	// load the frames
	if (numframes < 1) Error ("Mod_LoadSpriteModel: Invalid # of frames: %d\n", numframes);

	pframetype = (dspriteframetype_t *)(pin + 1);
	numspritecolour = 0;

	// initial colour
	ent->colour[0] = 0;
	ent->colour[1] = 0;
	ent->colour[2] = 0;

	for (i = 0; i < numframes; i++)
	{
		spriteframetype_t	frametype;

		frametype = (spriteframetype_t) LittleLong (pframetype->type);
		psprite->frames[i].type = frametype;

		if (frametype == SPR_SINGLE)
			pframetype = (dspriteframetype_t *) Mod_LoadSpriteFrame (ent, pframetype + 1, &psprite->frames[i].frameptr, i);
		else pframetype = (dspriteframetype_t *) Mod_LoadSpriteGroup (ent, pframetype + 1, &psprite->frames[i].frameptr, i);
	}

	if (numspritecolour)
	{
		ent->colour[0] /= (float) numspritecolour;
		ent->colour[1] /= (float) numspritecolour;
		ent->colour[2] /= (float) numspritecolour;
		BalanceColour (ent->colour, 255);
	}
	else
	{
		// no colours
		ent->colour[0] = 255;
		ent->colour[1] = 255;
		ent->colour[2] = 255;
	}
}


