
#include <windows.h>
#include "light.h"


FILE *OpenQuakeFile (char *filename);


#define	OFS_NULL		0
#define	OFS_RETURN		1
#define	OFS_PARM0		4		// leave 3 ofs for each parm to hold vectors
#define	OFS_PARM1		7
#define	OFS_PARM2		10
#define	OFS_PARM3		13
#define	OFS_PARM4		16
#define	OFS_PARM5		19
#define	OFS_PARM6		22
#define	OFS_PARM7		25
#define	RESERVED_OFS	28

typedef int	func_t;
typedef int	string_t;

typedef struct
{
	int	pad[28];
	int	self;
	int	other;
	int	world;
	float	time;
	float	frametime;
	float	force_retouch;
	string_t	mapname;
	float	deathmatch;
	float	coop;
	float	teamplay;
	float	serverflags;
	float	total_secrets;
	float	total_monsters;
	float	found_secrets;
	float	killed_monsters;
	float	parm1;
	float	parm2;
	float	parm3;
	float	parm4;
	float	parm5;
	float	parm6;
	float	parm7;
	float	parm8;
	float	parm9;
	float	parm10;
	float	parm11;
	float	parm12;
	float	parm13;
	float	parm14;
	float	parm15;
	float	parm16;
	vec3_t	v_forward;
	vec3_t	v_up;
	vec3_t	v_right;
	float	trace_allsolid;
	float	trace_startsolid;
	float	trace_fraction;
	vec3_t	trace_endpos;
	vec3_t	trace_plane_normal;
	float	trace_plane_dist;
	int	trace_ent;
	float	trace_inopen;
	float	trace_inwater;
	int	msg_entity;
	func_t	main;
	func_t	StartFrame;
	func_t	PlayerPreThink;
	func_t	PlayerPostThink;
	func_t	ClientKill;
	func_t	ClientConnect;
	func_t	PutClientInServer;
	func_t	ClientDisconnect;
	func_t	SetNewParms;
	func_t	SetChangeParms;
} globalvars_t;

typedef union eval_s
{
	string_t		string;
	float			_float;
	float			vector[3];
	func_t			function;
	int				_int;
	int				edict;
} eval_t;	

enum {
	OP_DONE,
	OP_MUL_F,
	OP_MUL_V,
	OP_MUL_FV,
	OP_MUL_VF,
	OP_DIV_F,
	OP_ADD_F,
	OP_ADD_V,
	OP_SUB_F,
	OP_SUB_V,
	
	OP_EQ_F,
	OP_EQ_V,
	OP_EQ_S,
	OP_EQ_E,
	OP_EQ_FNC,
	
	OP_NE_F,
	OP_NE_V,
	OP_NE_S,
	OP_NE_E,
	OP_NE_FNC,
	
	OP_LE,
	OP_GE,
	OP_LT,
	OP_GT,

	OP_LOAD_F,
	OP_LOAD_V,
	OP_LOAD_S,
	OP_LOAD_ENT,
	OP_LOAD_FLD,
	OP_LOAD_FNC,

	OP_ADDRESS,

	OP_STORE_F,
	OP_STORE_V,
	OP_STORE_S,
	OP_STORE_ENT,
	OP_STORE_FLD,
	OP_STORE_FNC,

	OP_STOREP_F,
	OP_STOREP_V,
	OP_STOREP_S,
	OP_STOREP_ENT,
	OP_STOREP_FLD,
	OP_STOREP_FNC,

	OP_RETURN,
	OP_NOT_F,
	OP_NOT_V,
	OP_NOT_S,
	OP_NOT_ENT,
	OP_NOT_FNC,
	OP_IF,
	OP_IFNOT,
	OP_CALL0,
	OP_CALL1,
	OP_CALL2,
	OP_CALL3,
	OP_CALL4,
	OP_CALL5,
	OP_CALL6,
	OP_CALL7,
	OP_CALL8,
	OP_STATE,
	OP_GOTO,
	OP_AND,
	OP_OR,
	
	OP_BITAND,
	OP_BITOR
};


typedef struct statement_s
{
	unsigned short	op;
	short	a,b,c;
} dstatement_t;

typedef struct
{
	unsigned short	type;		// if DEF_SAVEGLOBGAL bit is set
								// the variable needs to be saved in savegames
	unsigned short	ofs;
	int			s_name;
} ddef_t;

#define	DEF_SAVEGLOBAL	(1<<15)
#define	MAX_PARMS	8

typedef struct
{
	int		first_statement;	// negative numbers are builtins
	int		parm_start;
	int		locals;				// total ints of parms + locals
	
	int		profile;		// runtime
	
	int		s_name;
	int		s_file;			// source file defined in
	
	int		numparms;
	byte	parm_size[MAX_PARMS];
} dfunction_t;

#define	PROG_VERSION	6

typedef struct
{
	int		version;
	int		crc;			// check of header file
	
	int		ofs_statements;
	int		numstatements;	// statement 0 is an error

	int		ofs_globaldefs;
	int		numglobaldefs;
	
	int		ofs_fielddefs;
	int		numfielddefs;
	
	int		ofs_functions;
	int		numfunctions;	// function 0 is an empty
	
	int		ofs_strings;
	int		numstrings;		// first string is a null string

	int		ofs_globals;
	int		numglobals;
	
	int		entityfields;
} dprograms_t;

dprograms_t *progs;
dfunction_t *pr_functions;
char *pr_strings;
ddef_t *pr_globaldefs;
ddef_t *pr_fielddefs;
dstatement_t *pr_statements;
int *pr_globals;

FILE *FindFileInPaks (char *basepath, char *filename);

dfunction_t *ED_FindFunction (char *name)
{
	dfunction_t *func;
	int i;

	for (i = 0; i < progs->numfunctions; i++)
	{
		// this only exists so i can step through it in the debugger
		char *thisfunc = pr_strings + pr_functions[i].s_name;
		func = &pr_functions[i];

		if (!strcmp (thisfunc, name))
			return func;
	}

	return NULL;
}

#define IDPOLYHEADER	(('O' << 24) + ('P' << 16) + ('D' << 8) + 'I')
#define IDSPRITEHEADER	(('P' << 24) + ('S' << 16) + ('D' << 8) + 'I')

void LoadAliasModel (entity_t *ent, byte *modelbuf);
void Mod_LoadSpriteModel (entity_t *ent, void *buffer);

void LoadModelForEntity (entity_t *ent)
{
	byte *modelbuf;

	// attempt to load it
	if (!LoadQuakeFile (ent->mdlname, (void **) &modelbuf)) return;

	switch (LittleLong (*(unsigned *) modelbuf))
	{
	case IDPOLYHEADER:
		LoadAliasModel (ent, modelbuf);
		break;
		
	case IDSPRITEHEADER:
		Mod_LoadSpriteModel (ent, modelbuf);
		break;

	default:
		// unsupported
		break;
	}

	// done
	Q_SafeFree (modelbuf);
}


void LoadProgs (char *bspname)
{
	int i;
	int j;
	FILE *progsfile;
	char progspath[MAX_PATH];
	int progbase;

	// no progs to start off with
	progs = NULL;
	pr_functions = NULL;
	pr_strings = NULL;
	pr_globaldefs = NULL;
	pr_fielddefs = NULL;
	pr_statements = NULL;
	pr_globals = NULL;

	progsfile = OpenQuakeFile ("progs.dat");

	if (!progsfile) return;

	UpdateProgressNotify ("Loading progs.dat\r\n");

	// because we could be loading from a PAK file we need to get the base file pointer
	// position to use for adding to any offsets we need to use
	progbase = ftell (progsfile);

	// set up progs for loading
	progs = (dprograms_t *) QHeap_Alloc (sizeof (dprograms_t));

	// read in the progs header
	fread (progs, sizeof (dprograms_t), 1, progsfile);

	// read in the rest of the elements
	pr_functions = (dfunction_t *) QHeap_Alloc (sizeof (dfunction_t) * progs->numfunctions);
	fseek (progsfile, progbase + progs->ofs_functions, SEEK_SET);
	fread (pr_functions, sizeof (dfunction_t), progs->numfunctions, progsfile);

	pr_globaldefs = (ddef_t *) QHeap_Alloc (sizeof (ddef_t) * progs->numglobaldefs);
	fseek (progsfile, progbase + progs->ofs_globaldefs, SEEK_SET);
	fread (pr_globaldefs, sizeof (ddef_t), progs->numglobaldefs, progsfile);

	pr_fielddefs = (ddef_t *) QHeap_Alloc (sizeof (ddef_t) * progs->numfielddefs);
	fseek (progsfile, progbase + progs->ofs_fielddefs, SEEK_SET);
	fread (pr_fielddefs, sizeof (ddef_t), progs->numfielddefs, progsfile);

	pr_statements = (dstatement_t *) QHeap_Alloc (sizeof (dstatement_t) * progs->numstatements);
	fseek (progsfile, progbase + progs->ofs_statements, SEEK_SET);
	fread (pr_statements, sizeof (dstatement_t), progs->numstatements, progsfile);

	pr_strings = (char *) QHeap_Alloc (progs->numstrings);
	fseek (progsfile, progbase + progs->ofs_strings, SEEK_SET);
	fread (pr_strings, progs->numstrings, 1, progsfile);

	pr_globals = (int *) QHeap_Alloc (progs->numglobals * sizeof (int));
	fseek (progsfile, progbase + progs->ofs_globals, SEEK_SET);
	fread (pr_globals, sizeof (int), progs->numglobals, progsfile);

	// done
	fclose (progsfile);

	// find entity spawn functions
	for (i = 0; i < num_entities; i++)
	{
		char *mdlname = NULL;
		dfunction_t *spawnfunc;
		int s;
		dstatement_t *st;

		// null model to begin with
		entities[i].mdlname[0] = 0;

		// only interested in light entities
		// (don't check the name as mods may call their lights by any name they choose)
		if (entities[i].light < 1) continue;

		// find the spawn function
		spawnfunc = ED_FindFunction (entities[i].classname);

		// if there was none found we don't bother
		if (!spawnfunc) continue;

		s = spawnfunc->first_statement;

		while (1)
		{
			eval_t *a, *b, *c;
			dfunction_t *newf;
			char *funcname;

			// get this statement
			st = &pr_statements[s];

			a = (eval_t *) &pr_globals[st->a];
			b = (eval_t *) &pr_globals[st->b];
			c = (eval_t *) &pr_globals[st->c];

			switch (st->op)
			{
			case OP_STORE_V:
				mdlname = pr_strings + a->_int;
				break;

			case OP_CALL0:
			case OP_CALL1:
			case OP_CALL2:
			case OP_CALL3:
			case OP_CALL4:
			case OP_CALL5:
			case OP_CALL6:
			case OP_CALL7:
			case OP_CALL8:
				// trap function calls
				if (!a->function)
					break;

				newf = &pr_functions[a->function];

				funcname = pr_strings + newf->s_name;

				if (!stricmp (funcname, "setmodel"))
				{
					if (mdlname)
					{
						// load the model
						strcpy (entities[i].mdlname, mdlname);

						// for next time
						mdlname = NULL;
					}

					// this is all we need to find here
					goto Next_Entity;
				}

				break;

			case OP_DONE:
			case OP_RETURN:
				// done
				goto Next_Entity;

			default:
				break;
			}

			// next statement
			s++;
		}

Next_Entity:;
	}

	// now pass through the entities again to load the models
	for (i = 0; i < num_entities; i++)
	{
		entity_t *ent = &entities[i];
#define DEFCOLOR 255
		float defaultentitycolour[3] = {DEFCOLOR - 1, DEFCOLOR - 2, DEFCOLOR - 3};

		// skip
		if (ent->light < 1) continue;

		entities[i].islight = true;

		if (!ent->mdlname[0])
		{
			// make a colour point for it
			//ent->light = 2000;
			MakeColourPoint (ent, defaultentitycolour);
			continue;
		}

		// see is it already loaded
		for (j = 0; j < i; j++)
		{
			if (entities[j].light < 1) continue;
			if (!stricmp (entities[j].mdlname, ent->mdlname)) break;
		}

		// model already loaded...
		if (j != i)
		{
			// copy in
			ent->colour[0] = entities[j].colour[0];
			ent->colour[1] = entities[j].colour[1];
			ent->colour[2] = entities[j].colour[2];
		}
		else
		{
			// load the model for this entity
			LoadModelForEntity (ent);

			//ent->colour[0] *= 2;
			//ent->colour[1] *= 2;
			//ent->colour[2] *= 2;
			//ent->colour[0] *= ent->colour[0]; ent->colour[0] /= 128;
			//ent->colour[1] *= ent->colour[1]; ent->colour[1] /= 128;
			//ent->colour[2] *= ent->colour[2]; ent->colour[2] /= 128;
		}

		// make a colour point for it
		MakeColourPoint (ent, ent->colour);
	}
}

