
// enable XP-isms
#define _WIN32_WINNT 0x501
#define WINVER 0x501

#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <stdio.h>
#include <direct.h>
#include <memory.h>
#include <setjmp.h>
#include "wincontrols.h"
#include "light.h"
#include "resource.h"

// long jump for the cancel button
jmp_buf TheCancelJump;

// xp styles supposedly need this (works fine without it though)
#define SIDEBYSIDE_COMMONCONTROLS 1

// stored globally for easy access
HINSTANCE hAppInstance;
HWND hMainDialog;
HWND hProgressDialog;
HWND hWndListView;
HWND hWndTreeView;
HWND hWndComboBox;
HWND hWndProgressCurrentBSP;
HWND hWndProgressAllBSPs;
HIMAGELIST hImageList;

// BSPs selected to process - NULL terminate this list!!!
char **SelectedBSPs = NULL;

// other lighting properties
int NumSelectedBSPs;

// icons for the tree view
int ilIconCDDrive;
int ilIconFolderClosed;
int ilIconFixedDrive;
int ilIconMyComputer;
int ilIconNetDrive;
int ilIconOpenFolder;
int ilIconRemovable;
int ilIconQuakePak;

char szQuakeFolder[MAX_PATH];

char *szTestFolders[] =
{
	":\\Quake",
	":\\Program Files\\Quake",
	":\\Games\\Quake",
	NULL
};

void DoLighting (char *bspname);

BOOL Is_WinXP (void) 
{
	OSVERSIONINFOEX osvi;
	DWORDLONG dwlConditionMask = 0;

	// Initialize the OSVERSIONINFOEX structure.
	ZeroMemory (&osvi, sizeof (OSVERSIONINFOEX));
	osvi.dwOSVersionInfoSize = sizeof (OSVERSIONINFOEX);
	osvi.dwMajorVersion = 5;
	osvi.dwMinorVersion = 1;

	// Initialize the condition mask.
	VER_SET_CONDITION (dwlConditionMask, VER_MAJORVERSION, VER_GREATER_EQUAL);
	VER_SET_CONDITION (dwlConditionMask, VER_MINORVERSION, VER_GREATER_EQUAL);

	// Perform the test.
	return VerifyVersionInfo (&osvi, VER_MAJORVERSION | VER_MINORVERSION, dwlConditionMask);
}


void DoEvents (HWND hWnd)
{
	// pump the message queue until it's empty
	MSG msg;

	while (PeekMessage (&msg, hWnd, 0, 0, PM_REMOVE))
	{
      	TranslateMessage (&msg);
      	DispatchMessage (&msg);
	}
}


void StepProgressBar (void)
{
	// advance by step
	SendMessage (hWndProgressCurrentBSP, PBM_STEPIT, 0, 0);

	// flush all events to ensure that it takes effect
	DoEvents (hProgressDialog);
}


void SetupProgressBar (int nMinRange, int nMaxRange)
{
	// set the range
	SendMessage (hWndProgressCurrentBSP, PBM_SETRANGE, 0, MAKELPARAM (nMinRange, nMaxRange));

	// set current value to min
	SendMessage (hWndProgressCurrentBSP, PBM_SETPOS, (WPARAM) 0, 0);

	// set step to 1
	SendMessage (hWndProgressCurrentBSP, PBM_SETSTEP, (WPARAM) 1, 0);

	// flush all events to ensure that it takes effect
	DoEvents (hProgressDialog);
}


char WindowBuffer[65536];

void UpdateProgressNotify (char *format, ...)
{
	va_list argptr;
	static char finalstring[2048];
	HWND hProgressWindow = GetDlgItem (hProgressDialog, IDC_EDIT_PROGRESSNOTIFY);

	va_start (argptr, format);
	vsprintf (finalstring, format, argptr);
	va_end (argptr);

	// get current text
	GetWindowText (hProgressWindow, WindowBuffer, 65536);

	strcat (WindowBuffer, finalstring);

	// set new text
	SetWindowText (hProgressWindow, TEXT (WindowBuffer));
	DoEvents (hProgressDialog);

	// scroll to the bottom
	SendMessage (hProgressWindow, WM_VSCROLL, MAKEWPARAM (SB_BOTTOM, 0), (LPARAM) NULL);
	DoEvents (hProgressDialog);
}


char *va (char *format, ...)
{
	va_list argptr;
	static char finalstring[2048];

	va_start (argptr, format);
	vsprintf (finalstring, format, argptr);
	va_end (argptr);

	return finalstring;
}


void FixupInteractionControls (void)
{
	// get number of files in the list view and toggle remove all and process
	if (SendMessage (hWndListView, LVM_GETITEMCOUNT, 0, 0))
	{
		EnableWindow (GetDlgItem (hMainDialog, IDC_BUTTON_REMOVEALL), TRUE);
		EnableWindow (GetDlgItem (hMainDialog, IDC_BUTTON_PROCESSFILE), TRUE);
	}
	else
	{
		EnableWindow (GetDlgItem (hMainDialog, IDC_BUTTON_REMOVEALL), FALSE);
		EnableWindow (GetDlgItem (hMainDialog, IDC_BUTTON_PROCESSFILE), FALSE);
	}

	// get number of selected and toggle remove selected
	if (SendMessage (hWndListView, LVM_GETSELECTEDCOUNT, 0, 0))
		EnableWindow (GetDlgItem (hMainDialog, IDC_BUTTON_REMOVEFILE), TRUE);
	else EnableWindow (GetDlgItem (hMainDialog, IDC_BUTTON_REMOVEFILE), FALSE);
}


// there's probably a more sensible way of doing this, but - hey! - the 
// time to find it vs the time to write it myself, ok?
char *CommaNumber (int num, char *units)
{
	static char TextNum[64];
	int i;

	if (num < 1000)
	{
		sprintf (TextNum, "%i%s", num, units);
		return TextNum;
	}

	// write in 0.3 format so that we have a separated version valid for sizes below 1 GB
	// (are there any 1 GB Quake maps yet?)
	sprintf (TextNum, "%0.3f%s", ((float) num / 1000.0f), units);

	// convert '.' to ',' (getting better)
	for (i = 0; ; i++)
	{
		if (!TextNum[i]) break;
		if (TextNum[i] == '.') TextNum[i] = ',';
	}

	return TextNum;
}


int LV_FindGroupText (char *GroupText, int MaxBuf, int GroupID)
{
	int i;
	int FoundID;
	LVGROUP TheGroup;
	WCHAR *GroupName = (WCHAR *) malloc ((MaxBuf + 1) * sizeof (WCHAR));

	memset (&TheGroup, 0, sizeof (LVGROUP));
	TheGroup.cbSize = sizeof (LVGROUP);
	TheGroup.mask = LVGF_HEADER | LVGF_GROUPID;
	TheGroup.pszHeader = GroupName;
	TheGroup.cchHeader = MaxBuf;
	TheGroup.iGroupId = GroupID;

	if ((FoundID = ListView_GetGroupInfo (hWndListView, GroupID, &TheGroup)) != -1)
	{
		// FUCK FUCK FUCK FUCK FUCK fucking unicode
		for (i = 0; ; i++)
		{
			GroupText[i] = TheGroup.pszHeader[i] & 0xff;
			if (!TheGroup.pszHeader[i]) break;
		}
	}

	// done
	Q_SafeFree (GroupName);
	return FoundID;
}


int LV_FindGroupID (char *GroupText)
{
	// there doesn't seem to be a message to retrieve this so...
	int i;
	LVGROUP TheGroup;

	for (i = 0; ; i++)
	{
		int FoundID;
		char GroupName[MAX_PATH] = {0};

		// find the text for this ID
		if ((FoundID = LV_FindGroupText (GroupName, MAX_PATH, i)) == -1) break;

		// check for a match
		if (!stricmp (GroupName, GroupText)) return i;
	}

	// add one
	memset (&TheGroup, 0, sizeof (LVGROUP));
	TheGroup.cbSize = sizeof (LVGROUP);
	TheGroup.mask = LVGF_HEADER | LVGF_GROUPID;
	TheGroup.pszHeader = (WCHAR *) malloc (strlen (GroupText) * 2 + 2);
	TheGroup.iGroupId = i;

	// more FUCKING unicode
	for (i = 0; ; i++)
	{
		TheGroup.pszHeader[i] = GroupText[i];
		if (GroupText[i] == 0) break;
	}

	ListView_InsertGroup (hWndListView, 0, &TheGroup);

	// turn on group view after adding the first item
	if (TheGroup.iGroupId == 0) ListView_EnableGroupView (hWndListView, TRUE);

	return TheGroup.iGroupId;
}


void AddItemToListView (char *FullPath, char *ItemText)
{
	int i;
	int ItemIndex;
	LV_ITEM lvi;
	int lvIndex;
	int sizes[HEADER_LUMPS + 1] = {0};
	int NumItems;
	char GroupText[MAX_PATH];

	// sanity check
	if (stricmp (&ItemText[strlen (ItemText) - 4], ".bsp")) return;

	// see if it is already there
	NumItems = SendMessage (hWndListView, LVM_GETITEMCOUNT, 0, 0);

	for (ItemIndex = 0; ItemIndex < NumItems; ItemIndex++)
	{
		char TestItemText[MAX_PATH];

		ListView_GetItemText (hWndListView, ItemIndex, 0, TestItemText, MAX_PATH);

		if (!stricmp (ItemText, TestItemText)) return;
	}

	// get the sizes of the BSP and it's lumps
	GetBSPFileSizes (FullPath, sizes);

	// main item (column 0)
	memset (&lvi, 0, sizeof (LV_ITEM));
	lvi.mask = LVIF_TEXT | LVIF_IMAGE;
	lvi.iImage = ilIconQuakePak;
	lvi.iSubItem = 0;
	lvi.pszText = ItemText;

	// set up the group name
	strcpy (GroupText, FullPath);
	GroupText[strlen (GroupText) - strlen (ItemText) - 1] = 0;

	// set up the group related info in the item
	lvi.mask |= LVIF_GROUPID;
	lvi.iGroupId = LV_FindGroupID (GroupText);

	// add it
	lvIndex = SendMessage (hWndListView, LVM_INSERTITEM, 0, (LPARAM) &lvi);

	// common
	lvi.mask = LVIF_TEXT;
	lvi.iItem = lvIndex;

	// BSP size (column 1)
	lvi.iSubItem = 1;
	lvi.pszText = CommaNumber (sizes[0], " KB");
	SendMessage (hWndListView, LVM_SETITEM, 0, (LPARAM) &lvi);

	// faces (column 2) - add 1 as index 0 is reserved for the bsp file size
	lvi.iSubItem = 2;
	lvi.pszText = CommaNumber (sizes[LUMP_FACES + 1], "");
	SendMessage (hWndListView, LVM_SETITEM, 0, (LPARAM) &lvi);

	// entities (column 2) - add 1 as index 0 is reserved for the bsp file size
	lvi.iSubItem = 3;
	lvi.pszText = CommaNumber (sizes[LUMP_ENTITIES + 1], "");
	SendMessage (hWndListView, LVM_SETITEM, 0, (LPARAM) &lvi);

	// light data size (column 4) - add 1 as index 0 is reserved for the bsp file size
	lvi.iSubItem = 4;
	lvi.pszText = CommaNumber (sizes[LUMP_LIGHTING + 1], " KB");
	SendMessage (hWndListView, LVM_SETITEM, 0, (LPARAM) &lvi);
}


void MakeImageList (void)
{
	HICON hIcon;

	// First create the image list you will need.
	hImageList = ImageList_Create (16, 16, ILC_MASK | ILC_COLOR32, 8, 0);

	// add our icons to the image list
	ilIconCDDrive = ImageList_AddIcon (hImageList, LoadIcon (hAppInstance, MAKEINTRESOURCE (IDI_ICON_CDDRIVE)));
	ilIconFolderClosed = ImageList_AddIcon (hImageList, LoadIcon (hAppInstance, MAKEINTRESOURCE (IDI_ICON_FOLDERCLOSED)));
	ilIconFixedDrive = ImageList_AddIcon (hImageList, LoadIcon (hAppInstance, MAKEINTRESOURCE (IDI_ICON_FIXEDDRIVE)));
	ilIconMyComputer = ImageList_AddIcon (hImageList, LoadIcon (hAppInstance, MAKEINTRESOURCE (IDI_ICON_MYCOMPUTER)));
	ilIconNetDrive = ImageList_AddIcon (hImageList, LoadIcon (hAppInstance, MAKEINTRESOURCE (IDI_ICON_NETWORKDRIVE)));
	ilIconOpenFolder = ImageList_AddIcon (hImageList, LoadIcon (hAppInstance, MAKEINTRESOURCE (IDI_ICON_OPENFOLDER)));
	ilIconRemovable = ImageList_AddIcon (hImageList, LoadIcon (hAppInstance, MAKEINTRESOURCE (IDI_ICON_REMOVABLE)));
	ilIconQuakePak = ImageList_AddIcon (hImageList, LoadIcon (hAppInstance, MAKEINTRESOURCE (IDI_ICON_QUAKEPAK)));
}


HTREEITEM TV_AddItem (HTREEITEM hParent, char *itemtext, int NormalImage, int SelectedImage, char *path)
{
	TVINSERTSTRUCT tvi;
	HTREEITEM thisItem;

	tvi.hInsertAfter = TVI_SORT;
	tvi.hParent = hParent;
	tvi.item.pszText = itemtext;
	tvi.item.iImage = NormalImage;
	tvi.item.iSelectedImage = SelectedImage;

	if (path)
	{
		// stash the full path in the LParam so that we can retrieve it more easily...
		char *lParamPath = (char *) malloc (MAX_PATH);
		strcpy (lParamPath, path);
		tvi.item.lParam = (LPARAM) lParamPath;
	}
	else tvi.item.lParam = (LPARAM) 0;

	tvi.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_PARAM;

	return TreeView_InsertItem (hWndTreeView, &tvi);
}


void ExpandTreeFromPAK (HTREEITEM hParent, char *pakname);

void TV_AddPAKItem (HTREEITEM hParent, char *pakname, char *filename)
{
	char pakpath[MAX_PATH];

	sprintf (pakpath, "%s\\%s", pakname, filename);
	TV_AddItem (hParent, filename, ilIconQuakePak, ilIconQuakePak, pakpath);
}


void TV_AddChildren (HTREEITEM hParent, char *foldername)
{
	// add child items to a parent item, but does not expand the view
	WIN32_FIND_DATA ffd;
	HANDLE ffh;
	char searchpath[MAX_PATH];
	char foundpath[MAX_PATH];

	// is the item a PAK file?
	if (!stricmp (&foldername[strlen (foldername) - 4], ".pak"))
	{
		// expand out the PAK fully
		ExpandTreeFromPAK (hParent, foldername);
		return;
	}

	// is the item a BSP file?
	if (!stricmp (&foldername[strlen (foldername) - 4], ".bsp"))
	{
		// do nothing
		return;
	}

	sprintf (searchpath, "%s*.*", foldername);

	if (!(ffh = FindFirstFile (searchpath, &ffd)))
		return;

	do
	{
		// don't use these types
		if (ffd.dwFileAttributes & FILE_ATTRIBUTE_COMPRESSED) continue;
		if (ffd.dwFileAttributes & FILE_ATTRIBUTE_ENCRYPTED) continue;
		if (ffd.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN) continue;
		if (ffd.dwFileAttributes & FILE_ATTRIBUTE_OFFLINE) continue;
		if (ffd.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM) continue;
		if (ffd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY) continue;

		// don't add these ones!
		if (!strcmp (ffd.cFileName, ".")) continue;
		if (!strcmp (ffd.cFileName, "..")) continue;

		if (ffd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		{
			sprintf (foundpath, "%s%s\\", foldername, ffd.cFileName);
			TV_AddItem (hParent, ffd.cFileName, ilIconFolderClosed, ilIconOpenFolder, foundpath);
		}
		else
		{
			// get item extension
			char *ext = &ffd.cFileName[strlen (ffd.cFileName) - 4];

			// is the item a PAK file?
			if (!stricmp (ext, ".pak"))
			{
				sprintf (foundpath, "%s%s", foldername, ffd.cFileName);
				TV_AddItem (hParent, ffd.cFileName, ilIconQuakePak, ilIconQuakePak, foundpath);
			}
			else if (!stricmp (ext, ".bsp"))
			{
				sprintf (foundpath, "%s%s", foldername, ffd.cFileName);
				TV_AddItem (hParent, ffd.cFileName, ilIconQuakePak, ilIconQuakePak, foundpath);
			}
		}
	} while (FindNextFile (ffh, &ffd));

	// done
	FindClose (ffh);
}


void TV_HandleItemExpand (HTREEITEM hTreeItem)
{
	HTREEITEM hChild;
	TVITEM tvItem;

	// get the first child item
	hChild = TreeView_GetChild (hWndTreeView, hTreeItem);

	// no children
	if (!hChild) return;

	// suppress updates while adding multiple items
	SendMessage (hWndTreeView, WM_SETREDRAW, (WPARAM) FALSE, 0);

	do
	{
		// get this item
		tvItem.mask = TVIF_PARAM | TVIF_CHILDREN;
		tvItem.hItem = hChild;
		TreeView_GetItem (hWndTreeView, &tvItem);

		// invalid
		if (tvItem.lParam == 0) continue;

		// already has children
		if (tvItem.cChildren) continue;

		// add children for each child of the item that was expanded
		TV_AddChildren (hChild, (char *) tvItem.lParam);
	} while (hChild = TreeView_GetNextSibling (hWndTreeView, hChild));

	// resume updates
	SendMessage (hWndTreeView, WM_SETREDRAW, (WPARAM) TRUE, 0);
}


void TV_SelectFolder (char *foldername)
{
	int i;
	char expanded[MAX_PATH];
	HTREEITEM tvCurrentNode = TreeView_GetRoot (hWndTreeView);

	// we fon't have a valid folder name...!
	if (!foldername[0]) return;

	// take a copy cos we're going to change it, append a "\\" cos the treeview stores the paths with that at the end
	strcpy (expanded, foldername);
	strcat (expanded, "\\");

	for (i = 0; ; i++)
	{
		// end of the list
		if (!expanded[i]) break;

		if (expanded[i] == '/' || expanded[i] == '\\')
		{
			// get the first child
			HTREEITEM tvItem = TreeView_GetChild (hWndTreeView, tvCurrentNode);
			BOOL bTraverseNode = FALSE;
			char c;

			// nope, no deal
			if (!tvItem) return;

			// ensure a backlash to keep the string comparison valid
			expanded[i] = '\\';

			// replace - NOTE - we want the character *AFTER* the slash, so we must store it
			c = expanded[i + 1];
			expanded[i + 1] = 0;

			do
			{
				TVITEM tvi;
				char *nodefolder;

				// fill in the info we want to get
				tvi.hItem = tvItem;
				tvi.mask = TVIF_PARAM;

				// get the item
				if (!TreeView_GetItem (hWndTreeView, &tvi)) continue;

				// we stashed the folder in the lParam so now retrieve that
				nodefolder = (char *) tvi.lParam;

				// hack for the root node
				if (!nodefolder) return;

				// see is this the one we want
				if (!stricmp (expanded, nodefolder))
				{
					// mark that we've successfully traversed the node
					bTraverseNode = TRUE;

					// change the node
					tvCurrentNode = tvItem;

					// expand the node (standard messaging will look after loading the items)
					TreeView_Expand (hWndTreeView, tvItem, TVE_EXPAND);
					TreeView_Select (hWndTreeView, tvItem, TVGN_CARET);

					// done
					break;
				}
			} while ((tvItem = TreeView_GetNextSibling (hWndTreeView, tvItem)) != NULL);

			// if we didn't traverse this node we're not going to go any further, so give up!!!
			if (!bTraverseNode) return;

			// put back
			expanded[i + 1] = c;
		}
	}
}


void Create_ListViewColumn (char *Text, int index, int width)
{
	LVCOLUMN lvc;

	memset (&lvc, 0, sizeof (LVCOLUMN));

	if (!index)
	{
		// first column
		lvc.fmt = LVCFMT_LEFT;
	}
	else
	{
		// subsequent columns
		lvc.fmt = LVCFMT_RIGHT;
	}

	// common
	lvc.mask = LVCF_TEXT | LVCF_WIDTH | LVCF_SUBITEM | LVCF_FMT;
	lvc.pszText = Text;
	lvc.iSubItem = index;
	lvc.cx = width;

	// create it
	SendMessage (hWndListView, LVM_INSERTCOLUMN, index, (LPARAM) &lvc);
}


BOOL CALLBACK ProcessDlgProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:
		{
			int i;
			int canceljump;

			// store out
			hProgressDialog = hDlg;
			hWndProgressAllBSPs = GetDlgItem (hDlg, IDC_PB_PROGRESSALL);
			hWndProgressCurrentBSP = GetDlgItem (hDlg, IDC_PB_PROGRESSBSP);

			// finish setup (force the window to show now)
			ShowWindow (hDlg, SW_SHOW);
			DoEvents (hDlg);

			// setup "All BSPs" Progress
			SendMessage (hWndProgressAllBSPs, PBM_SETRANGE, 0, MAKELPARAM (0, NumSelectedBSPs));
			SendMessage (hWndProgressAllBSPs, PBM_SETPOS, (WPARAM) 0, 0);
			SendMessage (hWndProgressAllBSPs, PBM_SETSTEP, (WPARAM) 1, 0);

			// ensure
			DoEvents (hDlg);

			canceljump = setjmp (TheCancelJump);

			if (canceljump == 0)
			{
				// light the BSPs
				for (i = 0; ; i++)
				{
					if (!SelectedBSPs[i]) break;

					SetWindowText (hDlg, va ("  Processing %s...", SelectedBSPs[i]));

					UpdateProgressNotify ("===============================================\r\n");
					UpdateProgressNotify ("Processing %s...\r\n", SelectedBSPs[i]);

					DoEvents (hDlg);
					DoLighting (SelectedBSPs[i]);

					SendMessage (hWndProgressAllBSPs, PBM_STEPIT, 0, 0);
					DoEvents (hDlg);
				}

				// completed
				//Heap_Free ();
				UpdateProgressNotify ("===============================================\r\n");
				UpdateProgressNotify ("MHColour Complete\r\n");
			}
			else
			{
				// cancelled
				//Heap_Free ();
				UpdateProgressNotify ("===============================================\r\n");
				UpdateProgressNotify ("MHColour Cancelled\r\n");
			}

			// toggle buttons and switch window text
			EnableWindow (GetDlgItem (hDlg, ID_BUTTON_OK), TRUE);
			EnableWindow (GetDlgItem (hDlg, ID_BUTTON_CANCEL), FALSE);
			SetWindowText (hDlg, "  Done");
		}

		return TRUE;

	case WM_COMMAND:
		switch (LOWORD (wParam))
		{
		case ID_BUTTON_OK:
			// done
			EndDialog (hDlg, 0);
			return TRUE;

		case ID_BUTTON_CANCEL:
			// cancel processing
			longjmp (TheCancelJump, -1);
			return TRUE;
		}
	}

	return FALSE;
}


BOOL CALLBACK MHColourDlgProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	int SelectedFile = 0;
	HTREEITEM hTI;
	DWORD dwDrives;
	int d;

	// hack declaration as we can't declare in a case label...
	char *FileBatch = NULL;

	// ensure always
	hMainDialog = hDlg;

	switch (message)
	{
	case WM_INITDIALOG:
		// store out HWNDs of frequently used controls
		hWndListView = GetDlgItem (hMainDialog, IDC_LV_BSPFILES);
		hWndTreeView = GetDlgItem (hMainDialog, IDC_TREE_FILES);
		hWndComboBox = GetDlgItem (hMainDialog, IDC_COMBO_CURRENTPATH);

		// list view and tree view need this
		MakeImageList ();

		// listview setup
		ListView_SetImageList (hWndListView, hImageList, LVSIL_SMALL);
		SendMessage (hWndListView, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, (LPARAM) LVS_EX_FULLROWSELECT);
		Create_ListViewColumn ("BSP Name", 0, 150);
		Create_ListViewColumn ("BSP Size", 1, 70);
		Create_ListViewColumn ("Faces", 2, 70);
		Create_ListViewColumn ("Entities", 3, 70);
		Create_ListViewColumn ("Lightdata", 4, 70);
		ListView_SetSelectedColumn (hWndListView, 0);

		// default disables
		EnableWindow (GetDlgItem (hMainDialog, IDC_BUTTON_PROCESSFILE), FALSE);

		// listbox
		FixupInteractionControls ();

		// set the icon
		SendMessage (hMainDialog, WM_SETICON, (WPARAM) ICON_BIG, (LPARAM) (HICON) LoadIcon (hAppInstance, MAKEINTRESOURCE (IDI_ICON_APPICON)));

		// set up the treeview
		TreeView_SetImageList (hWndTreeView, hImageList, TVSIL_NORMAL);

		hTI = TV_AddItem (NULL, "My Computer", ilIconMyComputer, ilIconMyComputer, "My Computer");

		dwDrives = GetLogicalDrives ();

		// start at C
		for (d = 2; d < 32; d++)
		{
			if (dwDrives & (1 << d))
			{
				UINT DriveType = GetDriveType (va ("%c:\\", ('A' + d)));
				HTREEITEM hTreeDrive;
				char DriveDesc[MAX_PATH];
				char DrivePath[MAX_PATH];

				sprintf (DrivePath, "%c:\\", ('A' + d));

				switch (DriveType)
				{
				case DRIVE_REMOVABLE:
					sprintf (DriveDesc, "%c Drive (Removable)", ('A' + d));
					hTreeDrive = TV_AddItem (hTI, DriveDesc, ilIconRemovable, ilIconRemovable, DrivePath);
					TV_AddChildren (hTreeDrive, DrivePath);
					break;

				case DRIVE_FIXED:
					sprintf (DriveDesc, "%c Drive (Fixed)", ('A' + d));
					hTreeDrive = TV_AddItem (hTI, DriveDesc, ilIconFixedDrive, ilIconFixedDrive, DrivePath);
					TV_AddChildren (hTreeDrive, DrivePath);
					break;

				case DRIVE_NO_ROOT_DIR:
					sprintf (DriveDesc, "%c Drive (No Root Dir)", ('A' + d));
					hTreeDrive = TV_AddItem (hTI, DriveDesc, ilIconFixedDrive, ilIconFixedDrive, DrivePath);
					break;

				case DRIVE_REMOTE:
					sprintf (DriveDesc, "%c Drive (Network)", ('A' + d));
					hTreeDrive = TV_AddItem (hTI, DriveDesc, ilIconNetDrive, ilIconNetDrive, DrivePath);
					TV_AddChildren (hTreeDrive, DrivePath);
					break;

				case DRIVE_CDROM:
					sprintf (DriveDesc, "%c Drive (CDROM)", ('A' + d));
					hTreeDrive = TV_AddItem (hTI, DriveDesc, ilIconCDDrive, ilIconCDDrive, NULL);
					break;

				case DRIVE_RAMDISK:
					sprintf (DriveDesc, "%c Drive (RAM Disk)", ('A' + d));
					hTreeDrive = TV_AddItem (hTI, DriveDesc, ilIconRemovable, ilIconRemovable, DrivePath);
					break;

				case DRIVE_UNKNOWN:
				default:
					sprintf (DriveDesc, "%c Drive (Unknown Type)", ('A' + d));
					hTreeDrive = TV_AddItem (hTI, DriveDesc, ilIconFixedDrive, ilIconFixedDrive, DrivePath);
					break;
				}
			}
		}

		// select and expand the root item
		TreeView_SelectItem (hWndTreeView, hTI);
		TreeView_Expand (hWndTreeView, hTI, TVE_EXPAND);

		// expand out the Quake folder
		TV_SelectFolder (szQuakeFolder);

		// invalidate the window to ensure that no indeterminate halfway states remain
		InvalidateRect (hDlg, NULL, TRUE);

		// put the focus on the treeview
		SendMessage (hWndTreeView, WM_SETFOCUS, (WPARAM) NULL, 0);

		return TRUE;

	case WM_NOTIFY:
	{
		switch (LOWORD (wParam))
		{
		case IDC_LV_BSPFILES:
			if (((LPNMHDR) lParam)->code == NM_CLICK)
				FixupInteractionControls ();

			return TRUE;

		case IDC_TREE_FILES:
			if (((LPNMHDR) lParam)->code == TVN_ITEMEXPANDED)
			{
				LPNMTREEVIEW pnmtv = (LPNMTREEVIEW) lParam;

				if (pnmtv->action == TVE_EXPAND)
				{
					// handle the expansion
					if (pnmtv->itemNew.state != TVIS_EXPANDEDONCE) TV_HandleItemExpand (pnmtv->itemNew.hItem);
				}
				else if (pnmtv->action == TVE_COLLAPSE)
				{
					// not working...
					// SendMessage (hWndTreeView, TVM_EXPAND, TVE_COLLAPSE | TVE_COLLAPSERESET, (LPARAM) (HTREEITEM) pnmtv->itemNew.hItem);
				}
			}
			else if (((LPNMHDR) lParam)->code == TVN_SELCHANGED)
			{
				LPNMTREEVIEW pnmtv = (LPNMTREEVIEW) lParam;
				HTREEITEM hChild;
				int cbSelected;

				pnmtv->itemNew.mask = TVIF_PARAM | TVIF_CHILDREN;

				TreeView_GetItem (hWndTreeView, &pnmtv->itemNew);

				EnableWindow (GetDlgItem (hMainDialog, IDC_BTN_ADDFROMTREE), FALSE);
				EnableWindow (GetDlgItem (hMainDialog, IDC_BTN_ADDFOLDER), FALSE);

				if (pnmtv->itemNew.lParam != 0)
				{
					// check for a bsp
					char *itemname = (char *) pnmtv->itemNew.lParam;

					if (!stricmp (&itemname[strlen (itemname) - 4], ".bsp"))
						EnableWindow (GetDlgItem (hMainDialog, IDC_BTN_ADDFROMTREE), TRUE);
					else
					{
						// check all children of this item; if any are a BSP we also enable the Add Folder button
						hChild = TreeView_GetChild (hWndTreeView, pnmtv->itemNew.hItem);

						if (hChild)
						{
							do
							{
								TVITEM tvItem;
								char *tvItemName;

								tvItem.hItem = hChild;
								tvItem.mask = TVIF_PARAM;

								TreeView_GetItem (hWndTreeView, &tvItem);
								tvItemName = (char *) tvItem.lParam;

								// NULL item
								if (tvItem.lParam == 0) continue;

								if (!stricmp (&tvItemName[strlen (tvItemName) - 4], ".bsp"))
								{
									// one is all we need
									EnableWindow (GetDlgItem (hMainDialog, IDC_BTN_ADDFOLDER), TRUE);

									if (!stricmp (&itemname[strlen (itemname) - 4], ".pak"))
										SetWindowText (GetDlgItem (hMainDialog, IDC_BTN_ADDFOLDER), "Add PAK");
									else SetWindowText (GetDlgItem (hMainDialog, IDC_BTN_ADDFOLDER), "Add Folder");

									break;
								}
							} while ((hChild = TreeView_GetNextSibling (hWndTreeView, hChild)) != NULL);
						}
					}

					do
					{
						// never keep more than 20 items in the recent history
						int cbCount = SendMessage (hWndComboBox, CB_GETCOUNT, (WPARAM) 0, (LPARAM) 0);

						if (cbCount <= 20) break;

						// delete the least recently added item
						SendMessage (hWndComboBox, CB_DELETESTRING, (WPARAM) 0, (LPARAM) 0);
					} while (1);

					// update the combo box with the current path
					cbSelected = SendMessage (hWndComboBox, CB_ADDSTRING, (WPARAM) 0, (LPARAM) itemname);
					if (cbSelected != CB_ERR) SendMessage (hWndComboBox, CB_SETCURSEL, (WPARAM) cbSelected, (LPARAM) 0);
				}
			}

			return TRUE;
		}

		return TRUE;
	}

	case WM_COMMAND:
		switch (LOWORD (wParam))
		{
		case IDC_COMBO_CURRENTPATH:
			if (HIWORD (wParam) == CBN_SELENDOK)
			{
				char CurrentSelection[MAX_PATH];
				int cbSelected = SendMessage (hWndComboBox, CB_GETCURSEL, (WPARAM) 0, (LPARAM) 0);

				SendMessage (hWndComboBox, CB_GETLBTEXT, (WPARAM) cbSelected, (LPARAM) CurrentSelection);

				TV_SelectFolder (CurrentSelection);
			}

			return TRUE;

		case IDC_BTN_ADDFROMTREE:
			{
				// add from the tree view
				HTREEITEM hCurrentItem = TreeView_GetSelection (hWndTreeView);
				TVITEM tvItem;
				char textbuf[MAX_PATH];

				// get the current item
				tvItem.mask = TVIF_PARAM | TVIF_TEXT;
				tvItem.hItem = hCurrentItem;
				tvItem.pszText = textbuf;
				TreeView_GetItem (hWndTreeView, &tvItem);

				if (tvItem.lParam)
				{
					// add it
					AddItemToListView ((char *) tvItem.lParam, tvItem.pszText);
					FixupInteractionControls ();
				}
			}

			return TRUE;

		case IDC_BTN_ADDFOLDER:
			// add the contents of this folder or PAK
			{
				// add from the tree view
				HTREEITEM hCurrentItem = TreeView_GetSelection (hWndTreeView);
				TVITEM tvItem;

				// get the child
				hCurrentItem = TreeView_GetChild (hWndTreeView, hCurrentItem);

				// this should never happen
				if (!hCurrentItem) return TRUE;

				// suspend updates to the listview while adding
				SendMessage (hWndListView, WM_SETREDRAW, (WPARAM) FALSE, 0);

				do
				{
					char textbuf[MAX_PATH];

					// get the current item
					tvItem.mask = TVIF_PARAM | TVIF_TEXT;
					tvItem.hItem = hCurrentItem;
					tvItem.pszText = textbuf;
					TreeView_GetItem (hWndTreeView, &tvItem);

					if (tvItem.lParam)
					{
						// add it
						AddItemToListView ((char *) tvItem.lParam, tvItem.pszText);
						FixupInteractionControls ();
					}
				} while ((hCurrentItem = TreeView_GetNextSibling (hWndTreeView, hCurrentItem)) != NULL);

				// resume updates
				SendMessage (hWndListView, WM_SETREDRAW, (WPARAM) TRUE, 0);
			}

			return TRUE;

		case IDC_BUTTON_REMOVEFILE:
			// remove currently selected items
			// NOTE - ListView_DeleteItem will re-index the list view, so we must delete one at a time
			// until there are no more left to delete (MADNESS!!!)
			for (;;)
			{
				int i;
				int NumItems = SendMessage (hWndListView, LVM_GETITEMCOUNT, 0, 0);
				BOOL bDeleted = FALSE;

				for (i = 0; i < NumItems; i++)
				{
					if (ListView_GetItemState (hWndListView, i, LVIS_SELECTED) & LVIS_SELECTED)
					{
						ListView_DeleteItem (hWndListView, i);
						bDeleted = TRUE;
						break;
					}
				}

				// break if nothing was deleted (nothing more to delete)
				if (!bDeleted) break;
			}

			FixupInteractionControls ();
			return TRUE;

		case IDC_BUTTON_REMOVEALL:
			// empty the list view
			ListView_DeleteAllItems (hWndListView);
			FixupInteractionControls ();
			return TRUE;

		case IDC_BUTTON_PROCESSFILE:
		{
			int i;

			if (SelectedBSPs)
			{
				for (i = 0; ; i++)
				{
					// empty the selection list
					if (!SelectedBSPs[i]) break;
					Q_SafeFree (SelectedBSPs[i]);
				}

				Q_SafeFree (SelectedBSPs);
			}

			// get the number of BSPs to process, if there's none we just quit (should never
			// happen as this button should be disabled)
			if (!(NumSelectedBSPs = ListView_GetItemCount (hWndListView))) return TRUE;

			// alloc memory (one extra for NULL termination)
			SelectedBSPs = (char **) malloc ((NumSelectedBSPs + 1) * sizeof (char *));
			SelectedBSPs[NumSelectedBSPs] = NULL;

			// get them all
			for (i = 0; i < NumSelectedBSPs; i++)
			{
				LVITEM TheItem;
				char BSPText[MAX_PATH] = {0};
				char GroupTextBuf[MAX_PATH] = {0};

				memset (&TheItem, 0, sizeof (LVITEM));
				TheItem.mask = LVIF_GROUPID;
				TheItem.iItem = i;

				// get the item - do it this way because ListView_GetItem doesn't necessarily put the text into
				// the correct text buffer (per MSDN)
				ListView_GetItemText (hWndListView, i, 0, BSPText, MAX_PATH);
				ListView_GetItem (hWndListView, &TheItem);

				// get it's group
				LV_FindGroupText (GroupTextBuf, MAX_PATH, TheItem.iGroupId);

				// alloc memory for it and copy it in
				SelectedBSPs[i] = (char *) malloc (MAX_PATH); //strlen (BSPText) + strlen (GroupTextBuf) + 3 + MAX_PATH);

				strcpy (SelectedBSPs[i], GroupTextBuf);
				strcat (SelectedBSPs[i], "\\");
				strcat (SelectedBSPs[i], BSPText);
			}

			// run the processing dialog box
			DialogBox (hAppInstance, MAKEINTRESOURCE (IDD_DIALOG_PROCESS), hDlg, ProcessDlgProc);
			return TRUE;
		}

		default:
			break;
		}

		break;

	case WM_CLOSE:
		// finish up
		EndDialog (hDlg, 0);
		return TRUE;
	}

	// not handled
	return FALSE;
}


int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR szCmdLine, int iCmdShow)
{
	int i;
	char c;

	InitCommonControls ();

	if (!Is_WinXP ())
	{
		MessageBox (NULL, "This application requires Windows XP!", "Error", MB_OK | MB_ICONERROR);
		return -1;
	}

	// store app instance globally
	hAppInstance = hInstance;

	// default cos we're gonna be using this...!
	szQuakeFolder[0] = 0;

	// look on each drive for Quake
	for (c = 'C'; c <= 'Z'; c++)
	{
		UINT DriveType = GetDriveType (va ("%c:\\", c));

		// don't check these types
		if (DriveType == DRIVE_NO_ROOT_DIR) continue;
		if (DriveType == DRIVE_UNKNOWN) continue;
		if (DriveType == DRIVE_CDROM) continue;
		if (DriveType == DRIVE_RAMDISK) continue;

		// check all of the test folders
		for (i = 0; ; i++)
		{
			FILE *f;

			// no more folders to test
			if (!szTestFolders[i]) break;

			// look for a config.cfg file (indicating it's present)
			sprintf (szQuakeFolder, "%c%s\\ID1\\config.cfg", c, szTestFolders[i]);

			f = fopen (szQuakeFolder, "rb");

			if (f)
			{
				// found it
				fclose (f);

				// make the maps folder (ensures it exists because we're going to be using it to write crap into!)
				sprintf (szQuakeFolder, "%c%s\\ID1", c, szTestFolders[i]);
				_mkdir (szQuakeFolder);

				// now run the dialog and get out
				DialogBox (hAppInstance, MAKEINTRESOURCE (IDD_DIALOG_MAIN), NULL, (DLGPROC) MHColourDlgProc);
				return 0;
			}
		}
	}

	DialogBox (hAppInstance, MAKEINTRESOURCE (IDD_DIALOG_MAIN), NULL, (DLGPROC) MHColourDlgProc);
	return 0;
}
